/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.ui.masterdetails;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.StaticSelectionCommandAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rmf.reqif10.search.criteria.Criteria;
import org.eclipse.rmf.reqif10.search.criteria.CriteriaFactory;
import org.eclipse.rmf.reqif10.search.criteria.Criterias;
import org.eclipse.rmf.reqif10.search.criteria.Operator;
import org.eclipse.rmf.reqif10.search.criteria.impl.CriteriaImpl;
import org.eclipse.rmf.reqif10.search.criteria.provider.CriteriaItemProviderAdapterFactory;
import org.eclipse.rmf.reqif10.search.ui.ReqIFSearchUIPlugin;
import org.eclipse.rmf.reqif10.search.ui.masterdetails.CriteriaDetailsPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class CriteriasMasterDetailsBlock
extends MasterDetailsBlock {
    protected static final String HORIZONTAL_ORIENTATION_ICON_PATH = "full/obj16/Horizontal_Orientation.gif";
    protected static final String VERTICAL_ORIENTATION_ICON_PATH = "full/obj16/Vertical_Orientation.gif";
    protected static final String HORIZONTAL_ORIENTATION_ACTION_LABEL = CriteriasMasterDetailsBlock.getString("_UI_HorizontalOrientation_label");
    protected static final String VERTICAL_ORIENTATION_ACTION_LABEL = CriteriasMasterDetailsBlock.getString("_UI_VerticalOrientation_label");
    protected IManagedForm managedForm;
    private TreeViewer treeViewer;
    private Resource resource;
    private ComposedAdapterFactory adapterFactory;
    private EditingDomain editingDomain;
    private String REQIF_SEARCH_CRITERIA = "REQIF_SEARCH_CRITERIA";
    private String CRITERIA_SEPARATOR = "CRITERIA";
    private String CRITERIAS_SEPARATOR = "CRITERIAS";
    private Criterias criterias;

    public void createContent(final IManagedForm managedForm) {
        super.createContent(managedForm);
        managedForm.getForm().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                managedForm.getForm().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        CriteriasMasterDetailsBlock.this.dispose();
                    }
                });
            }
        });
    }

    private void createAdapterFactory() {
        this.adapterFactory = new ComposedAdapterFactory();
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new CriteriaItemProviderAdapterFactory());
    }

    private void createEditingDomain() {
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                CriteriasMasterDetailsBlock.this.handleCommandStackChanged(((CommandStack)event.getSource()).getMostRecentCommand());
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack);
    }

    protected void handleCommandStackChanged(Command mostRecentCommand) {
        if (mostRecentCommand != null) {
            this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
        }
    }

    protected void setSelectionToViewer(Collection<?> selections) {
        if (selections != null && !selections.isEmpty()) {
            final Object[] selectionsArray = selections.toArray();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (CriteriasMasterDetailsBlock.this.treeViewer != null) {
                        CriteriasMasterDetailsBlock.this.treeViewer.setSelection((ISelection)new StructuredSelection(selectionsArray), true);
                    }
                }
            };
            if (!this.managedForm.getForm().isDisposed()) {
                this.managedForm.getForm().getDisplay().asyncExec(runnable);
            }
        }
    }

    private void createTreeViewer(Composite parent) {
        Tree tree = this.getToolkit().createTree(parent, 2048);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer = new TreeViewer(tree);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        this.managedForm = managedForm;
        this.createAdapterFactory();
        this.createEditingDomain();
        FormToolkit toolkit = this.getToolkit();
        Section criteriasSection = toolkit.createSection(parent, 320);
        criteriasSection.setText("Criterias");
        final SectionPart sectionPart = new SectionPart(criteriasSection);
        Composite composite = toolkit.createComposite((Composite)criteriasSection, 0);
        criteriasSection.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createTreeViewer(composite);
        this.loadInput();
        this.treeViewer.setInput((Object)this.resource);
        this.treeViewer.expandAll();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)sectionPart, CriteriasMasterDetailsBlock.this.treeViewer.getSelection());
            }
        });
        new TreeViewerActionProvider(this.treeViewer);
    }

    private void loadInput() {
        this.resource = this.editingDomain.getResourceSet().createResource(URI.createURI((String)"TEMP"));
        this.criterias = CriteriaFactory.eINSTANCE.createCriterias();
        this.resource.getContents().add((Object)this.criterias);
        String input = ReqIFSearchUIPlugin.getPlugin().getDialogSettings().get(this.REQIF_SEARCH_CRITERIA);
        if (input != null && !input.trim().isEmpty()) {
            String[] criteriasString = null;
            criteriasString = input.contains(this.CRITERIAS_SEPARATOR) ? input.split(this.CRITERIAS_SEPARATOR) : new String[]{input};
            String[] stringArray = criteriasString;
            int n = criteriasString.length;
            int n2 = 0;
            while (n2 < n) {
                String criteriaString = stringArray[n2];
                String[] criteriaDetails = criteriaString.split(this.CRITERIA_SEPARATOR);
                Criteria criteria = CriteriaFactory.eINSTANCE.createCriteria();
                criteria.setFeatureName(criteriaDetails[0]);
                criteria.setSerachedText(criteriaDetails[1]);
                criteria.setOperator(Operator.get((String)criteriaDetails[2]));
                criteria.setReplacementText(criteriaDetails[3]);
                criteria.setSensitiveCase(Boolean.valueOf(criteriaDetails[4]).booleanValue());
                this.criterias.getCriterias().add((Object)criteria);
                ++n2;
            }
        } else {
            this.criterias.getCriterias().add((Object)CriteriaFactory.eINSTANCE.createCriteria());
        }
    }

    private void saveInput() {
        StringBuilder criteriaStringBuilder = new StringBuilder();
        Criterias criterias = (Criterias)this.resource.getContents().get(0);
        EList criteriasList = criterias.getCriterias();
        int i = 0;
        while (i < criteriasList.size()) {
            Criteria criteria = (Criteria)criteriasList.get(i);
            criteriaStringBuilder.append(criteria.getFeatureName()).append(this.CRITERIA_SEPARATOR).append(criteria.getSerachedText()).append(this.CRITERIA_SEPARATOR).append(criteria.getOperator()).append(this.CRITERIA_SEPARATOR).append(criteria.getReplacementText()).append(this.CRITERIA_SEPARATOR).append(criteria.isSensitiveCase());
            if (i != criteriasList.size() - 1) {
                criteriaStringBuilder.append(this.CRITERIAS_SEPARATOR);
            }
            ++i;
        }
        ReqIFSearchUIPlugin.getPlugin().getDialogSettings().put(this.REQIF_SEARCH_CRITERIA, criteriaStringBuilder.toString());
    }

    protected void registerPages(DetailsPart detailsPart) {
        CriteriaDetailsPage criteriaDetailsPage = new CriteriaDetailsPage(this.editingDomain);
        detailsPart.registerPage(CriteriaImpl.class, (IDetailsPage)criteriaDetailsPage);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        form.getToolBarManager().add(this.createHorizontalOrientationAction(managedForm));
        form.getToolBarManager().add(this.createVerticalOrientationAction(managedForm));
    }

    protected IAction createHorizontalOrientationAction(final IManagedForm managedForm) {
        ImageDescriptor imageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(ReqIFSearchUIPlugin.INSTANCE.getImage(HORIZONTAL_ORIENTATION_ICON_PATH));
        Action horizontalOrientationAction = new Action(HORIZONTAL_ORIENTATION_ACTION_LABEL, 8){

            public void run() {
                CriteriasMasterDetailsBlock.this.sashForm.setOrientation(256);
                managedForm.getForm().reflow(true);
            }
        };
        horizontalOrientationAction.setChecked(false);
        horizontalOrientationAction.setToolTipText(HORIZONTAL_ORIENTATION_ACTION_LABEL);
        horizontalOrientationAction.setImageDescriptor(imageDescriptor);
        return horizontalOrientationAction;
    }

    protected IAction createVerticalOrientationAction(final IManagedForm managedForm) {
        ImageDescriptor imageDescriptor = ExtendedImageRegistry.INSTANCE.getImageDescriptor(ReqIFSearchUIPlugin.INSTANCE.getImage(VERTICAL_ORIENTATION_ICON_PATH));
        Action verticalOrientationAction = new Action(VERTICAL_ORIENTATION_ACTION_LABEL, 8){

            public void run() {
                CriteriasMasterDetailsBlock.this.sashForm.setOrientation(512);
                managedForm.getForm().reflow(true);
            }
        };
        verticalOrientationAction.setChecked(false);
        verticalOrientationAction.setToolTipText(VERTICAL_ORIENTATION_ACTION_LABEL);
        verticalOrientationAction.setImageDescriptor(imageDescriptor);
        return verticalOrientationAction;
    }

    protected FormToolkit getToolkit() {
        return this.managedForm.getToolkit();
    }

    protected Collection<IAction> getToolbarActions(IManagedForm managedForm) {
        return Collections.emptyList();
    }

    protected static String getString(String key) {
        return ReqIFSearchUIPlugin.INSTANCE.getString(key);
    }

    protected void dispose() {
        this.saveInput();
        try {
            this.resource.delete(null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.adapterFactory.dispose();
    }

    public Collection<Criteria> getCriterias() {
        return this.criterias.getCriterias();
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected class TreeViewerActionProvider
    implements IMenuListener {
        protected Collection<StaticSelectionCommandAction> createChildActions;
        private DeleteAction deleteAction;
        private UndoAction undoAction;
        private RedoAction redoAction;
        private CutAction cutAction;
        private CopyAction copyAction;
        private PasteAction pasteAction;
        private final TreeViewer viewer;
        private final ISelectionChangedListener selectionChangedListener;

        public TreeViewerActionProvider(TreeViewer viewer) {
            this.viewer = viewer;
            this.initializeActions();
            this.selectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    TreeViewerActionProvider.this.selectionChanged((IStructuredSelection)event.getSelection());
                }
            };
            this.viewer.addSelectionChangedListener(this.selectionChangedListener);
            this.viewer.getTree().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TreeViewerActionProvider.this.viewer.removeSelectionChangedListener(TreeViewerActionProvider.this.selectionChangedListener);
                }
            });
            MenuManager manager = new MenuManager();
            Menu menu = manager.createContextMenu(viewer.getControl());
            manager.addMenuListener((IMenuListener)this);
            manager.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
        }

        private void initializeActions() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.deleteAction = this.createDeleteAction();
            this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.undoAction = this.createUndoAction();
            this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
            this.redoAction = this.createRedoAction();
            this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
            this.cutAction = this.createCutAction();
            this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
            this.copyAction = this.createCopyAction();
            this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.pasteAction = this.createPasteAction();
            this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        }

        protected DeleteAction createDeleteAction() {
            return new DeleteAction(CriteriasMasterDetailsBlock.this.editingDomain, true);
        }

        protected UndoAction createUndoAction() {
            return new UndoAction(CriteriasMasterDetailsBlock.this.editingDomain);
        }

        protected RedoAction createRedoAction() {
            return new RedoAction(CriteriasMasterDetailsBlock.this.editingDomain);
        }

        protected CutAction createCutAction() {
            return new CutAction(CriteriasMasterDetailsBlock.this.editingDomain);
        }

        protected CopyAction createCopyAction() {
            return new CopyAction(CriteriasMasterDetailsBlock.this.editingDomain);
        }

        protected PasteAction createPasteAction() {
            return new PasteAction(CriteriasMasterDetailsBlock.this.editingDomain);
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            MenuManager submenuManager = null;
            submenuManager = new MenuManager("New");
            CriteriasMasterDetailsBlock.this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
            menuManager.add((IContributionItem)submenuManager);
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
            menuManager.add((IContributionItem)new Separator());
            menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        }

        private void selectionChanged(IStructuredSelection selection) {
            this.deleteAction.selectionChanged(selection);
            this.undoAction.update();
            this.redoAction.update();
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
            Collection newChildDescriptors = null;
            if (selection.size() == 1) {
                Object object = selection.getFirstElement();
                newChildDescriptors = CriteriasMasterDetailsBlock.this.editingDomain.getNewChildDescriptors(object, null);
            }
            this.createChildActions = this.generateCreateChildActions(newChildDescriptors, (ISelection)selection);
        }

        protected Collection<StaticSelectionCommandAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
            ArrayList<StaticSelectionCommandAction> actions = new ArrayList<StaticSelectionCommandAction>();
            if (descriptors != null) {
                for (Object descriptor : descriptors) {
                    actions.add((StaticSelectionCommandAction)this.createCreateChildAction(selection, descriptor));
                }
            }
            return actions;
        }

        protected CreateChildAction createCreateChildAction(ISelection selection, Object descriptor) {
            return new CreateChildAction(CriteriasMasterDetailsBlock.this.editingDomain, selection, descriptor);
        }
    }
}

