/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation;

import java.util.Collection;
import java.util.EventObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rmf.reqif10.ReqIF10Package;
import org.eclipse.rmf.reqif10.SpecHierarchy;
import org.eclipse.rmf.reqif10.SpecRelation;
import org.eclipse.rmf.reqif10.Specification;
import org.eclipse.rmf.reqif10.pror.editor.actions.SpecificationWebPrintAction;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrAgileGrid;
import org.eclipse.rmf.reqif10.pror.editor.agilegrid.ProrAgileGridViewer;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10ActionBarContributor;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10Editor;
import org.eclipse.rmf.reqif10.pror.editor.presentation.ReqifSpecificationEditorInput;
import org.eclipse.rmf.reqif10.pror.filter.ReqifFilter;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecificationEditor
extends EditorPart
implements IEditingDomainProvider,
IMenuListener {
    public static final String EDITOR_ID = "org.eclipse.rmf.reqif10.pror.SpecificationEditor";
    private Specification specification;
    private ProrAgileGridViewer prorAgileGridViewer;
    private Reqif10ActionBarContributor reqifActionBarContributor;
    private Reqif10Editor reqifEditor;
    private ISelectionChangedListener selectionChangedListener;
    private ISelectionListener contentOutlineSelectionListener;
    private CommandStackListener commandStackListener;
    private AdapterImpl changeNameListener;
    private AdapterImpl deleteSpecListener;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof ReqifSpecificationEditorInput)) {
            throw new IllegalArgumentException("Wrong input type: " + input);
        }
        this.reqifEditor = ((ReqifSpecificationEditorInput)input).getReqifEditor();
        this.specification = ((ReqifSpecificationEditorInput)input).getSpec();
        this.reqifActionBarContributor = (Reqif10ActionBarContributor)site.getActionBarContributor();
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.setPartName(input.getName());
        site.getActionBars().setGlobalActionHandler(ActionFactory.PRINT.getId(), (IAction)new SpecificationWebPrintAction(this.reqifEditor.getEditingDomain(), this.reqifEditor.getAdapterFactory()));
    }

    public void createPartControl(Composite parent) {
        this.createSpecificationPart(parent);
        this.registerChangeNameListener();
        this.registerDeleteListener();
        this.registerSelectionChangedListener();
        this.registerCommandStackListener(parent);
    }

    private void createSpecificationPart(Composite containter) {
        this.prorAgileGridViewer = new ProrAgileGridViewer(containter, this.reqifEditor.getAdapterFactory(), this.getEditingDomain(), this.reqifActionBarContributor.getAgileCellEditorActionHandler());
        this.prorAgileGridViewer.setInput(this.specification);
        this.getSite().setSelectionProvider((ISelectionProvider)this.prorAgileGridViewer);
        if (!this.specification.getChildren().isEmpty()) {
            this.prorAgileGridViewer.setSelection((ISelection)new StructuredSelection(this.specification.getChildren().get(0)));
            this.reqifEditor.getPropertySheetPage().selectionChanged((IWorkbenchPart)this, this.prorAgileGridViewer.getSelection());
        }
        this.buildContextMenu();
    }

    private void registerCommandStackListener(final Composite parent) {
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                parent.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        SpecificationEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            Collection affectedObjects = mostRecentCommand.getAffectedObjects();
                            SpecificationEditor.this.setSelectionToViewer(affectedObjects);
                        }
                    }
                });
            }
        };
        this.getEditingDomain().getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    private void registerChangeNameListener() {
        this.changeNameListener = new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeature() == ReqIF10Package.Literals.SPEC_ELEMENT_WITH_ATTRIBUTES__VALUES) {
                    ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)SpecificationEditor.this.reqifEditor.getAdapterFactory(), (Object)SpecificationEditor.this.specification);
                    SpecificationEditor.this.setPartName(ip.getText((Object)SpecificationEditor.this.specification));
                }
            }
        };
        this.specification.eAdapters().add((Object)this.changeNameListener);
    }

    private void registerDeleteListener() {
        EObject container = this.specification.eContainer();
        this.deleteSpecListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == ReqIF10Package.Literals.SPECIFICATION__CHILDREN || msg.getEventType() == 4 && msg.getOldValue() == SpecificationEditor.this.specification) {
                    SpecificationEditor.this.getEditorSite().getPage().closeEditor((IEditorPart)SpecificationEditor.this, false);
                }
            }
        };
        container.eAdapters().add((Object)this.deleteSpecListener);
    }

    private void setSelectionToViewer(Collection<?> collection) {
        final Collection<?> theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (SpecificationEditor.this.prorAgileGridViewer != null) {
                        SpecificationEditor.this.prorAgileGridViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            this.getSite().getShell().getDisplay().syncExec(runnable);
        }
    }

    private void registerSelectionChangedListener() {
        this.selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SpecificationEditor.this.reqifEditor.setStatusLineManager(event.getSelection());
            }
        };
        this.prorAgileGridViewer.addSelectionChangedListener(this.selectionChangedListener);
        this.contentOutlineSelectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                if (selection instanceof IStructuredSelection) {
                    for (Object item : (IStructuredSelection)selection) {
                        if (!(item instanceof SpecHierarchy)) continue;
                        SpecificationEditor.this.prorAgileGridViewer.setSelection(selection);
                        ((ProrAgileGrid)SpecificationEditor.this.prorAgileGridViewer.getControl()).scrollToFocus();
                        return;
                    }
                }
            }
        };
        this.getSite().getPage().addSelectionListener(this.contentOutlineSelectionListener);
    }

    private MenuManager buildContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(this.prorAgileGridViewer.getControl());
        this.prorAgileGridViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)this.prorAgileGridViewer));
        return contextMenu;
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.reqifEditor.getContentOutlinePage();
        }
        if (key.equals(IPropertySheetPage.class)) {
            return this.reqifEditor.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public EditingDomain getEditingDomain() {
        return this.reqifEditor.getEditingDomain();
    }

    public void doSave(IProgressMonitor monitor) {
        this.reqifEditor.doSave(monitor);
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
        this.reqifEditor.doSaveAs();
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
        this.prorAgileGridViewer.getControl().setFocus();
    }

    public void dispose() {
        this.prorAgileGridViewer.dispose();
        if (this.selectionChangedListener != null) {
            this.prorAgileGridViewer.removeSelectionChangedListener(this.selectionChangedListener);
            this.selectionChangedListener = null;
        }
        if (this.contentOutlineSelectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this.contentOutlineSelectionListener);
            this.contentOutlineSelectionListener = null;
        }
        if (this.commandStackListener != null) {
            this.getEditingDomain().getCommandStack().removeCommandStackListener(this.commandStackListener);
            this.commandStackListener = null;
        }
        if (this.changeNameListener != null) {
            this.specification.eAdapters().remove((Object)this.changeNameListener);
            this.changeNameListener = null;
        }
        if (this.deleteSpecListener != null) {
            this.specification.eAdapters().remove((Object)this.deleteSpecListener);
            this.deleteSpecListener = null;
        }
        if (this.reqifEditor.getActionBarContributor().getActiveEditor() == this) {
            this.reqifEditor.getActionBarContributor().setActiveEditor(null);
        }
        super.dispose();
    }

    public Reqif10Editor getReqifEditor() {
        return this.reqifEditor;
    }

    public void setShowSpecRelations(boolean checked) {
        ISelection sel = this.prorAgileGridViewer.getSelection();
        this.prorAgileGridViewer.setShowSpecRelations(checked);
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof SpecRelation) {
                selection = new StructuredSelection(this.specification.getChildren().get(0));
            }
            this.prorAgileGridViewer.setSelection((ISelection)selection);
        }
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public Reqif10ActionBarContributor getReqifActionBarContributor() {
        return this.reqifActionBarContributor;
    }

    public AdapterFactory getAdapterFactory() {
        return this.reqifEditor.getAdapterFactory();
    }

    public void setFilter(ReqifFilter filter) {
        this.prorAgileGridViewer.setFilter(filter);
    }
}

