/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.rmf.reqif10.DatatypeDefinition;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.edit.presentation.service.PresentationInterface;
import org.eclipse.rmf.reqif10.pror.editor.preferences.PreferenceConstants;
import org.eclipse.rmf.reqif10.pror.editor.presentation.Reqif10EditorPlugin;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationEditorInterface;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationServiceManager;
import org.eclipse.rmf.reqif10.pror.util.ProrUtil;
import org.eclipse.ui.IStartup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckDefaultPresentations
implements IStartup {
    public void earlyStartup() {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        for (PresentationInterface presentation : PresentationServiceManager.getPresentationInterfaceMap().values()) {
            PresentationEditorInterface editorInterface;
            Class<? extends DatatypeDefinition> dd;
            ProrPresentationConfiguration config = presentation.getConfigurationInstance();
            ItemProviderAdapter ip = ProrUtil.getItemProvider((AdapterFactory)adapterFactory, (Object)config);
            if (!(ip instanceof PresentationEditorInterface) || (dd = (editorInterface = (PresentationEditorInterface)ip).suggestAsDefault()) == null) continue;
            this.checkDefault(dd, config.getClass());
        }
    }

    private void checkDefault(Class<? extends DatatypeDefinition> dd, Class<? extends ProrPresentationConfiguration> config) {
        IPreferenceStore store = Reqif10EditorPlugin.getPlugin().getPreferenceStore();
        String defaultPresentation = store.getString(dd.getSimpleName());
        System.out.println("Retrieving for: " + dd.getSimpleName());
        System.out.println("Constant: " + PreferenceConstants.P_DEFAULT_PRESENTATION_STRING);
        if (defaultPresentation.equals("default_presentation_build_in")) {
            System.out.println("Not setting default presentation for " + dd.getSimpleName() + ", as the user forced the default.");
        } else if (defaultPresentation == null || defaultPresentation.equals("")) {
            store.setValue(dd.getSimpleName(), config.getCanonicalName());
            System.out.println("Installed as default for " + dd.getSimpleName() + ": " + config.getSimpleName());
        } else {
            System.out.println("Not replacing default for " + dd.getSimpleName() + " with " + config.getSimpleName() + ", as there is already a default: " + defaultPresentation);
        }
    }
}

