/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.traceeventlogger;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.eclipse.tracecompass.traceeventlogger.InnerEvent;
import org.eclipse.tracecompass.traceeventlogger.LogUtils;

public class SnapshotHandler
extends FileHandler {
    private int fMaxEvents = 1000000;
    private double fTimeout = 30.0;
    protected String fFilePath = "request-";
    private volatile boolean fIsEnabled = true;
    private Deque<InnerEvent> fData = new ArrayDeque<InnerEvent>();
    private Map<String, Map<String, List<InnerEvent>>> fStacks = new HashMap<String, Map<String, List<InnerEvent>>>();
    protected volatile boolean fAsynchronousDrain = true;

    public SnapshotHandler() throws IOException, SecurityException {
        this.configure();
    }

    public SnapshotHandler(double timeout) throws IOException, SecurityException {
        this.configure();
        if (timeout > 0.0) {
            this.fTimeout = timeout;
        }
    }

    private void configure() {
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String prop = manager.getProperty(cname + ".maxEvents");
        this.fMaxEvents = 1000000;
        try {
            this.fMaxEvents = Integer.parseInt(prop.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fMaxEvents < 0) {
            this.fMaxEvents = 1000000;
        }
        this.fTimeout = 10000.0;
        prop = manager.getProperty(cname + ".timeout");
        try {
            this.fTimeout = Double.parseDouble(prop.trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fTimeout < 0.0) {
            this.fTimeout = 30.0;
        }
        this.fFilePath = "request-";
        prop = manager.getProperty(cname + ".filePath");
        try {
            this.fFilePath = prop.trim();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        return this.fIsEnabled && logRecord != null && super.isLoggable(logRecord) && logRecord.getLevel().intValue() <= Level.FINE.intValue() && logRecord instanceof LogUtils.TraceEventLogRecord;
    }

    private boolean addToSnapshot(LogRecord message) {
        String phase;
        InnerEvent event = InnerEvent.create(message);
        if (event == null) {
            return false;
        }
        this.fData.add(event);
        while (this.fData.size() > this.fMaxEvents) {
            this.fData.remove();
        }
        Map pidMap = this.fStacks.computeIfAbsent(event.getPid(), unused -> new HashMap());
        List stack = pidMap.computeIfAbsent(event.getTid(), unused -> new ArrayList());
        switch (phase = event.getPhase()) {
            case "B": {
                stack.add(event);
                break;
            }
            case "E": {
                double delta;
                InnerEvent lastEvent = (InnerEvent)stack.remove(stack.size() - 1);
                if (!stack.isEmpty() || !((delta = (event.getTs() - lastEvent.getTs()) * 1.0E-6) > this.fTimeout)) break;
                if (this.fAsynchronousDrain) {
                    this.drain(this.fData);
                    break;
                }
                this.drainTrace(this.fData).run();
                break;
            }
        }
        return true;
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (record != null) {
            this.addToSnapshot(record);
        }
        super.publish(record);
    }

    private void drain(Deque<InnerEvent> data) {
        Thread thread = new Thread(this.drainTrace(data));
        thread.setName("Trace Drainer");
        thread.start();
    }

    private Runnable drainTrace(Deque<InnerEvent> data) {
        return () -> {
            Path path = new File(this.fFilePath + Long.toString((long)((InnerEvent)data.getFirst()).getTs()) + ".json").toPath();
            try (BufferedWriter fw = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
                fw.write(91);
                boolean first = true;
                for (InnerEvent event : data) {
                    if (first) {
                        first = false;
                    } else {
                        fw.write(44);
                        fw.write(10);
                    }
                    fw.write(event.getMessage());
                }
                data.clear();
                fw.write(93);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        };
    }

    public void setEnabled(Boolean isEnabled) {
        this.fIsEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.fIsEnabled;
    }
}

