/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.discoverer;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.infra.discovery.core.annotations.Parameter;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.java.discoverer.JavaModelUtils;
import org.eclipse.modisco.java.discoverer.internal.TranslateJavaModelToKdm;

public class DiscoverKDMModelFromJavaModel
extends AbstractModelDiscoverer<IFile> {
    private static final String XMI_EXTENSION = ".xmi";
    public static final String ID = "org.eclipse.modisco.java.discoverer.javaToKDM";
    private String pathToTransformation = null;

    @Parameter(name="PATH_TO_TRANSFORMATION", description="Indicates which .asm file to use for the ATL transformation (specified as a java URL)")
    public void setPathToTransformation(String pathToTransformation) {
        this.pathToTransformation = pathToTransformation;
    }

    public boolean isApplicableTo(IFile file) {
        return JavaModelUtils.isJavaModelFile(file);
    }

    protected void basicDiscoverElement(IFile file, IProgressMonitor monitor) throws DiscoveryException {
        try {
            String javaFilePath;
            TranslateJavaModelToKdm kdmTranslater = new TranslateJavaModelToKdm();
            if (this.pathToTransformation != null) {
                kdmTranslater.setPathToTransformation(this.pathToTransformation);
            }
            if ((javaFilePath = file.getFullPath().toString()).endsWith("_java.xmi")) {
                javaFilePath = javaFilePath.substring(0, javaFilePath.length() - "_java.xmi".length());
            } else if (javaFilePath.endsWith(XMI_EXTENSION)) {
                javaFilePath = javaFilePath.substring(0, javaFilePath.length() - XMI_EXTENSION.length());
            }
            URI kdmModelUri = URI.createPlatformResourceURI((String)(String.valueOf(javaFilePath) + "_kdm.xmi"), (boolean)true);
            this.setDefaultTargetURI(kdmModelUri);
            URI javaModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource kdmResource = kdmTranslater.getKDMModelFromJavaModelWithCustomTransformation(javaModelURI, null, kdmModelUri);
            this.getResourceSet().getResources().add((Object)kdmResource);
            this.setTargetModel(kdmResource);
        }
        catch (Exception e) {
            throw new DiscoveryException("Error discovering KDM model", (Throwable)e);
        }
    }
}

