/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.refactoring;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.io.Files;
import com.google.javascript.refactoring.CodeReplacement;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApplySuggestedFixes {
    private static final Ordering<CodeReplacement> ORDER_CODE_REPLACEMENTS = Ordering.natural().onResultOf((Function)new Function<CodeReplacement, Integer>(){

        public Integer apply(CodeReplacement replacement) {
            return replacement.getStartPosition();
        }
    }).compound((Comparator)Ordering.natural().onResultOf((Function)new Function<CodeReplacement, Integer>(){

        public Integer apply(CodeReplacement replacement) {
            return replacement.getLength();
        }
    })).compound((Comparator)Ordering.natural().onResultOf((Function)new Function<CodeReplacement, String>(){

        public String apply(CodeReplacement replacement) {
            return replacement.getSortKey();
        }
    }));

    public static void applySuggestedFixesToFiles(Iterable<SuggestedFix> fixes) throws IOException {
        HashSet filenames = new HashSet();
        for (SuggestedFix suggestedFix : fixes) {
            filenames.addAll(suggestedFix.getReplacements().keySet());
        }
        HashMap<String, String> filenameToCodeMap = new HashMap<String, String>();
        for (String filename : filenames) {
            filenameToCodeMap.put(filename, Files.toString((File)new File(filename), (Charset)StandardCharsets.UTF_8));
        }
        Map<String, String> map = ApplySuggestedFixes.applySuggestedFixesToCode(fixes, filenameToCodeMap);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            Files.write((CharSequence)entry.getValue(), (File)new File(entry.getKey()), (Charset)StandardCharsets.UTF_8);
        }
    }

    public static Map<String, String> applySuggestedFixesToCode(Iterable<SuggestedFix> fixes, Map<String, String> filenameToCodeMap) {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        for (SuggestedFix fix : fixes) {
            builder.putAll(fix.getReplacements());
        }
        ImmutableSetMultimap replacementsMap = builder.build();
        ImmutableMap.Builder newCodeMap = ImmutableMap.builder();
        for (Map.Entry entry : Multimaps.asMap((SetMultimap)replacementsMap).entrySet()) {
            String filename = (String)entry.getKey();
            if (!filenameToCodeMap.containsKey(filename)) {
                throw new IllegalArgumentException("filenameToCodeMap missing code for file: " + filename);
            }
            Set replacements = (Set)entry.getValue();
            String newCode = ApplySuggestedFixes.applyCodeReplacements(replacements, filenameToCodeMap.get(filename));
            newCodeMap.put((Object)filename, (Object)newCode);
        }
        return newCodeMap.build();
    }

    public static String applyCodeReplacements(Iterable<CodeReplacement> replacements, String code) {
        List sortedReplacements = ORDER_CODE_REPLACEMENTS.sortedCopy(replacements);
        ApplySuggestedFixes.validateNoOverlaps(sortedReplacements);
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        for (CodeReplacement replacement : sortedReplacements) {
            sb.append(code, lastIndex, replacement.getStartPosition());
            sb.append(replacement.getNewContent());
            lastIndex = replacement.getStartPosition() + replacement.getLength();
        }
        if (lastIndex <= code.length()) {
            sb.append(code.substring(lastIndex));
        }
        return sb.toString();
    }

    private static void validateNoOverlaps(List<CodeReplacement> replacements) {
        int start = -1;
        for (CodeReplacement replacement : replacements) {
            if (replacement.getStartPosition() < start) {
                throw new IllegalArgumentException("Found overlap between code replacements!\n" + Joiner.on((String)"\n\n").join(replacements));
            }
            start = Math.max(start, replacement.getStartPosition() + replacement.getLength());
        }
    }
}

