/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.hover;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.php.internal.ui.editor.hover.AbstractPHPEditorTextHover;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.ui.editor.hover.IHoverMessageDecorator;
import org.eclipse.php.ui.editor.hover.IPHPTextHover;
import org.eclipse.ui.IEditorPart;

public class PHPTextHoverProxy
extends AbstractPHPEditorTextHover
implements IPHPTextHover,
ITextHoverExtension,
IInformationProviderExtension2 {
    private PHPEditorTextHoverDescriptor fHoverDescriptor;
    private IPHPTextHover fHover;

    public PHPTextHoverProxy(PHPEditorTextHoverDescriptor descriptor, IEditorPart editor, IPreferenceStore store) {
        this.fHoverDescriptor = descriptor;
        this.setEditor(editor);
        this.setPreferenceStore(store);
    }

    public void setPreferenceStore(IPreferenceStore store) {
        super.setPreferenceStore(store);
        if (this.fHover != null) {
            this.fHover.setPreferenceStore(this.getPreferenceStore());
        }
    }

    public void setEditor(IEditorPart editor) {
        super.setEditor(editor);
        if (this.fHover != null && this.getEditor() != null) {
            this.fHover.setEditor(this.getEditor());
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverRegion(textViewer, offset);
        }
        return null;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.ensureHoverCreated()) {
            return this.fHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    @Override
    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.ensureHoverCreated()) {
            if (this.fHover instanceof ITextHoverExtension2) {
                return ((ITextHoverExtension2)this.fHover).getHoverInfo2(textViewer, hoverRegion);
            }
            return this.fHover.getHoverInfo(textViewer, hoverRegion);
        }
        return null;
    }

    private boolean ensureHoverCreated() {
        if (!this.isEnabled() || this.fHoverDescriptor == null) {
            return false;
        }
        return this.isCreated() || this.createHover();
    }

    private boolean isCreated() {
        return this.fHover != null;
    }

    private boolean createHover() {
        this.fHover = this.fHoverDescriptor.createTextHover();
        if (this.fHover != null && this.getEditor() != null) {
            this.fHover.setEditor(this.getEditor());
        }
        return this.isCreated();
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof ITextHoverExtension) {
            return ((ITextHoverExtension)this.fHover).getHoverControlCreator();
        }
        return null;
    }

    @Override
    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.ensureHoverCreated() && this.fHover instanceof IInformationProviderExtension2) {
            return ((IInformationProviderExtension2)this.fHover).getInformationPresenterControlCreator();
        }
        return null;
    }

    @Override
    public IHoverMessageDecorator getMessageDecorator() {
        return this.fHover.getMessageDecorator();
    }
}

