/*******************************************************************************
 * Copyright   2007 Sybase, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.sqlbuilder.model;


/**
 * This interface defines the set of properties which determine whether the
 * current schema name is omitted from SQL generated by the SQL Query Builder.
 */
public interface IOmitSchemaInfo  {

    /**
     * Gets whether or not to omit the current schema name in SQL generated by
     * the SQL Builder.
     * 
     * @return true when the current schema should be omitted, otherwise false.
     */
    public boolean getOmitCurrentSchema();
      
    /**
     * Sets whether or not to omit the current schema name in SQL generated by
     * the SQL Builder.
     * 
     */
    public void setOmitCurrentSchema(boolean omitCurrentSchema);
      
    /**
     * Gets whether or not to use the authorisation ID as the current schema name for the
     * omit current schema setting.
     * 
     * @return true when the authorisation ID should be used as the current schema.
     */
    public boolean getUseAUIDAsCurrentSchema();
      
    /**
     * Sets whether or not to use the authorisation ID as the current schema name for the
     * omit current schema setting.
     * 
     */
    public void setUseAUIDAsCurrentSchema(boolean useAUIDAsCurrentSchema);
      
    /**
     * Gets the current schema as input by the user.
     * 
     * @return the current schema as input by the user.
     */
    public String getCurrentSchema();
      
    /**
     * Sets the current schema as input by the user.
     * 
     * @return the current schema as input by the user.
     */
    public void setCurrentSchema(String currentSchema);

	/**
	 * Returns true if the IOmitSchemaInfo passed has the same values as this OmitSchemaInfo
	 * @param iOmitSchemaInfo
	 */
	public boolean equals(IOmitSchemaInfo iOmitSchemaInfo);

	/**
	 * Copy the IOmitSchemaInfo passed as a parameter to this OmitSchemaInfo.
	 * 
	 * @param iOmitSchemaInfo <code>IOmitSchemaInfo</code> object to be copied.
	 */
	public void copy(IOmitSchemaInfo iOmitSchemaInfo);

	/**
	 * Initialises the <code>OmitSchemaInfo</code> from Eclipse preference store.
	 */
	public void initFromPreferences();

	/**
     * Marks this object as having been changed.
     */
	public void setChanged();
	
	/**
	 * Encodes the given <code>IOmitSchemaInfo</code> object for persistence.
	 * @see org.eclipse.datatools.sqltools.sqlbuilder.model.OmitSchemaInfo#decode(String)
	 * @return encoded String
	 */
	public String encode();

}
