/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.function.catalog.BuiltinClassLoaderClassSupplier;
import io.github.toolfactory.jvm.function.catalog.DefineHookClassFunction;
import io.github.toolfactory.jvm.function.catalog.GetClassByNameFunction;
import io.github.toolfactory.jvm.function.catalog.MethodInvokeFunction;
import io.github.toolfactory.jvm.function.template.Supplier;
import io.github.toolfactory.jvm.util.Classes;
import io.github.toolfactory.jvm.util.ObjectProvider;
import io.github.toolfactory.jvm.util.Streams;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;

public interface ClassLoaderDelegateClassSupplier
extends Supplier<Class<?>> {

    public static interface ForJava17
    extends ClassLoaderDelegateClassSupplier {

        public static class ForSemeru
        extends ForJava9
        implements ForJava17 {
            public ForSemeru(Map<Object, Object> context) throws Throwable {
                super(context);
            }

            @Override
            protected void loadClass(Map<Object, Object> context) throws Throwable, IOException {
                ObjectProvider functionProvider = ObjectProvider.get(context);
                Class<?> thisClass = this.getClass();
                ClassLoader thisClassClassLoader = thisClass.getClassLoader();
                GetClassByNameFunction getClassByNameFunction = functionProvider.getOrBuildObject(GetClassByNameFunction.class, context);
                Class sharedSecretsClass = (Class)getClassByNameFunction.apply("jdk.internal.access.SharedSecrets", false, thisClassClassLoader, thisClass);
                Method getJavaLangAccessMethod = sharedSecretsClass.getDeclaredMethod("getJavaLangAccess", new Class[0]);
                Class javaLangAccessClass = (Class)getClassByNameFunction.apply("jdk.internal.access.JavaLangAccess", false, thisClassClassLoader, thisClass);
                MethodInvokeFunction methodInvoker = functionProvider.getOrBuildObject(MethodInvokeFunction.class, context);
                Object javaLangAccess = methodInvoker.apply(getJavaLangAccessMethod, null, null);
                methodInvoker.apply(javaLangAccessClass.getDeclaredMethod("addExportsToAllUnnamed", Module.class, String.class), javaLangAccess, new Object[]{ModuleLayer.boot().findModule("java.base").get(), "jdk.internal.loader"});
                super.loadClass(context);
            }
        }
    }

    public static class ForJava9
    implements ClassLoaderDelegateClassSupplier {
        protected Class<?> cls;

        public ForJava9(Map<Object, Object> context) throws Throwable {
            this.loadClass(context);
        }

        protected void loadClass(Map<Object, Object> context) throws Throwable, IOException {
            try (InputStream inputStream = Classes.class.getResourceAsStream("ClassLoaderDelegateForJDK9.bwc");){
                ObjectProvider functionProvider = ObjectProvider.get(context);
                this.cls = (Class)functionProvider.getOrBuildObject(DefineHookClassFunction.class, context).apply(functionProvider.getOrBuildObject(BuiltinClassLoaderClassSupplier.class, context).get(), Streams.toByteArray(inputStream));
            }
        }

        @Override
        public Class<?> get() {
            return this.cls;
        }
    }

    public static class ForJava7
    implements ClassLoaderDelegateClassSupplier {
        public ForJava7(Map<Object, Object> context) {
        }

        @Override
        public Class<?> get() {
            return null;
        }
    }
}

