/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.classes;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.burningwave.core.classes.AnnotationSourceGenerator;
import org.burningwave.core.classes.BodySourceGenerator;
import org.burningwave.core.classes.GenericSourceGenerator;
import org.burningwave.core.classes.SourceGenerator;
import org.burningwave.core.classes.TypeDeclarationSourceGenerator;
import org.burningwave.core.classes.VariableSourceGenerator;

public class FunctionSourceGenerator
extends SourceGenerator.Abst {
    private static final long serialVersionUID = -701718231919943913L;
    private Collection<TypeDeclarationSourceGenerator> usedTypes;
    private Collection<String> outerCode;
    private Collection<AnnotationSourceGenerator> annotations;
    private Collection<TypeDeclarationSourceGenerator> throwables;
    private Integer modifier;
    private boolean defaultFunction;
    private TypeDeclarationSourceGenerator typesDeclaration;
    private TypeDeclarationSourceGenerator returnType;
    private String name;
    private Collection<VariableSourceGenerator> parameters;
    private BodySourceGenerator body;

    private FunctionSourceGenerator(String name) {
        this.name = name;
    }

    public static FunctionSourceGenerator create(String name) {
        return new FunctionSourceGenerator(name);
    }

    public static FunctionSourceGenerator create() {
        return new FunctionSourceGenerator(null);
    }

    FunctionSourceGenerator setName(String name) {
        this.name = name;
        return this;
    }

    public FunctionSourceGenerator addModifier(Integer modifier) {
        this.modifier = this.modifier == null ? modifier : Integer.valueOf(this.modifier | modifier);
        return this;
    }

    public FunctionSourceGenerator setDefault() {
        this.defaultFunction = true;
        return this;
    }

    public FunctionSourceGenerator setTypeDeclaration(TypeDeclarationSourceGenerator typesDeclaration) {
        this.typesDeclaration = typesDeclaration;
        return this;
    }

    public FunctionSourceGenerator setReturnType(String name) {
        this.returnType = TypeDeclarationSourceGenerator.create(name);
        return this;
    }

    TypeDeclarationSourceGenerator getReturnType() {
        return this.returnType;
    }

    public FunctionSourceGenerator setReturnType(TypeDeclarationSourceGenerator returnType) {
        this.returnType = returnType;
        return this;
    }

    public FunctionSourceGenerator setReturnType(GenericSourceGenerator returnType) {
        return this.setReturnType(TypeDeclarationSourceGenerator.create(returnType.getName()));
    }

    public FunctionSourceGenerator setReturnType(Class<?> returnType) {
        this.returnType = TypeDeclarationSourceGenerator.create(returnType);
        return this;
    }

    public FunctionSourceGenerator addParameter(VariableSourceGenerator ... parameters) {
        Optional.ofNullable(this.parameters).orElseGet(() -> {
            this.parameters = new ArrayList<VariableSourceGenerator>();
            return this.parameters;
        });
        for (VariableSourceGenerator parameter : parameters) {
            this.parameters.add(parameter.setDelimiter(null));
        }
        return this;
    }

    public FunctionSourceGenerator addThrowable(TypeDeclarationSourceGenerator ... throwables) {
        Optional.ofNullable(this.throwables).orElseGet(() -> {
            this.throwables = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.throwables;
        });
        for (TypeDeclarationSourceGenerator throwable : throwables) {
            this.throwables.add(throwable);
        }
        return this;
    }

    Collection<VariableSourceGenerator> getParameters() {
        return this.parameters;
    }

    public FunctionSourceGenerator addOuterCodeLine(String ... codes) {
        Optional.ofNullable(this.outerCode).orElseGet(() -> {
            this.outerCode = new ArrayList<String>();
            return this.outerCode;
        });
        for (String code : codes) {
            if (!this.outerCode.isEmpty()) {
                this.outerCode.add("\n" + code);
                continue;
            }
            this.outerCode.add(code);
        }
        return this;
    }

    public FunctionSourceGenerator addAnnotation(AnnotationSourceGenerator ... annotations) {
        Optional.ofNullable(this.annotations).orElseGet(() -> {
            this.annotations = new ArrayList<AnnotationSourceGenerator>();
            return this.annotations;
        });
        for (AnnotationSourceGenerator annotation : annotations) {
            this.annotations.add(annotation);
        }
        return this;
    }

    public FunctionSourceGenerator setBody(BodySourceGenerator body) {
        this.body = body.setDelimiters("{\n", "\n}").setElementPrefix("\t");
        return this;
    }

    public FunctionSourceGenerator addBodyCode(String ... codes) {
        Optional.ofNullable(this.body).orElseGet(() -> {
            this.body = BodySourceGenerator.create();
            return this.body;
        });
        this.body.addCode(codes);
        return this;
    }

    public FunctionSourceGenerator addBodyCodeLine(String ... code) {
        Optional.ofNullable(this.body).orElseGet(() -> {
            this.body = BodySourceGenerator.create();
            return this.body;
        });
        this.body.addCodeLine(code);
        return this;
    }

    public FunctionSourceGenerator addBodyElement(SourceGenerator ... generators) {
        Optional.ofNullable(this.body).orElseGet(() -> {
            this.body = BodySourceGenerator.create();
            return this.body;
        });
        for (SourceGenerator generator : generators) {
            this.body.addElement(generator);
        }
        return this;
    }

    public FunctionSourceGenerator useType(Class<?> ... classes) {
        Optional.ofNullable(this.usedTypes).orElseGet(() -> {
            this.usedTypes = new ArrayList<TypeDeclarationSourceGenerator>();
            return this.usedTypes;
        });
        for (Class<?> cls : classes) {
            this.usedTypes.add(TypeDeclarationSourceGenerator.create(cls));
        }
        return this;
    }

    private String getParametersCode() {
        String paramsCode = "(";
        if (this.parameters != null) {
            paramsCode = paramsCode + "\n";
            Iterator<VariableSourceGenerator> paramsIterator = this.parameters.iterator();
            while (paramsIterator.hasNext()) {
                VariableSourceGenerator param = paramsIterator.next();
                paramsCode = paramsCode + "\t" + param.make().replace("\n", "\n\t");
                if (paramsIterator.hasNext()) {
                    paramsCode = paramsCode + ",\n";
                    continue;
                }
                paramsCode = paramsCode + "\n";
            }
        }
        return paramsCode + ")";
    }

    Collection<TypeDeclarationSourceGenerator> getTypeDeclarations() {
        ArrayList<TypeDeclarationSourceGenerator> types = new ArrayList<TypeDeclarationSourceGenerator>();
        Optional.ofNullable(this.usedTypes).ifPresent(usedTypes -> types.addAll((Collection<TypeDeclarationSourceGenerator>)usedTypes));
        Optional.ofNullable(this.typesDeclaration).ifPresent(typesDeclaration -> types.addAll(typesDeclaration.getTypeDeclarations()));
        Optional.ofNullable(this.returnType).ifPresent(returnType -> types.addAll(returnType.getTypeDeclarations()));
        Optional.ofNullable(this.parameters).ifPresent(parameters -> parameters.forEach(parameter -> types.addAll(parameter.getTypeDeclarations())));
        Optional.ofNullable(this.body).ifPresent(body -> types.addAll(body.getTypeDeclarations()));
        Optional.ofNullable(this.annotations).ifPresent(annotations -> {
            for (AnnotationSourceGenerator annotation : annotations) {
                types.addAll(annotation.getTypeDeclarations());
            }
        });
        Optional.ofNullable(this.throwables).ifPresent(exceptions -> {
            for (TypeDeclarationSourceGenerator annotation : exceptions) {
                types.addAll(annotation.getTypeDeclarations());
            }
        });
        return types;
    }

    private String getAnnotations() {
        return Optional.ofNullable(this.annotations).map(annts -> this.getOrEmpty((Collection<?>)annts, "\n") + "\n").orElseGet(() -> null);
    }

    private String getThrowables() {
        return Optional.ofNullable(this.throwables).map(thrws -> "throws " + this.getOrEmpty((Collection<?>)thrws, ", ")).orElseGet(() -> null);
    }

    private String getModifier() {
        return Optional.ofNullable(this.modifier).map(mod -> Modifier.toString(this.modifier)).orElseGet(() -> null);
    }

    private String getOuterCode() {
        return Optional.ofNullable(this.outerCode).map(outerCode -> this.getOrEmpty((Collection<?>)outerCode) + "\n").orElseGet(() -> null);
    }

    @Override
    public String make() {
        return this.getOrEmpty(this.getOuterCode(), this.getAnnotations(), this.getModifier(), this.defaultFunction ? "default" : null, this.typesDeclaration, this.returnType, this.name + this.getParametersCode(), this.getThrowables(), this.body, Optional.ofNullable(this.body).map(mod -> "").orElseGet(() -> ";"));
    }
}

