/**
 * Copyright (c) 2017, 2020 Kichwa Coders Ltd. and others.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0,
 * or the Eclipse Distribution License v. 1.0 which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR BSD-3-Clause
 */
package org.eclipse.lsp4j.debug;

import org.eclipse.lsp4j.jsonrpc.util.ToStringBuilder;

/**
 * Arguments for 'restartFrame' request.
 */
@SuppressWarnings("all")
public class RestartFrameArguments {
  /**
   * Restart the stack frame identified by `frameId`. The `frameId` must
   * have been obtained in the current suspended state.
   * See 'Lifetime of Object References' in the {@link DebugProtocol#Overview} section for details.
   */
  private int frameId;

  /**
   * Restart the stack frame identified by `frameId`. The `frameId` must
   * have been obtained in the current suspended state.
   * See 'Lifetime of Object References' in the {@link DebugProtocol#Overview} section for details.
   */
  public int getFrameId() {
    return this.frameId;
  }

  /**
   * Restart the stack frame identified by `frameId`. The `frameId` must
   * have been obtained in the current suspended state.
   * See 'Lifetime of Object References' in the {@link DebugProtocol#Overview} section for details.
   */
  public void setFrameId(final int frameId) {
    this.frameId = frameId;
  }

  @Override
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("frameId", this.frameId);
    return b.toString();
  }

  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    RestartFrameArguments other = (RestartFrameArguments) obj;
    if (other.frameId != this.frameId)
      return false;
    return true;
  }

  @Override
  public int hashCode() {
    return 31 * 1 + this.frameId;
  }
}
