"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementAttrs = exports.getComponentNames = exports.getTemplateContextProps = exports.getComponentEvents = exports.getComponentProps = exports.getQuickInfoAtPosition = exports.getPropertiesAtLocation = exports.getImportPathForFile = exports.collectExtractProps = void 0;
const utils_1 = require("./utils");
function collectExtractProps(...args) {
    return sendRequest({
        type: 'collectExtractProps',
        args,
    });
}
exports.collectExtractProps = collectExtractProps;
async function getImportPathForFile(...args) {
    return await sendRequest({
        type: 'getImportPathForFile',
        args,
    });
}
exports.getImportPathForFile = getImportPathForFile;
async function getPropertiesAtLocation(...args) {
    return await sendRequest({
        type: 'getPropertiesAtLocation',
        args,
    });
}
exports.getPropertiesAtLocation = getPropertiesAtLocation;
function getQuickInfoAtPosition(...args) {
    return sendRequest({
        type: 'getQuickInfoAtPosition',
        args,
    });
}
exports.getQuickInfoAtPosition = getQuickInfoAtPosition;
// Component Infos
function getComponentProps(...args) {
    return sendRequest({
        type: 'getComponentProps',
        args,
    });
}
exports.getComponentProps = getComponentProps;
function getComponentEvents(...args) {
    return sendRequest({
        type: 'getComponentEvents',
        args,
    });
}
exports.getComponentEvents = getComponentEvents;
function getTemplateContextProps(...args) {
    return sendRequest({
        type: 'getTemplateContextProps',
        args,
    });
}
exports.getTemplateContextProps = getTemplateContextProps;
function getComponentNames(...args) {
    return sendRequest({
        type: 'getComponentNames',
        args,
    });
}
exports.getComponentNames = getComponentNames;
function getElementAttrs(...args) {
    return sendRequest({
        type: 'getElementAttrs',
        args,
    });
}
exports.getElementAttrs = getElementAttrs;
async function sendRequest(request) {
    const server = (await (0, utils_1.searchNamedPipeServerForFile)(request.args[0]))?.server;
    if (!server) {
        console.warn('[Vue Named Pipe Client] No server found for', request.args[0]);
        return;
    }
    const client = await (0, utils_1.connect)(server.path);
    if (!client) {
        console.warn('[Vue Named Pipe Client] Failed to connect to', server.path);
        return;
    }
    return await (0, utils_1.sendRequestWorker)(request, client);
}
//# sourceMappingURL=client.js.map