/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation.factory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupportUtils;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.FactoryAccessor;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.check.Assert;

public abstract class AbstractFactoryCreationSupport
extends CreationSupport {
    protected CreationSupportUtils m_utils;
    protected MethodDescription m_description;
    protected MethodInvocation m_invocation;
    private ComplexProperty m_complexProperty;

    public AbstractFactoryCreationSupport() {
    }

    public AbstractFactoryCreationSupport(MethodDescription description) {
        Assert.isNotNull((Object)description);
        this.m_description = description;
    }

    public AbstractFactoryCreationSupport(MethodDescription description, MethodInvocation invocation) {
        this(description);
        this.m_invocation = invocation;
    }

    @Override
    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_utils = new CreationSupportUtils(this.m_javaInfo);
    }

    @Override
    public final boolean isJavaInfo(ASTNode node) {
        return node == this.m_invocation;
    }

    @Override
    public final ASTNode getNode() {
        return this.m_invocation;
    }

    public final MethodInvocation getInvocation() {
        return this.m_invocation;
    }

    public MethodDescription getDescription() {
        return this.m_description;
    }

    @Override
    public void addProperties(List<Property> properties) throws Exception {
        if (this.m_complexProperty == null) {
            this.m_complexProperty = new ComplexProperty("Factory", "(Factory properties)");
            this.m_complexProperty.setCategory(PropertyCategory.system((int)3));
            this.m_complexProperty.setModified(true);
            ComponentDescriptionHelper.ensureInitialized(this.m_javaInfo.getEditor().getJavaProject(), this.m_description);
            ArrayList<Property> subPropertiesList = new ArrayList<Property>();
            for (ParameterDescription parameter : this.m_description.getParameters()) {
                Property property = this.getGenericProperty(parameter);
                if (property == null) continue;
                subPropertiesList.add(property);
            }
            if (!subPropertiesList.isEmpty()) {
                Property[] subProperties = subPropertiesList.toArray(new Property[subPropertiesList.size()]);
                this.m_complexProperty.setProperties(subProperties);
            }
        }
        if (this.m_complexProperty.getProperties().length != 0) {
            properties.add((Property)this.m_complexProperty);
        }
    }

    @Override
    public final void addAccessors(GenericPropertyDescription propertyDescription, List<ExpressionAccessor> accessors) throws Exception {
        for (ParameterDescription parameter : this.m_description.getParameters()) {
            if (!propertyDescription.getId().equals(parameter.getProperty())) continue;
            int index = parameter.getIndex();
            String defaultSource = parameter.getDefaultSource();
            FactoryAccessor accessor = new FactoryAccessor(index, defaultSource);
            accessors.add(accessor);
        }
    }

    protected final Property getGenericProperty(ParameterDescription parameter) throws Exception {
        return this.m_utils.createProperty(parameter);
    }

    @Override
    public final boolean canDelete() {
        return true;
    }

    @Override
    public final void delete() throws Exception {
        JavaInfoUtils.deleteJavaInfo(this.m_javaInfo, true);
    }
}

