/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.runner;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.suite.api.SuiteDisplayName;
import org.junit.platform.suite.api.UseTechnicalNames;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

class JUnitPlatformTestTree {
    private final Map<TestIdentifier, Description> descriptions = new HashMap<TestIdentifier, Description>();
    private final TestPlan testPlan;
    private final Function<TestIdentifier, String> nameExtractor;
    private final Description suiteDescription;

    JUnitPlatformTestTree(TestPlan testPlan, Class<?> testClass) {
        this.testPlan = testPlan;
        this.nameExtractor = JUnitPlatformTestTree.useTechnicalNames(testClass) ? this::getTechnicalName : TestIdentifier::getDisplayName;
        this.suiteDescription = this.generateSuiteDescription(testPlan, testClass);
    }

    public TestPlan getTestPlan() {
        return this.testPlan;
    }

    private static boolean useTechnicalNames(Class<?> testClass) {
        return testClass.isAnnotationPresent(UseTechnicalNames.class);
    }

    Description getSuiteDescription() {
        return this.suiteDescription;
    }

    Description getDescription(TestIdentifier identifier) {
        return this.descriptions.get(identifier);
    }

    private Description generateSuiteDescription(TestPlan testPlan, Class<?> testClass) {
        String displayName = JUnitPlatformTestTree.useTechnicalNames(testClass) ? testClass.getName() : this.getSuiteDisplayName(testClass);
        Description suiteDescription = Description.createSuiteDescription((String)displayName, (Annotation[])new Annotation[0]);
        this.buildDescriptionTree(suiteDescription, testPlan);
        return suiteDescription;
    }

    private String getSuiteDisplayName(Class<?> testClass) {
        return AnnotationUtils.findAnnotation(testClass, SuiteDisplayName.class).map(SuiteDisplayName::value).filter(StringUtils::isNotBlank).orElse(testClass.getName());
    }

    private void buildDescriptionTree(Description suiteDescription, TestPlan testPlan) {
        testPlan.getRoots().forEach(testIdentifier -> this.buildDescription((TestIdentifier)testIdentifier, suiteDescription, testPlan));
    }

    void addDynamicDescription(TestIdentifier newIdentifier, UniqueId parentId) {
        Description parent = this.getDescription(this.testPlan.getTestIdentifier(parentId));
        this.buildDescription(newIdentifier, parent, this.testPlan);
    }

    private void buildDescription(TestIdentifier identifier, Description parent, TestPlan testPlan) {
        Description newDescription = this.createJUnit4Description(identifier, testPlan);
        parent.addChild(newDescription);
        this.descriptions.put(identifier, newDescription);
        testPlan.getChildren(identifier).forEach(testIdentifier -> this.buildDescription((TestIdentifier)testIdentifier, newDescription, testPlan));
    }

    private Description createJUnit4Description(TestIdentifier identifier, TestPlan testPlan) {
        String name = this.nameExtractor.apply(identifier);
        if (identifier.isTest()) {
            String containerName = testPlan.getParent(identifier).map(this.nameExtractor).orElse("<unrooted>");
            return Description.createTestDescription((String)containerName, (String)name, (Serializable)identifier.getUniqueIdObject());
        }
        return Description.createSuiteDescription((String)name, (Serializable)identifier.getUniqueIdObject(), (Annotation[])new Annotation[0]);
    }

    private String getTechnicalName(TestIdentifier testIdentifier) {
        Optional optionalSource = testIdentifier.getSource();
        if (optionalSource.isPresent()) {
            TestSource source = (TestSource)optionalSource.get();
            if (source instanceof ClassSource) {
                return ((ClassSource)source).getJavaClass().getName();
            }
            if (source instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)source;
                String methodParameterTypes = methodSource.getMethodParameterTypes();
                if (StringUtils.isBlank((String)methodParameterTypes)) {
                    return methodSource.getMethodName();
                }
                return String.format("%s(%s)", methodSource.getMethodName(), methodParameterTypes);
            }
        }
        return testIdentifier.getDisplayName();
    }

    Set<TestIdentifier> getTestsInSubtree(TestIdentifier ancestor) {
        return this.testPlan.getDescendants(ancestor).stream().filter(TestIdentifier::isTest).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    Set<TestIdentifier> getFilteredLeaves(Filter filter) {
        Set<TestIdentifier> identifiers = this.applyFilterToDescriptions(filter);
        return this.removeNonLeafIdentifiers(identifiers);
    }

    private Set<TestIdentifier> removeNonLeafIdentifiers(Set<TestIdentifier> identifiers) {
        return identifiers.stream().filter(this.isALeaf(identifiers)).collect(Collectors.toSet());
    }

    private Predicate<? super TestIdentifier> isALeaf(Set<TestIdentifier> identifiers) {
        return testIdentifier -> {
            Set descendants = this.testPlan.getDescendants(testIdentifier);
            return identifiers.stream().noneMatch(descendants::contains);
        };
    }

    private Set<TestIdentifier> applyFilterToDescriptions(Filter filter) {
        return this.descriptions.entrySet().stream().filter(entry -> filter.shouldRun((Description)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

