/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.DiagnosticGroups;
import com.google.javascript.jscomp.GoogleCodingConvention;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.LintPassConfig;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.refactoring.ApplySuggestedFixes;
import com.google.javascript.refactoring.ErrorToFixMapper;
import com.google.javascript.refactoring.SuggestedFix;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class Linter {
    public static void main(String[] args) throws IOException {
        for (String filename : args) {
            Linter.lint(null, filename);
        }
    }

    static void lint(SourceFile externs, String filename) throws IOException {
        Linter.lint(externs, Paths.get(filename, new String[0]), false);
    }

    static void fix(SourceFile externs, String filename) throws IOException {
        Linter.lint(externs, Paths.get(filename, new String[0]), true);
    }

    private static void lint(SourceFile externs, Path path, boolean fix) throws IOException {
        if (externs == null) {
            externs = SourceFile.fromCode("<Linter externs>", "");
        }
        SourceFile file = SourceFile.fromFile(path.toString());
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        options.setLanguage(CompilerOptions.LanguageMode.ECMASCRIPT6_STRICT);
        options.setSkipTranspilationAndCrash(true);
        options.setIdeMode(fix);
        options.setCodingConvention(new GoogleCodingConvention());
        options.setWarningLevel(DiagnosticGroups.CHECK_TYPES, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.MISSING_REQUIRE, CheckLevel.WARNING);
        options.setWarningLevel(DiagnosticGroups.EXTRA_REQUIRE, CheckLevel.WARNING);
        compiler.setPassConfig(new LintPassConfig(options));
        compiler.disableThreads();
        compiler.compile(ImmutableList.of((Object)externs), ImmutableList.of((Object)file), options);
        if (fix) {
            ArrayList<SuggestedFix> fixes = new ArrayList<SuggestedFix>();
            for (JSError warning : compiler.getWarnings()) {
                SuggestedFix suggestedFix = ErrorToFixMapper.getFixForJsError(warning, compiler);
                if (suggestedFix == null) continue;
                fixes.add(suggestedFix);
            }
            ApplySuggestedFixes.applySuggestedFixesToFiles(fixes);
        }
    }
}

