/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.parser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.WrapperMethodInfo;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.core.model.association.EmptyAssociation;
import org.eclipse.wb.core.model.association.FactoryParentAssociation;
import org.eclipse.wb.core.model.association.ImplicitFactoryArgumentAssociation;
import org.eclipse.wb.core.model.association.InvocationVoidAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CastedSuperInvocationCreationSupport;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.InvocationChainCreationSupport;
import org.eclipse.wb.internal.core.model.creation.SuperInvocationCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.ImplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.InstanceFactoryInfo;
import org.eclipse.wb.internal.core.model.creation.factory.StaticFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.AbstractDescription;
import org.eclipse.wb.internal.core.model.description.AbstractInvocationDescription;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.MethodDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.DescriptionHelper;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProvider;
import org.eclipse.wb.internal.core.model.description.resource.IDescriptionVersionsProviderFactory;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanContainerInfo;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.core.model.util.ScriptUtils;
import org.eclipse.wb.internal.core.model.variable.VoidInvocationVariableSupport;
import org.eclipse.wb.internal.core.parser.IJavaInfoParseResolver;
import org.eclipse.wb.internal.core.parser.IParseFactory;
import org.eclipse.wb.internal.core.parser.ParseRootContext;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.MultipleConstructorsError;
import org.eclipse.wb.internal.core.utils.execution.RunnableObjectEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.jdt.core.ProjectUtils;
import org.eclipse.wb.internal.core.utils.reflect.BundleClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.CompositeClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.IByteCodeProcessor;
import org.eclipse.wb.internal.core.utils.reflect.IClassLoaderInitializer;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.state.EditorWarning;
import org.mvel2.MVEL;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractParseFactory
implements IParseFactory {
    @Override
    public ParseRootContext getRootContext(AstEditor editor, TypeDeclaration typeDeclaration, ITypeBinding typeBinding) throws Exception {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JavaInfo create(AstEditor editor, Expression expression) throws Exception {
        Expression expression2;
        Expression expression3 = expression;
        if (expression3 instanceof CastExpression) {
            void castExpression;
            CastExpression castExpression2 = (CastExpression)expression3;
            CastExpression cfr_ignored_0 = (CastExpression)expression3;
            if (castExpression.getExpression() instanceof SuperMethodInvocation) {
                String componentClassName = AstNodeUtils.getFullyQualifiedName(expression, true);
                Class<?> componentClass = EditorState.get(editor).getEditorLoader().loadClass(componentClassName);
                return JavaInfoUtils.createJavaInfo(editor, componentClass, (CreationSupport)new CastedSuperInvocationCreationSupport((CastExpression)castExpression));
            }
        }
        if ((expression2 = expression) instanceof SuperMethodInvocation) {
            void invocation;
            ITypeBinding typeBinding;
            SuperMethodInvocation componentClass = (SuperMethodInvocation)expression2;
            SuperMethodInvocation cfr_ignored_1 = (SuperMethodInvocation)expression2;
            if (expression.getLocationInParent() != CastExpression.EXPRESSION_PROPERTY && this.isToolkitObject(editor, typeBinding = AstNodeUtils.getTypeBinding((Expression)invocation))) {
                String componentClassName = AstNodeUtils.getFullyQualifiedName(typeBinding, true);
                Class<?> componentClass2 = EditorState.get(editor).getEditorLoader().loadClass(componentClassName);
                return JavaInfoUtils.createJavaInfo(editor, componentClass2, (CreationSupport)new SuperInvocationCreationSupport((SuperMethodInvocation)invocation));
            }
        }
        return null;
    }

    @Override
    public JavaInfo create(final AstEditor editor, ClassInstanceCreation creation, final IMethodBinding methodBinding, ITypeBinding typeBinding, Expression[] arguments, JavaInfo[] argumentInfos) throws Exception {
        final Class<?> creationClass = AbstractParseFactory.getClass(editor, typeBinding);
        if (creationClass == null) {
            return null;
        }
        NonVisualBeanInfo nonVisualInfo = NonVisualBeanContainerInfo.getNonVisualInfo((ASTNode)creation);
        if (nonVisualInfo != null) {
            ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(creation);
            JavaInfo javaInfo = JavaInfoUtils.createJavaInfo(editor, creationClass, (CreationSupport)creationSupport);
            nonVisualInfo.setJavaInfo(javaInfo);
            return javaInfo;
        }
        JavaInfo javaInfo = this.createInstance(editor, typeBinding, new RunnableObjectEx<AbstractInvocationDescription>(){

            public AbstractInvocationDescription runObject() throws Exception {
                ComponentDescription description = ComponentDescriptionHelper.getDescription(editor, creationClass);
                return description.getConstructor(methodBinding);
            }
        }, argumentInfos, new ConstructorCreationSupport(creation));
        if (javaInfo != null) {
            return javaInfo;
        }
        if (InstanceFactoryInfo.isFactory(editor, creationClass)) {
            ConstructorCreationSupport creationSupport = new ConstructorCreationSupport(creation);
            return InstanceFactoryInfo.createFactory(editor, creationClass, creationSupport);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JavaInfo create(AstEditor editor, MethodInvocation invocation, IMethodBinding methodBinding, Expression[] arguments, JavaInfo expressionInfo, JavaInfo[] argumentInfos, IJavaInfoParseResolver javaInfoResolver) throws Exception {
        JavaInfo javaInfo;
        FactoryMethodDescription description;
        JavaInfo javaInfo2;
        String componentClassName;
        JavaInfo hostJavaInfo;
        JavaInfo javaInfo3;
        Object methodDescription;
        if (expressionInfo != null && (methodDescription = expressionInfo.getDescription().getMethod(methodBinding)) != null && ((AbstractDescription)methodDescription).hasTrueTag("implicitFactory") && (javaInfo3 = this.createImplicitFactory(editor, invocation, expressionInfo, argumentInfos, (MethodDescription)methodDescription)) != null) {
            return javaInfo3;
        }
        Object allSignatures = "";
        MethodInvocation currentInvocation = invocation;
        while (true) {
            allSignatures = AstNodeUtils.getMethodSignature(currentInvocation) + (((String)allSignatures).length() != 0 ? "." : "") + (String)allSignatures;
            if (!(currentInvocation.getExpression() instanceof MethodInvocation)) break;
            currentInvocation = (MethodInvocation)currentInvocation.getExpression();
        }
        JavaInfo javaInfo4 = hostJavaInfo = currentInvocation == invocation ? expressionInfo : javaInfoResolver.getJavaInfo(currentInvocation.getExpression());
        if (hostJavaInfo != null && (componentClassName = JavaInfoUtils.getParameter(hostJavaInfo, "invocationChain: " + (String)allSignatures)) != null) {
            if (componentClassName.length() == 0) {
                componentClassName = AstNodeUtils.getFullyQualifiedName(methodBinding.getReturnType(), true);
            }
            InvocationChainCreationSupport creationSupport = new InvocationChainCreationSupport(invocation, (String)allSignatures);
            JavaInfo javaInfo5 = JavaInfoUtils.createJavaInfo(editor, componentClassName, (CreationSupport)creationSupport);
            javaInfo5.setAssociation(new EmptyAssociation());
            hostJavaInfo.addChild(javaInfo5);
            return javaInfo5;
        }
        if (expressionInfo != null && (methodDescription = expressionInfo.getDescription().getMethod(methodBinding)) != null) {
            String voidCreationSupportClassName = ((AbstractDescription)methodDescription).getTag("voidFactory.creationSupport");
            String voidComponentClassName = ((AbstractDescription)methodDescription).getTag("voidFactory.componentClass");
            if (!StringUtils.isEmpty((String)voidCreationSupportClassName) && !StringUtils.isEmpty((String)voidComponentClassName)) {
                if (!AbstractParseFactory.createVoidFactory_hasRequiredJavaInfo((MethodDescription)methodDescription, argumentInfos)) {
                    return null;
                }
                Class<?> voidCreationSupportClass = DescriptionHelper.loadModelClass(voidCreationSupportClassName);
                Constructor constructor = ReflectionUtils.getConstructor(voidCreationSupportClass, (Class[])new Class[]{JavaInfo.class, MethodDescription.class, MethodInvocation.class, JavaInfo[].class});
                Assert.isNotNull((Object)constructor, (String)("Can not find constructor " + voidCreationSupportClassName + "(JavaInfo,MethodDescription,MethodInvocation,JavaInfo[])"));
                CreationSupport creationSupport = (CreationSupport)constructor.newInstance(new Object[]{expressionInfo, methodDescription, invocation, argumentInfos});
                Class<?> componentClass = EditorState.get(editor).getEditorLoader().loadClass(voidComponentClassName);
                JavaInfo javaInfo6 = this.createVoidFactory(editor, invocation, expressionInfo, argumentInfos, (MethodDescription)methodDescription, componentClass, creationSupport);
                if (javaInfo6 != null) {
                    return javaInfo6;
                }
            }
        }
        if ((javaInfo2 = expressionInfo) instanceof InstanceFactoryInfo) {
            void factoryInfo;
            methodDescription = (InstanceFactoryInfo)javaInfo2;
            InstanceFactoryInfo cfr_ignored_0 = (InstanceFactoryInfo)javaInfo2;
            description = AbstractParseFactory.getFactory(editor, methodBinding, false);
            if (description != null && (javaInfo = this.createInstanceFactory(editor, invocation, methodBinding, argumentInfos, (InstanceFactoryInfo)factoryInfo, description)) != null) {
                return javaInfo;
            }
        }
        if (AstNodeUtils.isStatic(methodBinding) && (description = AbstractParseFactory.getFactory(editor, methodBinding, true)) != null && (javaInfo = this.createStaticFactory(editor, invocation, methodBinding, argumentInfos, description)) != null) {
            return javaInfo;
        }
        return null;
    }

    protected static Class<?> getClass(AstEditor editor, ITypeBinding typeBinding) {
        try {
            ClassLoader classLoader = EditorState.get(editor).getEditorLoader();
            String componentClassName = AstNodeUtils.getFullyQualifiedName(typeBinding, true);
            Class<?> clazz = classLoader.loadClass(componentClassName);
            if (clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers())) {
            }
            return clazz;
        }
        finally {
            return null;
        }
    }

    protected static Class<?> getSuperClass(AstEditor editor, ITypeBinding typeBinding) {
        String componentClassName = AstNodeUtils.getFullyQualifiedName(typeBinding, true);
        try {
            ClassLoader classLoader = EditorState.get(editor).getEditorLoader();
            return classLoader.loadClass(componentClassName);
        }
        catch (Throwable e) {
            throw new DesignerException(109, e, new String[]{componentClassName});
        }
    }

    public boolean isToolkitObject(AstEditor editor, ITypeBinding typeBinding) throws Exception {
        return false;
    }

    protected static void failIfFactory(AstEditor editor, TypeDeclaration typeDeclaration, ITypeBinding typeBinding) throws Exception {
        String typeName = AstNodeUtils.getFullyQualifiedName(typeDeclaration, true);
        if (FactoryDescriptionHelper.isFactoryClass(editor, typeName)) {
            throw new DesignerException(105, new String[0]);
        }
    }

    protected static MethodDeclaration getConstructor(AstEditor editor, TypeDeclaration typeDeclaration) throws Exception {
        MethodDeclaration constructor;
        try {
            constructor = ExecutionFlowUtils.getExecutionFlowConstructor(typeDeclaration);
        }
        catch (MultipleConstructorsError e) {
            throw new MultipleConstructorsError(editor, typeDeclaration);
        }
        if (constructor == null) {
            String header = "public " + typeDeclaration.getName().getIdentifier() + "()";
            constructor = editor.addMethodDeclaration(header, Collections.emptyList(), new BodyDeclarationTarget(typeDeclaration, true));
            constructor.setConstructor(true);
            editor.commitChanges();
            editor.getModelUnit().save(null, true);
        }
        return constructor;
    }

    public static FactoryMethodDescription getFactory(AstEditor editor, IMethodBinding methodBinding, boolean forStatic) throws Exception {
        ITypeBinding declaringClass = methodBinding.getDeclaringClass();
        Class<?> factoryClass = AbstractParseFactory.getClass(editor, declaringClass);
        if (factoryClass == null) {
            return null;
        }
        String methodSignature = AstNodeUtils.getMethodSignature(methodBinding);
        FactoryMethodDescription description = FactoryDescriptionHelper.getDescription(editor, factoryClass, methodSignature, forStatic);
        if (description != null && description.isFactory()) {
            return description;
        }
        return null;
    }

    private JavaInfo createInstance(AstEditor editor, ITypeBinding typeBinding, RunnableObjectEx<AbstractInvocationDescription> methodDescriptionProvider, JavaInfo[] argumentInfos, CreationSupport creationSupport) throws Exception {
        Class<?> objectClass = AbstractParseFactory.getClass(editor, typeBinding);
        if (objectClass == null) {
            return null;
        }
        if (InstanceFactoryInfo.isFactory(editor, objectClass)) {
            return InstanceFactoryInfo.createFactory(editor, objectClass, creationSupport);
        }
        if (this.isToolkitObject(editor, typeBinding)) {
            return JavaInfoUtils.createJavaInfo(editor, objectClass, creationSupport);
        }
        if (WrapperMethodInfo.isWrapper(editor, objectClass)) {
            WrapperMethodInfo wrapperJavaInfo = (WrapperMethodInfo)JavaInfoUtils.createJavaInfo(editor, objectClass, creationSupport);
            AbstractInvocationDescription methodDescription = (AbstractInvocationDescription)methodDescriptionProvider.runObject();
            wrapperJavaInfo.getWrapper().configureWrapper(methodDescription, argumentInfos);
            wrapperJavaInfo.setAssociation(new ConstructorParentAssociation());
            return wrapperJavaInfo;
        }
        return null;
    }

    protected JavaInfo createVoidFactory(AstEditor editor, MethodInvocation invocation, JavaInfo expressionInfo, JavaInfo[] argumentInfos, MethodDescription methodDescription, Class<?> componentClass, CreationSupport creationSupport) throws Exception {
        JavaInfo javaInfo = JavaInfoUtils.createJavaInfo(editor, componentClass, creationSupport);
        javaInfo.setVariableSupport(new VoidInvocationVariableSupport(javaInfo));
        javaInfo.setAssociation(new InvocationVoidAssociation(invocation));
        expressionInfo.addChild(javaInfo);
        return javaInfo;
    }

    private static boolean createVoidFactory_hasRequiredJavaInfo(MethodDescription methodDescription, JavaInfo[] argumentInfos) {
        List<ParameterDescription> parameters = methodDescription.getParameters();
        for (ParameterDescription parameter : parameters) {
            int index;
            if (!parameter.hasTrueTag("voidFactory.requiredJavaInfo") || argumentInfos[index = parameter.getIndex()] != null) continue;
            return false;
        }
        return true;
    }

    protected JavaInfo createStaticFactory(AstEditor editor, MethodInvocation invocation, IMethodBinding methodBinding, JavaInfo[] argumentInfos, FactoryMethodDescription factoryMethodDescription) throws Exception {
        JavaInfo javaInfo = this.createStaticFactory_JavaInfo(editor, invocation, methodBinding, argumentInfos, factoryMethodDescription);
        if (javaInfo != null) {
            for (ParameterDescription parameter : factoryMethodDescription.getParameters()) {
                if (!parameter.isParent()) continue;
                JavaInfo parent = argumentInfos[parameter.getIndex()];
                if (parent != null) {
                    javaInfo.setAssociation(new FactoryParentAssociation(invocation));
                    if (javaInfo.getParent() != null) continue;
                    parent.addChild(javaInfo);
                    continue;
                }
                String message = "No parent model for " + String.valueOf(invocation);
                EditorState.get(editor).addWarning(new EditorWarning(message));
            }
        }
        return javaInfo;
    }

    private JavaInfo createStaticFactory_JavaInfo(AstEditor editor, MethodInvocation invocation, IMethodBinding methodBinding, JavaInfo[] argumentInfos, FactoryMethodDescription factoryMethodDescription) throws Exception {
        Class<?> objectClass = factoryMethodDescription.getReturnClass();
        StaticFactoryCreationSupport creationSupport = new StaticFactoryCreationSupport(factoryMethodDescription, invocation);
        if (InstanceFactoryInfo.isFactory(editor, objectClass)) {
            return InstanceFactoryInfo.createFactory(editor, objectClass, creationSupport);
        }
        if (this.isToolkitObject(editor, methodBinding.getReturnType())) {
            ComponentDescription componentDescription = ComponentDescriptionHelper.getDescription(editor, factoryMethodDescription);
            return JavaInfoUtils.createJavaInfo(editor, componentDescription, (CreationSupport)creationSupport);
        }
        if (WrapperMethodInfo.isWrapper(editor, objectClass)) {
            WrapperMethodInfo wrapperJavaInfo = (WrapperMethodInfo)JavaInfoUtils.createJavaInfo(editor, objectClass, (CreationSupport)creationSupport);
            wrapperJavaInfo.getWrapper().configureWrapper(factoryMethodDescription, argumentInfos);
            return wrapperJavaInfo;
        }
        NonVisualBeanInfo nonVisualInfo = NonVisualBeanContainerInfo.getNonVisualInfo((ASTNode)invocation);
        if (nonVisualInfo != null) {
            JavaInfo javaInfo = JavaInfoUtils.createJavaInfo(editor, objectClass, (CreationSupport)creationSupport);
            nonVisualInfo.setJavaInfo(javaInfo);
            return javaInfo;
        }
        return null;
    }

    protected JavaInfo createInstanceFactory(AstEditor editor, MethodInvocation invocation, IMethodBinding methodBinding, JavaInfo[] argumentInfos, InstanceFactoryInfo factoryInfo, FactoryMethodDescription description) throws Exception {
        Class<?> returnClass = description.getReturnClass();
        if (returnClass.isInterface()) {
            return null;
        }
        JavaInfo javaInfo = JavaInfoUtils.createJavaInfo(editor, returnClass, (CreationSupport)new InstanceFactoryCreationSupport(factoryInfo, description, invocation));
        for (ParameterDescription parameter : description.getParameters()) {
            JavaInfo parameterJavaInfo;
            if (!parameter.isParent() || (parameterJavaInfo = argumentInfos[parameter.getIndex()]) == null) continue;
            javaInfo.setAssociation(new FactoryParentAssociation(invocation));
            parameterJavaInfo.addChild(javaInfo);
        }
        NonVisualBeanInfo nonVisualInfo = NonVisualBeanContainerInfo.getNonVisualInfo((ASTNode)invocation);
        if (nonVisualInfo != null) {
            nonVisualInfo.setJavaInfo(javaInfo);
        }
        return javaInfo;
    }

    protected JavaInfo createImplicitFactory(AstEditor editor, MethodInvocation invocation, JavaInfo expressionInfo, JavaInfo[] argumentInfos, MethodDescription methodDescription) throws Exception {
        JavaInfo javaInfo = JavaInfoUtils.createJavaInfo(editor, methodDescription.getReturnClass(), (CreationSupport)new ImplicitFactoryCreationSupport(methodDescription, invocation));
        for (ParameterDescription parameter : methodDescription.getParameters()) {
            JavaInfo parameterJavaInfo = argumentInfos[parameter.getIndex()];
            if (parameter.isParent()) {
                javaInfo.setAssociation(new FactoryParentAssociation(invocation));
                parameterJavaInfo.addChild(javaInfo);
            }
            if (!parameter.hasTrueTag("implicitFactory.child")) continue;
            Assert.isNotNull((Object)((Object)parameterJavaInfo), (String)"Argument %d in %s %s should be not-null JavaInfo.", (Object[])new Object[]{parameter.getIndex(), methodDescription, invocation});
            parameterJavaInfo.setAssociation(new ImplicitFactoryArgumentAssociation(invocation, javaInfo));
            javaInfo.addChild(parameterJavaInfo);
        }
        if (javaInfo.getParent() == null) {
            javaInfo.setAssociation(new InvocationVoidAssociation(invocation));
            expressionInfo.addChild(javaInfo);
        }
        return javaInfo;
    }

    protected abstract String getToolkitId();

    protected void initializeClassLoader(AstEditor editor) throws Exception {
        EditorState editorState = EditorState.get(editor);
        if (editorState.isInitialized()) {
            return;
        }
        String toolkitId = this.getToolkitId();
        ClassLoader classLoader = this.getClassLoader(editor);
        editorState.initialize(toolkitId, classLoader);
        AbstractParseFactory.initializeClassLoader(classLoader, toolkitId);
        IJavaProject javaProject = editor.getJavaProject();
        AbstractParseFactory.runUserConfigurationScripts(editorState, javaProject);
        AbstractParseFactory.configureDescriptionVersionsProviders(editorState, javaProject);
    }

    protected ClassLoader getClassLoader(AstEditor editor) throws Exception {
        CompositeClassLoader parentClassLoader = this.createClassLoader_parent(editor);
        this.initializeClassLoader_parent(editor, parentClassLoader);
        ClassLoader projectClassLoader = this.createClassLoader_project(editor, parentClassLoader);
        return AbstractParseFactory.createCompositeLoader(projectClassLoader, this.getToolkitId());
    }

    protected CompositeClassLoader createClassLoader_parent(AstEditor editor) throws Exception {
        return new CompositeClassLoader();
    }

    protected void initializeClassLoader_parent(AstEditor editor, CompositeClassLoader parentClassLoader) throws Exception {
        parentClassLoader.add((ClassLoader)new BundleClassLoader("org.eclipse.wb.core.java"), List.of("net.bytebuddy.", "org.eclipse.wb.internal.core.model.creation"));
        parentClassLoader.add(FrameworkUtil.getBundle(MVEL.class));
        List<IConfigurationElement> toolkitElements = DescriptionHelper.getToolkitElements(this.getToolkitId());
        for (IConfigurationElement toolkitElement : toolkitElements) {
            IConfigurationElement[] contributorElements;
            IConfigurationElement[] iConfigurationElementArray = contributorElements = toolkitElement.getChildren("classLoader-bundle");
            int n = contributorElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement contributorElement = iConfigurationElementArray[n2];
                Bundle bundle = AbstractParseFactory.getExistingBundle(contributorElement);
                List<String> namespaces = AbstractParseFactory.getBundleClassLoaderNamespaces(contributorElement);
                BundleClassLoader classLoader = new BundleClassLoader(bundle);
                parentClassLoader.add((ClassLoader)classLoader, namespaces);
                ++n2;
            }
        }
    }

    private static List<String> getBundleClassLoaderNamespaces(IConfigurationElement contributorElement) {
        String namespacesString = contributorElement.getAttribute("namespaces");
        if (namespacesString != null) {
            return List.of(StringUtils.split((String)namespacesString));
        }
        return null;
    }

    protected ClassLoader createClassLoader_project(AstEditor editor, CompositeClassLoader parentClassLoader) throws Exception {
        return ProjectClassLoader.create((ClassLoader)parentClassLoader, editor.getJavaProject());
    }

    /*
     * WARNING - void declaration
     */
    protected static CompositeClassLoader createCompositeLoader(ClassLoader mainClassLoader, String toolkitId) throws Exception {
        IConfigurationElement[] contributorElements;
        List<IConfigurationElement> toolkitElements = DescriptionHelper.getToolkitElements(toolkitId);
        CompositeClassLoader compositeClassLoader = new CompositeClassLoader();
        compositeClassLoader.add(mainClassLoader, null);
        ClassLoader classLoader = mainClassLoader;
        if (classLoader instanceof ProjectClassLoader) {
            ProjectClassLoader projectClassLoader = (ProjectClassLoader)classLoader;
            ProjectClassLoader cfr_ignored_0 = (ProjectClassLoader)classLoader;
            for (IConfigurationElement toolkitElement : toolkitElements) {
                IConfigurationElement[] iConfigurationElementArray = contributorElements = toolkitElement.getChildren("classPath-byteCode-processor");
                int n = contributorElements.length;
                int n2 = 0;
                while (n2 < n) {
                    void projectClassLoader2;
                    IConfigurationElement contributorElement = iConfigurationElementArray[n2];
                    IByteCodeProcessor processor = (IByteCodeProcessor)contributorElement.createExecutableExtension("processor");
                    projectClassLoader2.add(processor);
                    ++n2;
                }
            }
        }
        for (IConfigurationElement toolkitElement : toolkitElements) {
            contributorElements = toolkitElement.getChildren("classLoader-library");
            if (contributorElements.length == 0) continue;
            URL[] urls = new URL[contributorElements.length];
            int i = 0;
            while (i < contributorElements.length) {
                IConfigurationElement contributorElement = contributorElements[i];
                Bundle bundle = AbstractParseFactory.getExistingBundle(contributorElement);
                String jarPath = contributorElement.getAttribute("jar");
                URL jarEntry = bundle.getEntry(jarPath);
                Assert.isNotNull((Object)jarEntry, (String)"Unable to find %s in %s", (Object[])new Object[]{jarPath, bundle.getSymbolicName()});
                urls[i] = FileLocator.toFileURL((URL)jarEntry);
                ++i;
            }
            compositeClassLoader.add((ClassLoader)new URLClassLoader(urls, mainClassLoader), null);
        }
        return compositeClassLoader;
    }

    private static Bundle getExistingBundle(IConfigurationElement contributorElement) {
        String bundleId = ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)contributorElement, (String)"bundle");
        return AbstractParseFactory.getExistingBundle(bundleId);
    }

    private static Bundle getExistingBundle(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        Assert.isNotNull((Object)bundle, (String)"Unable to find Bundle %s", (Object[])new Object[]{bundleId});
        return bundle;
    }

    protected static void initializeClassLoader(ClassLoader classLoader, String toolkitId) throws Exception {
        List elements = ExternalFactoriesHelper.getElements((String)"org.eclipse.wb.core.java.classLoaderInitializers", (String)"initializer");
        for (IConfigurationElement element : elements) {
            if (!ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"toolkit").equals(toolkitId)) continue;
            IClassLoaderInitializer initializer = (IClassLoaderInitializer)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
            initializer.initialize(classLoader);
        }
    }

    public static void deinitializeClassLoader(ClassLoader classLoader, String toolkitId) throws Exception {
        List elements = ExternalFactoriesHelper.getElements((String)"org.eclipse.wb.core.java.classLoaderInitializers", (String)"initializer");
        for (IConfigurationElement element : elements) {
            if (!ExternalFactoriesHelper.getRequiredAttribute((IConfigurationElement)element, (String)"toolkit").equals(toolkitId)) continue;
            IClassLoaderInitializer initializer = (IClassLoaderInitializer)ExternalFactoriesHelper.createExecutableExtension((IConfigurationElement)element, (String)"class");
            initializer.deinitialize(classLoader);
        }
    }

    protected static void configureDescriptionVersionsProviders(EditorState editorState, IJavaProject javaProject) throws Exception {
        ClassLoader classLoader = editorState.getEditorLoader();
        List factories = ExternalFactoriesHelper.getElementsInstances(IDescriptionVersionsProviderFactory.class, (String)"org.eclipse.wb.core.descriptionVersionsProviderFactories", (String)"factory");
        for (IDescriptionVersionsProviderFactory factory : factories) {
            editorState.addVersions(factory.getVersions(javaProject, classLoader));
            IDescriptionVersionsProvider provider = factory.getProvider(javaProject, classLoader);
            if (provider == null) continue;
            editorState.addDescriptionVersionsProvider(provider);
        }
    }

    protected static void runUserConfigurationScripts(EditorState editorState, IJavaProject javaProject) throws Exception {
        ClassLoader classLoader = editorState.getEditorLoader();
        List<IFile> scriptFiles = ProjectUtils.findFiles(javaProject, "wbp-meta/ConfigureClassLoader.mvel");
        for (IFile scriptFile : scriptFiles) {
            String script = IOUtils2.readString((IFile)scriptFile);
            try {
                ScriptUtils.evaluate((ClassLoader)classLoader, (String)script);
            }
            catch (Throwable e) {
                String message = MessageFormat.format("Can not execute {0}\n{1}", scriptFile.getFullPath().toPortableString(), script);
                editorState.addWarning(new EditorWarning(message, e));
            }
        }
    }
}

