/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import org.apache.commons.lang.ObjectUtils;
import org.eclipse.wb.core.controls.CCombo3;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.IValueSourcePropertyEditor;

public class EnumerationValuesPropertyEditor
extends AbstractComboPropertyEditor
implements IValueSourcePropertyEditor,
IClipboardSourceProvider {
    private final String[] m_names;
    private final Object[] m_values;
    private final String[] m_sources;

    public EnumerationValuesPropertyEditor(Object attributeValue) {
        Object[] enumElements = (Object[])attributeValue;
        int items = enumElements.length / 3;
        this.m_names = new String[items];
        this.m_values = new Object[items];
        this.m_sources = new String[items];
        int i = 0;
        while (i < items) {
            this.m_names[i] = (String)enumElements[3 * i + 0];
            this.m_values[i] = enumElements[3 * i + 1];
            this.m_sources[i] = (String)enumElements[3 * i + 2];
            ++i;
        }
    }

    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value != Property.UNKNOWN_VALUE) {
            int i = 0;
            while (i < this.m_values.length) {
                if (ObjectUtils.equals((Object)this.m_values[i], (Object)value)) {
                    return this.m_names[i];
                }
                ++i;
            }
        }
        return null;
    }

    public String getValueSource(Object value) throws Exception {
        if (value != Property.UNKNOWN_VALUE) {
            int i = 0;
            while (i < this.m_values.length) {
                if (ObjectUtils.equals((Object)this.m_values[i], (Object)value)) {
                    return this.m_sources[i];
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public String getClipboardSource(GenericProperty property) throws Exception {
        Object value = property.getValue();
        return this.getValueSource(value);
    }

    protected void addItems(Property property, CCombo3 combo) throws Exception {
        String[] stringArray = this.m_names;
        int n = this.m_names.length;
        int n2 = 0;
        while (n2 < n) {
            String title = stringArray[n2];
            combo.add(title);
            ++n2;
        }
    }

    protected void selectItem(Property property, CCombo3 combo) throws Exception {
        combo.setText(this.getText(property));
    }

    /*
     * WARNING - void declaration
     */
    protected void toPropertyEx(Property property, CCombo3 combo, int index) throws Exception {
        Object value = this.m_values[index];
        Property property2 = property;
        if (property2 instanceof GenericProperty) {
            void genericProperty;
            GenericProperty genericProperty2 = (GenericProperty)property2;
            GenericProperty cfr_ignored_0 = (GenericProperty)property2;
            String source = this.getValueSource(value);
            genericProperty.setExpression(source, value);
        } else {
            property.setValue(value);
        }
    }
}

