/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.nonvisual;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.InvocationChildArrayAssociation;
import org.eclipse.wb.internal.core.model.nonvisual.AbstractArrayObjectInfo;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class ArrayObjectInfo
extends AbstractArrayObjectInfo {
    private final ArrayCreation m_creation;

    public ArrayObjectInfo(AstEditor editor, String caption, Class<?> itemType, ArrayCreation creation) throws Exception {
        super(editor, caption, itemType);
        this.m_creation = creation;
    }

    public ArrayObjectInfo(AstEditor editor, String caption, ArrayCreation creation) throws Exception {
        this(editor, caption, ReflectionUtils.getClassByName((ClassLoader)EditorState.get(editor).getEditorLoader(), (String)creation.getType().getComponentType().resolveBinding().getQualifiedName()), creation);
    }

    public ArrayCreation getCreation() {
        return this.m_creation;
    }

    @Override
    protected Expression createItemExpression(JavaInfo item, int index, String source) throws Exception {
        return this.getEditor().addArrayElement(this.m_creation.getInitializer(), index, source);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Expression getMoveItemExpression(JavaInfo item, JavaInfo nextItem, AbstractArrayObjectInfo oldAbstractArrayInfo, int oldIndex, int newIndex) throws Exception {
        Expression element;
        AbstractArrayObjectInfo abstractArrayObjectInfo = oldAbstractArrayInfo;
        if (abstractArrayObjectInfo instanceof ArrayObjectInfo) {
            void oldArrayInfo;
            ArrayObjectInfo arrayObjectInfo = (ArrayObjectInfo)abstractArrayObjectInfo;
            ArrayObjectInfo cfr_ignored_0 = (ArrayObjectInfo)abstractArrayObjectInfo;
            ArrayInitializer oldArray = oldArrayInfo.m_creation.getInitializer();
            ArrayInitializer newArray = this.m_creation.getInitializer();
            if (oldArray.equals((Object)newArray)) {
                this.getParent().moveChild((ObjectInfo)item, (ObjectInfo)nextItem);
                this.m_items.remove((Object)item);
                this.m_items.add(newIndex, item);
                element = this.getEditor().moveArrayElement(oldArray, newArray, oldIndex, newIndex);
            } else {
                element = this.moveFromArray(oldArray, oldIndex, newArray, newIndex, item, nextItem);
            }
        } else {
            element = this.moveOther(item, nextItem, newIndex);
        }
        return element;
    }

    private Expression moveFromArray(ArrayInitializer oldArray, int oldIndex, ArrayInitializer newArray, int newIndex, JavaInfo item, JavaInfo nextItem) throws Exception {
        AstEditor editor = this.getEditor();
        String source = editor.getSource((ASTNode)DomGenerics.expressions(oldArray).get(oldIndex));
        Association association = item.getAssociation();
        if (association != null) {
            if (association.remove()) {
                item.setAssociation(null);
            }
        } else {
            editor.removeArrayElement(oldArray, oldIndex);
        }
        item.getParent().removeChild((ObjectInfo)item);
        this.getParent().addChild((ObjectInfo)item, (ObjectInfo)nextItem);
        this.addItem(newIndex, item);
        if (!(item.getVariableSupport() instanceof EmptyVariableSupport)) {
            item.getVariableSupport().ensureInstanceReadyAt(this.getStatementTarget());
            source = item.getVariableSupport().getReferenceExpression(this.getNodeTarget());
        }
        return this.getCreateItemExpression(item, newIndex, source);
    }

    @Override
    protected NodeTarget getNodeTarget() {
        return new NodeTarget(this.getStatementTarget());
    }

    @Override
    protected StatementTarget getStatementTarget() {
        return new StatementTarget(AstNodeUtils.getEnclosingStatement((ASTNode)this.m_creation), true);
    }

    @Override
    protected Association getAssociation(Expression element) {
        ASTNode parentNode = this.m_creation.getParent();
        if (parentNode instanceof MethodInvocation) {
            return new InvocationChildArrayAssociation((MethodInvocation)parentNode, this);
        }
        Assert.fail((String)"ArrayObjectInfo supported association only for MethodInvocation.");
        return null;
    }
}

