/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wb.internal.core.xml.editor.AbstractXmlEditor;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class AbstractXmlEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart m_activeEditor;
    private AbstractXmlEditor m_designerEditor;

    public void setActiveEditor(IEditorPart part) {
        if (part instanceof MultiPageEditorPart) {
            this.m_designerEditor = (AbstractXmlEditor)part;
        }
        super.setActiveEditor(part);
    }

    public void setActivePage(IEditorPart part) {
        if (this.m_activeEditor == part) {
            return;
        }
        this.m_activeEditor = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            this.redirectTextActions(actionBars);
        }
    }

    private void redirectTextActions(IActionBars actionBars) {
        ITextEditor editor = this.m_activeEditor instanceof ITextEditor ? (ITextEditor)this.m_activeEditor : null;
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, ITextEditorActionConstants.DELETE);
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, ITextEditorActionConstants.CUT);
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, ITextEditorActionConstants.COPY);
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, ITextEditorActionConstants.PASTE);
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, ITextEditorActionConstants.SELECT_ALL);
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, ITextEditorActionConstants.FIND);
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, "DeleteLine");
        AbstractXmlEditorContributor.redirectTextAction(actionBars, editor, IDEActionFactory.BOOKMARK.getId());
        if (this.m_activeEditor == null && this.m_designerEditor != null) {
            StructuredTextEditor xmlEditor = this.m_designerEditor.getSourcePage().getXmlEditor();
            AbstractXmlEditorContributor.redirectTextAction(actionBars, (ITextEditor)xmlEditor, ITextEditorActionConstants.UNDO);
            AbstractXmlEditorContributor.redirectTextAction(actionBars, (ITextEditor)xmlEditor, ITextEditorActionConstants.REDO);
        }
        actionBars.updateActionBars();
    }

    private static void redirectTextAction(IActionBars actionBars, ITextEditor editor, String id) {
        actionBars.setGlobalActionHandler(id, AbstractXmlEditorContributor.getTextAction(editor, id));
    }

    private static IAction getTextAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }
}

