/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TableTextCellEditor
extends CellEditor {
    private static final int DEFAULT_STYLE = 4;
    private final TableViewer m_viewer;
    private final int m_column;
    private String m_originalValue;
    private Text m_text;
    private boolean isSelection = false;
    private boolean isDeleteable = false;
    private boolean isSelectable = false;

    public TableTextCellEditor(TableViewer viewer, int column) {
        super((Composite)viewer.getTable(), 4);
        this.m_viewer = viewer;
        this.m_column = column;
    }

    public void activate() {
        super.activate();
        this.m_originalValue = this.m_text.getText();
    }

    protected Control createControl(Composite parent) {
        Composite result = new Composite(parent, 0){

            public void addListener(int eventType, Listener listener) {
                if (eventType != 15 && eventType != 16) {
                    TableTextCellEditor.this.m_text.addListener(eventType, listener);
                }
            }
        };
        result.setFont(parent.getFont());
        result.setBackground(parent.getBackground());
        result.setLayout((Layout)new FillLayout());
        this.m_text = new Text(result, this.getStyle());
        this.m_text.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TableTextCellEditor.this.handleDefaultSelection(e);
            }
        });
        this.m_text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 0x1000002: {
                        e.doit = false;
                        int nextRow = TableTextCellEditor.this.m_viewer.getTable().getSelectionIndex() + 1;
                        if (nextRow >= TableTextCellEditor.this.m_viewer.getTable().getItemCount()) break;
                        this.editRow(nextRow);
                        break;
                    }
                    case 0x1000001: {
                        e.doit = false;
                        int prevRow = TableTextCellEditor.this.m_viewer.getTable().getSelectionIndex() - 1;
                        if (prevRow < 0) break;
                        this.editRow(prevRow);
                    }
                }
            }

            private void editRow(int row) {
                TableTextCellEditor.this.m_viewer.getTable().setSelection(row);
                IStructuredSelection newSelection = (IStructuredSelection)TableTextCellEditor.this.m_viewer.getSelection();
                if (newSelection.size() == 1) {
                    TableTextCellEditor.this.m_viewer.editElement(newSelection.getFirstElement(), TableTextCellEditor.this.m_column);
                }
            }
        });
        this.m_text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TableTextCellEditor.this.keyReleaseOccured(e);
                if (TableTextCellEditor.this.getControl() == null || TableTextCellEditor.this.getControl().isDisposed()) {
                    return;
                }
                TableTextCellEditor.this.checkSelection();
                TableTextCellEditor.this.checkDeleteable();
                TableTextCellEditor.this.checkSelectable();
            }
        });
        this.m_text.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.m_text.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableTextCellEditor.this.checkSelection();
                TableTextCellEditor.this.checkDeleteable();
                TableTextCellEditor.this.checkSelectable();
            }
        });
        this.m_text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                TableTextCellEditor.this.focusLost();
            }
        });
        this.m_text.setFont(parent.getFont());
        this.m_text.setBackground(parent.getBackground());
        this.m_text.setText("");
        return result;
    }

    protected void fireCancelEditor() {
        this.m_text.setText(this.m_originalValue);
        super.fireApplyEditorValue();
    }

    protected Object doGetValue() {
        return this.m_text.getText();
    }

    protected void doSetFocus() {
        if (this.m_text != null) {
            this.m_text.selectAll();
            this.m_text.setFocus();
            this.checkSelection();
            this.checkDeleteable();
            this.checkSelectable();
        }
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((this.m_text != null && value instanceof String ? 1 : 0) != 0);
        this.m_text.setText((String)value);
    }

    public CellEditor.LayoutData getLayoutData() {
        return new CellEditor.LayoutData();
    }

    protected void handleDefaultSelection(SelectionEvent event) {
        this.fireApplyEditorValue();
        this.deactivate();
    }

    protected void keyReleaseOccured(KeyEvent keyEvent) {
        if (keyEvent.character == '\r') {
            if (this.m_text != null && !this.m_text.isDisposed() && (this.m_text.getStyle() & 2) != 0 && (keyEvent.stateMask & 0x40000) != 0) {
                super.keyReleaseOccured(keyEvent);
            }
            return;
        }
        super.keyReleaseOccured(keyEvent);
    }

    public Text getText() {
        return this.m_text;
    }

    protected void checkSelection() {
        boolean oldIsSelection = this.isSelection;
        boolean bl = this.isSelection = this.m_text.getSelectionCount() > 0;
        if (oldIsSelection != this.isSelection) {
            this.fireEnablementChanged("copy");
            this.fireEnablementChanged("cut");
        }
    }

    protected void checkDeleteable() {
        boolean oldIsDeleteable = this.isDeleteable;
        this.isDeleteable = this.isDeleteEnabled();
        if (oldIsDeleteable != this.isDeleteable) {
            this.fireEnablementChanged("delete");
        }
    }

    protected void checkSelectable() {
        boolean oldIsSelectable = this.isSelectable;
        this.isSelectable = this.isSelectAllEnabled();
        if (oldIsSelectable != this.isSelectable) {
            this.fireEnablementChanged("selectall");
        }
    }

    public boolean isCopyEnabled() {
        if (this.m_text == null || this.m_text.isDisposed()) {
            return false;
        }
        return this.m_text.getSelectionCount() > 0;
    }

    public boolean isCutEnabled() {
        if (this.m_text == null || this.m_text.isDisposed()) {
            return false;
        }
        return this.m_text.getSelectionCount() > 0;
    }

    public boolean isDeleteEnabled() {
        if (this.m_text == null || this.m_text.isDisposed()) {
            return false;
        }
        return this.m_text.getSelectionCount() > 0 || this.m_text.getCaretPosition() < this.m_text.getCharCount();
    }

    public boolean isPasteEnabled() {
        return this.m_text != null && !this.m_text.isDisposed();
    }

    public boolean isSelectAllEnabled() {
        if (this.m_text == null || this.m_text.isDisposed()) {
            return false;
        }
        return this.m_text.getCharCount() > 0;
    }

    public void performCopy() {
        this.m_text.copy();
    }

    public void performCut() {
        this.m_text.cut();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performDelete() {
        if (this.m_text.getSelectionCount() > 0) {
            this.m_text.insert("");
        } else {
            int pos = this.m_text.getCaretPosition();
            if (pos < this.m_text.getCharCount()) {
                this.m_text.setSelection(pos, pos + 1);
                this.m_text.insert("");
            }
        }
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performPaste() {
        this.m_text.paste();
        this.checkSelection();
        this.checkDeleteable();
        this.checkSelectable();
    }

    public void performSelectAll() {
        this.m_text.selectAll();
        this.checkSelection();
        this.checkDeleteable();
    }
}

