/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import com.google.common.collect.Lists;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.eval.ExecutionFlowUtils;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.AssociationUtils;
import org.eclipse.wb.internal.core.model.variable.FieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.NamesManager;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.BodyDeclarationTarget;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.core.utils.check.Assert;

public final class FieldInitializerVariableSupport
extends FieldVariableSupport {
    private boolean m_forceStaticModifier;
    private static final String BASE = "variable.fieldInitializer.";
    public static final String P_PREFIX_THIS = "variable.fieldInitializer.prefixThis";
    public static final String P_FIELD_MODIFIER = "variable.fieldInitializer.fieldModifier";

    public FieldInitializerVariableSupport(JavaInfo javaInfo) {
        super(javaInfo);
    }

    public FieldInitializerVariableSupport(JavaInfo javaInfo, Expression variable) {
        super(javaInfo, variable);
    }

    public String toString() {
        return "field-initializer: " + this.getName();
    }

    @Override
    public void setName(String newName) throws Exception {
        this.modifyName(newName);
    }

    @Override
    public StatementTarget getStatementTarget() throws Exception {
        List<Statement> statements = this.getRelatedStatements();
        if (!statements.isEmpty()) {
            Collections.sort(statements, AstNodeUtils.SORT_BY_POSITION);
            Statement targetStatement = statements.get(0);
            return new StatementTarget(targetStatement, true);
        }
        MethodDeclaration targetMethod = this.getTargetMethod();
        Assert.isNotNull((Object)targetMethod, (String)("Unable to find target method for " + (Object)((Object)this.m_javaInfo)));
        List<Statement> targetStatements = DomGenerics.statements(targetMethod);
        Statement firstTargetStatement = (Statement)GenericsUtils.getFirstOrNull(targetStatements);
        if (firstTargetStatement instanceof SuperConstructorInvocation) {
            return new StatementTarget(firstTargetStatement, false);
        }
        return new StatementTarget(targetMethod, true);
    }

    private MethodDeclaration getTargetMethod() {
        FieldDeclaration field = AstNodeUtils.getEnclosingNode((ASTNode)this.m_variable, FieldDeclaration.class);
        final boolean staticField = Modifier.isStatic(field.getModifiers());
        int position = this.m_javaInfo.getRootJava().getCreationSupport().getNode().getStartPosition();
        MethodDeclaration enclosingMethod = this.m_javaInfo.getEditor().getEnclosingMethod(position);
        if (enclosingMethod != null && (staticField || !Modifier.isStatic(enclosingMethod.getModifiers()))) {
            return enclosingMethod;
        }
        final MethodDeclaration[] targetMethod = new MethodDeclaration[1];
        ExecutionFlowUtils.visit(new ExecutionFlowUtils.VisitingContext(true), this.getFlowDescription(), new ExecutionFlowUtils.ExecutionFlowFrameVisitor(){

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean enterFrame(ASTNode node) {
                ASTNode aSTNode = node;
                if (aSTNode instanceof MethodDeclaration) {
                    void methodDeclaration;
                    MethodDeclaration methodDeclaration2 = (MethodDeclaration)aSTNode;
                    MethodDeclaration cfr_ignored_0 = (MethodDeclaration)aSTNode;
                    if (staticField || !Modifier.isStatic(methodDeclaration.getModifiers())) {
                        targetMethod[0] = methodDeclaration;
                    }
                }
                return targetMethod[0] == null;
            }
        });
        return targetMethod[0];
    }

    @Override
    public void ensureInstanceReadyAt(StatementTarget target) throws Exception {
        this.moveStatements(target);
    }

    @Override
    public StatementTarget getAssociationTarget(StatementTarget target) throws Exception {
        List<Statement> statements = this.getRelatedStatements();
        if (!statements.isEmpty()) {
            return this.getStatementTarget();
        }
        return target;
    }

    private List<Statement> getRelatedStatements() {
        Statement associationStatement;
        ArrayList statements = Lists.newArrayList();
        if (this.m_javaInfo.getAssociation() != null && (associationStatement = this.m_javaInfo.getAssociation().getStatement()) != null) {
            statements.add(associationStatement);
        }
        for (ASTNode relatedNode : this.m_javaInfo.getRelatedNodes()) {
            Assignment fieldAssignment;
            MethodInvocation invocation = this.m_javaInfo.getMethodInvocation(relatedNode);
            if (invocation != null && invocation.getLocationInParent() == ExpressionStatement.EXPRESSION_PROPERTY) {
                statements.add((Statement)invocation.getParent());
                continue;
            }
            Expression fieldAccess = AstNodeUtils.getFieldAssignment(relatedNode);
            if (fieldAccess == null || (fieldAssignment = (Assignment)fieldAccess.getParent()).getLocationInParent() != ExpressionStatement.EXPRESSION_PROPERTY) continue;
            statements.add((Statement)fieldAssignment.getParent());
        }
        return statements;
    }

    @Override
    public boolean canConvertFieldToLocal() {
        return false;
    }

    @Override
    public void convertFieldToLocal() throws Exception {
        throw new IllegalStateException();
    }

    @Override
    public String add_getVariableStatementSource(StatementTarget associationTarget) throws Exception {
        NodeTarget creationTarget = FieldInitializerVariableSupport.getCreationTarget(associationTarget);
        String initializer = this.m_javaInfo.getCreationSupport().add_getSource(creationTarget);
        initializer = AssociationUtils.replaceTemplates(this.m_javaInfo, initializer, creationTarget);
        VariableDeclarationFragment fragment = this.addUniqueField(associationTarget.getPosition(), initializer);
        this.add_setVariableAndInitializer((Expression)fragment.getName(), fragment.getInitializer());
        return null;
    }

    private static NodeTarget getCreationTarget(StatementTarget associationTarget) {
        TypeDeclaration targetTypeDeclaration = AstNodeUtils.getEnclosingType(associationTarget.getNode());
        BodyDeclarationTarget newFieldTarget = new BodyDeclarationTarget(targetTypeDeclaration, true);
        return new NodeTarget(newFieldTarget);
    }

    @Override
    public void deleteAfter() throws Exception {
        if (this.m_javaInfo.isRoot()) {
            return;
        }
        this.delete_removeDeclarationField();
    }

    @Override
    public void setType(String newTypeName) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        editor.replaceVariableType(this.m_declaration, newTypeName);
    }

    private VariableDeclarationFragment addUniqueField(int position, String initializer) throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        String className = this.m_javaInfo.getDescription().getComponentClass().getName();
        String fieldName = editor.getUniqueVariableName(-1, NamesManager.getName(this.m_javaInfo), null);
        String modifiers = FieldInitializerVariableSupport.perfFieldModifier(this.m_javaInfo);
        if (this.m_forceStaticModifier || this.isStaticContext(position)) {
            modifiers = String.valueOf(modifiers) + "static ";
        }
        modifiers = String.valueOf(modifiers) + "final ";
        String fieldSource = String.valueOf(modifiers) + className + " " + fieldName;
        if (initializer != null) {
            initializer = StringUtils.replace((String)initializer, (String)"%variable-name%", (String)fieldName);
            fieldSource = String.valueOf(fieldSource) + " = " + initializer;
        }
        FieldDeclaration fieldDeclaration = this.addField(String.valueOf(fieldSource) + ";");
        return (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
    }

    public void setForceStaticModifier(boolean forceStaticModifier) {
        this.m_forceStaticModifier = forceStaticModifier;
    }

    @Override
    protected boolean prefixThis() {
        return this.getPreferences().getBoolean(P_PREFIX_THIS);
    }

    public static String perfFieldModifier(JavaInfo javaInfo) {
        IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
        return V_MODIFIER_CODE[preferences.getInt(P_FIELD_MODIFIER)];
    }
}

