/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.part;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.EditPolicy;
import org.eclipse.wb.gef.graphical.GraphicalEditPart;
import org.eclipse.wb.internal.core.gef.part.nonvisual.NonVisualBeanEditPart;
import org.eclipse.wb.internal.core.gef.policy.nonvisual.NonVisualLayoutEditPolicy;
import org.eclipse.wb.internal.core.model.DesignRootObject;
import org.eclipse.wb.internal.core.model.nonvisual.NonVisualBeanInfo;
import org.eclipse.wb.internal.draw2d.FigureCanvas;
import org.eclipse.wb.internal.draw2d.IPreferredSizeProvider;

public final class DesignRootEditPart
extends GraphicalEditPart {
    private final DesignRootObject m_designRootObject;

    public DesignRootEditPart(DesignRootObject designRootObject) {
        this.m_designRootObject = designRootObject;
        this.setModel(this.m_designRootObject);
    }

    public void activate() {
        this.refreshVisualsOnModelRefresh();
        super.activate();
    }

    private void refreshVisualsOnModelRefresh() {
        this.m_designRootObject.getRootObject().addBroadcastListener(new ObjectEventListener(){

            public void refreshDispose() throws Exception {
                if (DesignRootEditPart.this.isActive()) {
                    this.getFigureCanvas().setDrawCached(true);
                }
            }

            public void refreshed() throws Exception {
                this.getFigureCanvas().setDrawCached(false);
                this.getFigureCanvas().redraw();
                DesignRootEditPart.this.refresh();
            }

            private FigureCanvas getFigureCanvas() {
                return (FigureCanvas)DesignRootEditPart.this.getViewer().getControl();
            }
        });
    }

    protected void createEditPolicies() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new NonVisualLayoutEditPolicy(this.m_designRootObject.getRootObject()));
    }

    protected List<?> getModelChildren() {
        return this.m_designRootObject.getChildren();
    }

    protected EditPart createEditPart(Object model) {
        if (this.m_designRootObject.getRootObject() != model) {
            JavaInfo javaInfo = (JavaInfo)((Object)model);
            NonVisualBeanInfo nonVisualInfo = NonVisualBeanInfo.getNonVisualInfo(javaInfo);
            if (nonVisualInfo != null && nonVisualInfo.getLocation() != null) {
                return new NonVisualBeanEditPart(javaInfo);
            }
            return null;
        }
        return super.createEditPart(model);
    }

    public EditPart getJavaRootEditPart() {
        return (EditPart)this.getChildren().get(0);
    }

    protected Figure createFigure() {
        return new TopFigure();
    }

    private static final class TopFigure
    extends Figure
    implements IPreferredSizeProvider {
        private TopFigure() {
        }

        public Rectangle getBounds() {
            Figure parentFigure = this.getParent();
            if (parentFigure != null) {
                return new Rectangle(new Point(), parentFigure.getSize());
            }
            return super.getBounds();
        }

        public Dimension getPreferredSize(Dimension originalPreferredSize) {
            Rectangle preferred = new Rectangle();
            for (Figure figure : this.getChildren()) {
                if (!figure.isVisible()) continue;
                preferred.union(figure.getBounds());
            }
            return preferred.getSize();
        }
    }
}

