/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.IoActions;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.impldep.javax.annotation.Nullable;
import org.gradle.internal.io.StreamByteBuffer;

public class TransformReplacer
implements Closeable {
    private static final Loader SKIP_INSTRUMENTATION = new Loader();
    private final ConcurrentMap<ProtectionDomain, Loader> loaders = new ConcurrentHashMap<ProtectionDomain, Loader>();
    private final TransformedClassPath classPath;
    private volatile boolean closed;

    public TransformReplacer(TransformedClassPath classPath) {
        this.classPath = classPath;
    }

    @Nullable
    public byte[] getInstrumentedClass(@Nullable String className, @Nullable ProtectionDomain protectionDomain) {
        this.ensureOpened();
        if (className == null || protectionDomain == null) {
            return null;
        }
        try {
            return this.getLoader(protectionDomain).loadTransformedClass(className);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Loader getLoader(ProtectionDomain domain) {
        Loader transformLoader = (Loader)this.loaders.get(domain);
        if (transformLoader == null) {
            transformLoader = this.storeIfAbsent(domain, this.createLoaderForDomain(domain));
            if (this.closed) {
                IoActions.closeQuietly(transformLoader);
                this.ensureOpened();
            }
        }
        return transformLoader;
    }

    private Loader createLoaderForDomain(ProtectionDomain domain) {
        File transformedJarPath = this.findTransformedFile(domain);
        return transformedJarPath != null ? new JarLoader(transformedJarPath) : SKIP_INSTRUMENTATION;
    }

    private Loader storeIfAbsent(ProtectionDomain domain, Loader newLoader) {
        Loader oldLoader = this.loaders.putIfAbsent(domain, newLoader);
        if (oldLoader != null) {
            IoActions.closeQuietly(newLoader);
            return oldLoader;
        }
        return newLoader;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (Loader value : this.loaders.values()) {
            IoActions.closeQuietly(value);
        }
    }

    private void ensureOpened() {
        if (this.closed) {
            throw new IllegalStateException("Cannot load the transformed class, the replacer is closed");
        }
    }

    @Nullable
    private File findTransformedFile(ProtectionDomain protectionDomain) {
        URL originalUrl;
        CodeSource cs = protectionDomain.getCodeSource();
        URL uRL = originalUrl = cs != null ? cs.getLocation() : null;
        if (originalUrl == null || !"file".equals(originalUrl.getProtocol())) {
            return null;
        }
        try {
            return this.classPath.findTransformedJarFor(new File(originalUrl.toURI()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Cannot parse file URL " + originalUrl, e);
        }
    }

    private class JarLoader
    extends Loader {
        private final File jarFilePath;
        @Nullable
        private JarFile jarFile;

        public JarLoader(File transformedJarFile) {
            this.jarFilePath = transformedJarFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public synchronized byte[] loadTransformedClass(String className) throws IOException {
            JarFile jarFile = this.getJarFileLocked();
            JarEntry classEntry = jarFile.getJarEntry(this.classNameToPath(className));
            if (classEntry == null) {
                return null;
            }
            InputStream classBytes = jarFile.getInputStream(classEntry);
            try {
                byte[] byArray = StreamByteBuffer.of(classBytes).readAsByteArray();
                return byArray;
            }
            finally {
                classBytes.close();
            }
        }

        @Override
        public synchronized void close() {
            IoActions.closeQuietly(this.jarFile);
        }

        private JarFile getJarFileLocked() throws IOException {
            TransformReplacer.this.ensureOpened();
            if (this.jarFile == null) {
                try {
                    this.jarFile = new JarFile(this.jarFilePath, true, 1, JarFile.runtimeVersion());
                }
                catch (NoSuchMethodError e) {
                    this.jarFile = new JarFile(this.jarFilePath);
                }
            }
            return this.jarFile;
        }

        private String classNameToPath(String className) {
            return className + ".class";
        }
    }

    private static class Loader
    implements Closeable {
        private Loader() {
        }

        @Nullable
        public byte[] loadTransformedClass(String className) throws IOException {
            return null;
        }

        @Override
        public void close() {
        }
    }
}

