/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator.model;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorLanguage;
import org.eclipse.xtext.xtext.generator.util.GenModelUtil2;

public class TypeReference {
    private final String packageName;
    private final List<String> simpleNames;
    private final List<TypeReference> typeArguments;

    public static TypeReference typeRef(String name, TypeReference ... arguments) {
        return new TypeReference(name, arguments == null ? null : Arrays.asList(arguments));
    }

    @Deprecated
    public static TypeReference guessTypeRef(String name, TypeReference ... arguments) {
        return new TypeReference(name, arguments == null ? null : Arrays.asList(arguments), false);
    }

    public static TypeReference typeRef(Class<?> clazz, TypeReference ... arguments) {
        return new TypeReference(clazz, arguments == null ? null : Arrays.asList(arguments));
    }

    public static TypeReference typeRef(EClass clazz, IXtextGeneratorLanguage language) {
        ResourceSet _resourceSet = language.getResourceSet();
        return new TypeReference(clazz, _resourceSet);
    }

    public TypeReference(String qualifiedName) {
        this(qualifiedName, (List<TypeReference>)null);
    }

    public TypeReference(String qualifiedName, List<TypeReference> arguments) {
        this(qualifiedName, arguments, true);
    }

    private TypeReference(String qualifiedName, List<TypeReference> arguments, boolean strict) {
        this(TypeReference.getPackageName(qualifiedName, strict), TypeReference.getClassName(qualifiedName, strict), arguments);
    }

    public TypeReference(String packageName, String className) {
        this(packageName, className, null);
    }

    public TypeReference(String packageName, String className, List<TypeReference> arguments) {
        if (packageName == null) {
            throw new IllegalArgumentException("Invalid package name: " + packageName);
        }
        if (className == null) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
        this.packageName = packageName;
        this.simpleNames = Arrays.asList(className.split("\\."));
        if (arguments == null) {
            arguments = Collections.emptyList();
        }
        this.typeArguments = arguments;
    }

    public TypeReference(Class<?> clazz) {
        this(clazz, null);
    }

    public TypeReference(Class<?> clazz, List<TypeReference> arguments) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException("Type is primitive: " + clazz.getName());
        }
        if (clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Class is anonymous: " + clazz.getName());
        }
        if (clazz.isLocalClass()) {
            throw new IllegalArgumentException("Class is local: " + clazz.getName());
        }
        this.packageName = clazz.getPackage().getName();
        this.simpleNames = new ArrayList<String>();
        if (arguments == null) {
            arguments = Collections.emptyList();
        }
        this.typeArguments = arguments;
        Class<?> c = clazz;
        do {
            this.simpleNames.add(0, c.getSimpleName());
        } while ((c = c.getDeclaringClass()) != null);
    }

    public TypeReference(EClass clazz, ResourceSet resourceSet) {
        this(TypeReference.getQualifiedName(clazz, resourceSet));
    }

    public TypeReference(QualifiedClassName qualifiedClazzName) {
        this(qualifiedClazzName.packageName, qualifiedClazzName.className, null);
    }

    public TypeReference(EPackage epackage, ResourceSet resourceSet) {
        this(TypeReference.getQualifiedName(epackage, resourceSet));
    }

    private static String getPackageName(String qualifiedName, boolean strict) {
        List segments = IterableExtensions.toList((Iterable)Splitter.on((String)".").split((CharSequence)qualifiedName));
        if (segments.size() == 1) {
            return "";
        }
        if (strict) {
            List packageSegments = segments.subList(0, segments.size() - 1);
            if (!Iterables.isEmpty((Iterable)Iterables.filter(packageSegments, it -> Character.isUpperCase(it.charAt(0))))) {
                throw new IllegalArgumentException("Cannot determine the package name of '" + qualifiedName + "'. Please use the TypeReference(packageName, className) constructor");
            }
            return Joiner.on((String)".").join(packageSegments);
        }
        List packageSegments = segments.subList(0, segments.size() - 1);
        while (!packageSegments.isEmpty()) {
            if (Character.isUpperCase(((String)IterableExtensions.last(packageSegments)).charAt(0))) {
                packageSegments = packageSegments.subList(0, packageSegments.size() - 1);
                continue;
            }
            return Joiner.on((String)".").join(packageSegments);
        }
        return "";
    }

    private static String getClassName(String qualifiedName, boolean strict) {
        String packageName = TypeReference.getPackageName(qualifiedName, strict);
        if (packageName.isEmpty()) {
            return qualifiedName;
        }
        return qualifiedName.substring(packageName.length() + 1, qualifiedName.length());
    }

    private static QualifiedClassName getQualifiedName(EClass clazz, ResourceSet resourceSet) {
        if ("http://www.eclipse.org/2008/Xtext".equals(clazz.getEPackage().getNsURI())) {
            return new QualifiedClassName("org.eclipse.xtext", clazz.getName());
        }
        if ("http://www.eclipse.org/emf/2002/Ecore".equals(clazz.getEPackage().getNsURI())) {
            if (clazz.getInstanceTypeName() != null) {
                String itn = clazz.getInstanceTypeName();
                return new QualifiedClassName(itn.substring(0, itn.lastIndexOf(".")), itn.substring(itn.lastIndexOf(".") + 1).replace("$", "."));
            }
            return new QualifiedClassName("org.eclipse.emf.ecore", clazz.getName());
        }
        if (clazz.getInstanceTypeName() != null) {
            String itn = clazz.getInstanceTypeName();
            return new QualifiedClassName(itn.substring(0, itn.lastIndexOf(".")), itn.substring(itn.lastIndexOf(".") + 1).replace("$", "."));
        }
        GenClass genClass = GenModelUtil2.getGenClass(clazz, resourceSet);
        String packageName = genClass.getGenPackage().getInterfacePackageName();
        return new QualifiedClassName(packageName, genClass.getInterfaceName());
    }

    private static QualifiedClassName getQualifiedName(EPackage epackage, ResourceSet resourceSet) {
        GenPackage genPackage = GenModelUtil2.getGenPackage(epackage, resourceSet);
        String packageName = null;
        packageName = genPackage.getGenModel().isSuppressEMFMetaData() ? genPackage.getQualifiedPackageClassName() : genPackage.getReflectionPackageName();
        return new QualifiedClassName(packageName, genPackage.getPackageInterfaceName());
    }

    public String toString() {
        return String.valueOf(this.getName()) + IterableExtensions.join(this.typeArguments, (CharSequence)"<", (CharSequence)", ", (CharSequence)">", TypeReference::toString);
    }

    public String getName() {
        return String.valueOf(this.packageName) + "." + Joiner.on((String)".").join(this.simpleNames);
    }

    public String getSimpleName() {
        return (String)IterableExtensions.last(this.simpleNames);
    }

    public String getPath() {
        return String.valueOf(this.packageName.replace(".", "/")) + "/" + (String)Iterables.getFirst(this.simpleNames, null);
    }

    public String getJavaPath() {
        return String.valueOf(this.getPath()) + ".java";
    }

    public String getXtendPath() {
        return String.valueOf(this.getPath()) + ".xtend";
    }

    public String getPackageName() {
        return this.packageName;
    }

    public List<String> getSimpleNames() {
        return this.simpleNames;
    }

    public List<TypeReference> getTypeArguments() {
        return this.typeArguments;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.packageName == null ? 0 : this.packageName.hashCode());
        result = 31 * result + (this.simpleNames == null ? 0 : this.simpleNames.hashCode());
        result = 31 * result + (this.typeArguments == null ? 0 : this.typeArguments.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeReference other = (TypeReference)obj;
        if (this.packageName == null ? other.packageName != null : !this.packageName.equals(other.packageName)) {
            return false;
        }
        if (this.simpleNames == null ? other.simpleNames != null : !this.simpleNames.equals(other.simpleNames)) {
            return false;
        }
        return !(this.typeArguments == null ? other.typeArguments != null : !this.typeArguments.equals(other.typeArguments));
    }

    public static class QualifiedClassName {
        private final String packageName;
        private final String className;

        public String getPackageName() {
            return this.packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public QualifiedClassName(String packageName, String className) {
            this.packageName = packageName;
            this.className = className;
        }
    }
}

