/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.renderers.swt.StackRenderer;
import org.eclipse.jface.viewers.BoldStylerProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.dialogs.StyledStringHighlighter;
import org.eclipse.ui.internal.EditorReference;
import org.eclipse.ui.internal.FilteredTableBaseHandler;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.themes.ITheme;

public class WorkbookEditorsHandler
extends FilteredTableBaseHandler {
    private static final String ORG_ECLIPSE_E4_UI_WORKBENCH_RENDERERS_SWT = "org.eclipse.e4.ui.workbench.renderers.swt";
    private static final String ORG_ECLIPSE_UI_WINDOW_OPEN_EDITOR_DROP_DOWN = "org.eclipse.ui.window.openEditorDropDown";
    private static final String TAG_ACTIVE = "active";
    private static final String DIRTY_PREFIX = "*";
    private static final String OMMITED_PATH_SEGMENTS_SIGNIFIER = "...";
    private SearchPattern searchPattern;
    private Map<EditorReference, String> editorReferenceColumnLabelTexts;

    private static boolean isMruEnabled() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode(ORG_ECLIPSE_E4_UI_WORKBENCH_RENDERERS_SWT);
        boolean initialMRUValue = preferences.getBoolean("enableMRUDefault", true);
        return preferences.getBoolean("enableMRU", initialMRUValue);
    }

    @Override
    protected Object getInput(WorkbenchPage page) {
        List<EditorReference> editorReferences = this.getParts(page);
        this.editorReferenceColumnLabelTexts = this.generateColumnLabelTexts(editorReferences);
        return editorReferences;
    }

    private List<EditorReference> getParts(WorkbenchPage page) {
        List<EditorReference> refs;
        if (WorkbookEditorsHandler.isMruEnabled()) {
            refs = page.getSortedEditorReferences();
        } else {
            refs = new ArrayList<EditorReference>();
            IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ier = iEditorReferenceArray[n2];
                refs.add((EditorReference)ier);
                ++n2;
            }
        }
        return refs;
    }

    /*
     * WARNING - void declaration
     */
    private Map<EditorReference, String> generateColumnLabelTexts(List<EditorReference> editorReferences) {
        HashMap<EditorReference, String> editorReferenceLabelTexts = new HashMap<EditorReference, String>(editorReferences.size());
        Map<String, List<EditorReference>> collisionsMap = editorReferences.stream().collect(Collectors.groupingBy(r -> r.getName()));
        for (Map.Entry<String, List<EditorReference>> groupedEditorReferences : collisionsMap.entrySet()) {
            void var8_12;
            IPath path;
            if (groupedEditorReferences.getValue().size() == 1) {
                groupedEditorReferences.getValue().stream().forEach(editorReference -> {
                    String string = editorReferenceLabelTexts.put((EditorReference)editorReference, this.getWorkbenchPartReferenceText((WorkbenchPartReference)editorReference));
                });
                continue;
            }
            ArrayList<Map.Entry<EditorReference, IPath>> refsToMakeDistinguishableViaPathSegments = new ArrayList<Map.Entry<EditorReference, IPath>>();
            for (EditorReference editorReference2 : groupedEditorReferences.getValue()) {
                try {
                    IPathEditorInput iPathEditorInput = (IPathEditorInput)Adapters.adapt((Object)editorReference2.getEditorInput(), IPathEditorInput.class);
                    if (iPathEditorInput != null && (path = iPathEditorInput.getPath()) != null && groupedEditorReferences.getKey().equals(path.lastSegment())) {
                        refsToMakeDistinguishableViaPathSegments.add(Map.entry(editorReference2, path));
                        continue;
                    }
                    editorReferenceLabelTexts.put(editorReference2, this.getWorkbenchPartReferenceText(editorReference2));
                }
                catch (PartInitException e2) {
                    String message = "Expected parts to be initialized";
                    Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, message, (Throwable)((Object)e2));
                    WorkbenchPlugin.log(message, (IStatus)status);
                }
            }
            if (refsToMakeDistinguishableViaPathSegments.isEmpty()) continue;
            if (this.allReferencesToSamePath(refsToMakeDistinguishableViaPathSegments)) {
                refsToMakeDistinguishableViaPathSegments.stream().forEach(e -> {
                    String string = editorReferenceLabelTexts.put((EditorReference)e.getKey(), this.getWorkbenchPartReferenceText((WorkbenchPartReference)e.getKey()));
                });
                continue;
            }
            ArrayList<Integer> maxMatchingSegmentsList = new ArrayList<Integer>(refsToMakeDistinguishableViaPathSegments.size());
            for (Map.Entry entry : refsToMakeDistinguishableViaPathSegments) {
                path = (IPath)entry.getValue();
                int maxMatchingSegments = -1;
                int i = 0;
                while (i < refsToMakeDistinguishableViaPathSegments.size()) {
                    IPath currentPath = (IPath)((Map.Entry)refsToMakeDistinguishableViaPathSegments.get(i)).getValue();
                    if (!currentPath.equals((Object)path)) {
                        int currentMatchingSegments = this.matchingLastSegments(path, currentPath);
                        maxMatchingSegments = maxMatchingSegments < currentMatchingSegments ? currentMatchingSegments : maxMatchingSegments;
                    }
                    ++i;
                }
                maxMatchingSegmentsList.add(maxMatchingSegments);
            }
            boolean bl = false;
            while (var8_12 < maxMatchingSegmentsList.size()) {
                EditorReference editorReference3 = (EditorReference)((Map.Entry)refsToMakeDistinguishableViaPathSegments.get((int)var8_12)).getKey();
                Integer maxMatchingSegment = (Integer)maxMatchingSegmentsList.get((int)var8_12);
                IPath path2 = (IPath)((Map.Entry)refsToMakeDistinguishableViaPathSegments.get((int)var8_12)).getValue();
                String labelText = this.generateLabelText(editorReference3, path2, maxMatchingSegment);
                editorReferenceLabelTexts.put(editorReference3, labelText);
                ++var8_12;
            }
        }
        return editorReferenceLabelTexts;
    }

    private boolean allReferencesToSamePath(List<Map.Entry<EditorReference, IPath>> groupedEditorReferences) {
        return groupedEditorReferences.stream().map(Map.Entry::getValue).allMatch(arg_0 -> ((IPath)groupedEditorReferences.get(0).getValue()).equals(arg_0));
    }

    private String generateLabelText(EditorReference editorReference, IPath path, Integer maxMatchingSegment) {
        Path npath = path.toFile().toPath();
        String lastSegment = npath.getFileName().toString();
        StringBuilder prependedSegment = new StringBuilder();
        if (maxMatchingSegment < npath.getNameCount()) {
            prependedSegment = prependedSegment.append(this.getPathSegment(maxMatchingSegment, npath).toString());
            if (maxMatchingSegment > 1) {
                prependedSegment = prependedSegment.append(File.separator).append(OMMITED_PATH_SEGMENTS_SIGNIFIER);
            }
            prependedSegment = prependedSegment.append(File.separator);
        } else {
            prependedSegment = prependedSegment.append(npath.getRoot());
        }
        String labelText = prependedSegment.append(lastSegment).toString();
        return this.prependDirtyIndicationIfDirty(editorReference, labelText);
    }

    private Path getPathSegment(Integer segmentIndex, Path path) {
        return path.subpath(path.getNameCount() - 1 - segmentIndex, path.getNameCount() - segmentIndex);
    }

    private String prependDirtyIndicationIfDirty(EditorReference editorReference, String labelText) {
        if (editorReference.isDirty()) {
            return DIRTY_PREFIX + labelText;
        }
        return labelText;
    }

    private int matchingLastSegments(IPath path, IPath anotherPath) {
        int thisPathLen = path.segmentCount();
        int anotherPathLen = anotherPath.segmentCount();
        int max = Math.min(thisPathLen, anotherPathLen);
        int count = 0;
        int i = 1;
        while (i <= max) {
            if (!path.segment(thisPathLen - i).equals(anotherPath.segment(anotherPathLen - i))) {
                return count;
            }
            ++count;
            ++i;
        }
        return count;
    }

    @Override
    protected boolean isFiltered() {
        return true;
    }

    SearchPattern getMatcher() {
        return this.searchPattern;
    }

    @Override
    protected void setMatcherString(String pattern) {
        if (pattern.isEmpty()) {
            this.searchPattern = null;
        } else {
            this.searchPattern = new SearchPattern();
            this.searchPattern.setPattern(pattern);
        }
    }

    @Override
    protected void setLabelProvider(TableViewerColumn tableViewerColumn) {
        tableViewerColumn.setLabelProvider((CellLabelProvider)new StyledCellLabelProvider(){
            private BoldStylerProvider boldStylerProvider;

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                if (element instanceof WorkbenchPartReference) {
                    WorkbenchPartReference ref = (WorkbenchPartReference)element;
                    String text = WorkbookEditorsHandler.this.editorReferenceColumnLabelTexts.get(ref);
                    cell.setText(text);
                    cell.setImage(ref.getTitleImage());
                    SearchPattern matcher = WorkbookEditorsHandler.this.getMatcher();
                    if (matcher == null) {
                        cell.setStyleRanges(null);
                    } else {
                        String pattern = matcher.getPattern();
                        StyledStringHighlighter ssh = new StyledStringHighlighter();
                        StyledString ss = ssh.highlight(text, pattern, this.getBoldStylerProvider().getBoldStyler());
                        cell.setStyleRanges(ss.getStyleRanges());
                    }
                    cell.getControl().redraw();
                }
            }

            public String getToolTipText(Object element) {
                if (element instanceof WorkbenchPartReference) {
                    WorkbenchPartReference ref = (WorkbenchPartReference)element;
                    return ref.getTitleToolTip();
                }
                return super.getToolTipText(element);
            }

            private BoldStylerProvider getBoldStylerProvider() {
                if (this.boldStylerProvider == null) {
                    this.boldStylerProvider = new BoldStylerProvider(WorkbookEditorsHandler.this.getFont(false, true));
                }
                return this.boldStylerProvider;
            }

            public void dispose() {
                super.dispose();
                if (this.boldStylerProvider != null) {
                    this.boldStylerProvider.dispose();
                    this.boldStylerProvider = null;
                }
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewerColumn.getViewer());
    }

    protected boolean isActiveEditor(MPart model) {
        if (model == null || model.getTags() == null) {
            return false;
        }
        return model.getTags().contains(TAG_ACTIVE);
    }

    protected boolean isHiddenEditor(MPart model) {
        if (model == null || model.getParent() == null || !(model.getParent().getRenderer() instanceof StackRenderer)) {
            return false;
        }
        StackRenderer renderer = (StackRenderer)model.getParent().getRenderer();
        CTabItem item = renderer.findItemForPart(model);
        return item != null && !item.isShowing();
    }

    private Font getFont(boolean hidden, boolean active) {
        ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        if (active) {
            return theme.getFontRegistry().getItalic("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        }
        if (hidden) {
            return theme.getFontRegistry().getBold("org.eclipse.ui.workbench.TAB_TEXT_FONT");
        }
        return theme.getFontRegistry().get("org.eclipse.ui.workbench.TAB_TEXT_FONT");
    }

    @Override
    protected ViewerFilter getFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                SearchPattern matcher = WorkbookEditorsHandler.this.getMatcher();
                if (matcher == null || !(viewer instanceof TableViewer)) {
                    return true;
                }
                String editorTitle = null;
                String editorLabel = null;
                if (element instanceof EditorReference) {
                    editorTitle = this.removeDirtyPrefix(((EditorReference)element).getTitle());
                    editorLabel = this.removeDirtyPrefix(WorkbookEditorsHandler.this.editorReferenceColumnLabelTexts.get(element));
                }
                return editorTitle != null && matcher.matches(editorTitle) || editorLabel != null && matcher.matches(editorLabel);
            }

            private String removeDirtyPrefix(String matchName) {
                if (matchName == null) {
                    return null;
                }
                if (matchName.startsWith(WorkbookEditorsHandler.DIRTY_PREFIX)) {
                    return matchName.substring(1);
                }
                return matchName;
            }
        };
    }

    @Override
    protected ParameterizedCommand getBackwardCommand() {
        return null;
    }

    @Override
    protected ParameterizedCommand getForwardCommand() {
        ICommandService commandService = (ICommandService)this.window.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(ORG_ECLIPSE_UI_WINDOW_OPEN_EDITOR_DROP_DOWN);
        return new ParameterizedCommand(command, null);
    }

    @Override
    protected int getCurrentItemIndex() {
        if (WorkbookEditorsHandler.isMruEnabled()) {
            return 0;
        }
        WorkbenchPage page = (WorkbenchPage)this.window.getActivePage();
        List<EditorReference> sortedByUse = page.getSortedEditorReferences();
        if (sortedByUse.size() < 2) {
            return 0;
        }
        EditorReference next = sortedByUse.get(1);
        List<EditorReference> sortedByPosition = this.getParts(page);
        int i = 0;
        while (i < sortedByPosition.size()) {
            EditorReference ref = sortedByPosition.get(i);
            if (ref == next) {
                if (i > 0) {
                    this.gotoDirection = true;
                    return i - 1;
                }
                this.gotoDirection = false;
                return 1;
            }
            ++i;
        }
        return super.getCurrentItemIndex();
    }
}

