/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.ui.providers.support;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BorderLayout
extends Layout {
    public static final int NWFIELD = 0;
    public static final int NFIELD = 1;
    public static final int NEFIELD = 2;
    public static final int WFIELD = 3;
    public static final int MFIELD = 4;
    public static final int EFIELD = 5;
    public static final int SWFIELD = 6;
    public static final int SFIELD = 7;
    public static final int SEFIELD = 8;
    Point[] points;
    Control[] controls;
    int width;
    int height;

    private void getControlsAndPoints(Control[] children, boolean flushCache) {
        this.controls = new Control[9];
        this.points = new Point[9];
        Control[] controlArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            BorderData borderData;
            Control element = controlArray[n2];
            Object layoutData = element.getLayoutData();
            if (layoutData instanceof BorderData && ((borderData = (BorderData)layoutData) != null || borderData.field < 0 || borderData.field > 8)) {
                this.controls[borderData.field] = element;
                this.points[borderData.field] = element.computeSize(-1, -1, flushCache);
            }
            ++n2;
        }
        int i = 0;
        while (i < this.controls.length) {
            Control control = this.controls[i];
            if (control == null) {
                this.points[i] = new Point(0, 0);
            }
            ++i;
        }
    }

    private int max(int i1, int i2, int i3) {
        int j = i1 >= i2 ? i1 : i2;
        return j >= i3 ? j : i3;
    }

    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        if (flushCache || this.points == null) {
            this.getControlsAndPoints(composite.getChildren(), flushCache);
        }
        this.width = this.max(this.points[0].x + this.points[1].x + this.points[2].x, this.points[3].x + this.points[4].x + this.points[5].x, this.points[6].x + this.points[7].x + this.points[8].x);
        this.height = this.max(this.points[0].y + this.points[1].y + this.points[2].y, this.points[3].y + this.points[4].y + this.points[5].y, this.points[6].y + this.points[7].y + this.points[8].y);
        return new Point(wHint == -1 ? this.width : wHint, hHint == -1 ? this.height : hHint);
    }

    protected void layout(Composite composite, boolean flushCache) {
        if (flushCache || this.points == null) {
            this.getControlsAndPoints(composite.getChildren(), flushCache);
        }
        Rectangle clientArea = composite.getClientArea();
        if (this.controls[0] != null) {
            this.controls[0].setBounds(clientArea.x, clientArea.y, this.points[3].x, this.points[1].y);
        }
        if (this.controls[1] != null) {
            this.controls[1].setBounds(clientArea.x + this.points[3].x, clientArea.y, clientArea.width - this.points[3].x - this.points[5].x, this.points[1].y);
        }
        if (this.controls[2] != null) {
            this.controls[2].setBounds(clientArea.x + clientArea.width - this.points[5].x, clientArea.y, this.points[5].x, this.points[1].y);
        }
        if (this.controls[3] != null) {
            this.controls[3].setBounds(clientArea.x, clientArea.y + this.points[1].y, this.points[3].x, clientArea.height - this.points[1].y - this.points[7].y);
        }
        if (this.controls[4] != null) {
            this.controls[4].setBounds(clientArea.x + this.points[3].x, clientArea.y + this.points[1].y, clientArea.width - this.points[3].x - this.points[5].x, clientArea.height - this.points[1].y - this.points[7].y);
        }
        if (this.controls[5] != null) {
            this.controls[5].setBounds(clientArea.x + clientArea.width - this.points[5].x, clientArea.y + this.points[1].y, this.points[5].x, clientArea.height - this.points[1].y - this.points[7].y);
        }
        if (this.controls[6] != null) {
            this.controls[6].setBounds(clientArea.x, clientArea.y + clientArea.height - this.points[1].y, this.points[3].x, this.points[7].y);
        }
        if (this.controls[7] != null) {
            this.controls[7].setBounds(clientArea.x + this.points[3].x, clientArea.y + clientArea.height - this.points[7].y, clientArea.width - this.points[3].x - this.points[5].x, this.points[7].y);
        }
        if (this.controls[8] != null) {
            this.controls[8].setBounds(clientArea.x + clientArea.width - this.points[5].x, clientArea.y + clientArea.height - this.points[7].y, this.points[5].x, this.points[7].y);
        }
    }

    public static class BorderData {
        public int field;

        public BorderData() {
            this.field = 4;
        }

        public BorderData(int field) {
            this.field = field;
        }
    }
}

