/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ReferenceKind implements Enumerator
{
    ANY(0, "any", "any"),
    CONTAINMENT(1, "containment", "containment"),
    CROSS(2, "cross", "cross");

    public static final int ANY_VALUE = 0;
    public static final int CONTAINMENT_VALUE = 1;
    public static final int CROSS_VALUE = 2;
    private static final ReferenceKind[] VALUES_ARRAY;
    public static final List<ReferenceKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ReferenceKind[]{ANY, CONTAINMENT, CROSS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ReferenceKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReferenceKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReferenceKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ReferenceKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ReferenceKind get(int value) {
        switch (value) {
            case 0: {
                return ANY;
            }
            case 1: {
                return CONTAINMENT;
            }
            case 2: {
                return CROSS;
            }
        }
        return null;
    }

    private ReferenceKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

