/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.gist;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.mylyn.internal.github.ui.gist.Messages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class GistConnectorSelectionDialog
extends SelectionDialog {
    private final Collection<TaskRepository> repos;

    public GistConnectorSelectionDialog(Shell parentShell, Collection<TaskRepository> repositories) {
        super(parentShell);
        this.setTitle(Messages.GistConnectorSelectionDialog_Title);
        this.setMessage(Messages.GistConnectorSelectionDialog_Message);
        this.repos = repositories;
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.createMessageArea(c);
        TableViewer viewer = new TableViewer(c, 66308);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(viewer.getControl());
        viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setComparator(new ViewerComparator());
        viewer.setInput(this.repos);
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                GistConnectorSelectionDialog.this.setResult(Collections.singletonList(selected));
                GistConnectorSelectionDialog.this.okPressed();
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                GistConnectorSelectionDialog.this.setResult(Collections.singletonList(selected));
            }
        });
        return c;
    }
}

