/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.sdk.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.commons.sdk.util.AbstractTestFixture;

public abstract class RepositoryTestFixture
extends AbstractTestFixture {
    private TestSuite suite;

    public RepositoryTestFixture(String connectorKind, String repositoryUrl) {
        super(connectorKind, repositoryUrl);
        this.useCertificateAuthentication = repositoryUrl.contains("/secure/");
    }

    public void add(Class<? extends TestCase> clazz) {
        Assert.isNotNull((Object)this.suite, (String)"Invoke createSuite() first");
        this.suite.addTestSuite(clazz);
    }

    public TestSuite createSuite(TestSuite parentSuite) {
        this.suite = new TestSuite("Testing on " + this.getInfo());
        parentSuite.addTest((Test)this.suite);
        this.suite.addTest((Test)new Activation("repository: " + this.getRepositoryUrl() + " [@" + this.getSimpleInfo() + "]", true));
        return this.suite;
    }

    public void done() {
        Assert.isNotNull((Object)this.suite, (String)"Invoke createSuite() first");
        this.suite.addTest((Test)new Activation("done", false));
        this.suite = null;
    }

    protected abstract RepositoryTestFixture activate();

    private final class Activation
    extends TestCase {
        private final boolean activate;

        private Activation(String name, boolean activate) {
            super(name);
            this.activate = activate;
        }

        protected void runTest() throws Throwable {
            if (this.activate) {
                RepositoryTestFixture.this.activate();
            } else {
                ((RepositoryTestFixture)RepositoryTestFixture.this.getDefault()).activate();
            }
        }
    }
}

