/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm.protocol;

import org.eclipse.m2m.qvt.oml.debug.core.vm.VMLocation;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMStackFrame;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMEvent;

public class VMSuspendEvent
extends VMEvent {
    private static final long serialVersionUID = -2117406291312177660L;
    public static final int BREAKPOINT_CONDITION_ERR = 42;
    public VMLocation location;
    public VMStackFrame[] stackFrames;
    public Long breakpointID;
    public int detail;
    public String reason;
    public String reasonDetail;

    public VMSuspendEvent(VMStackFrame[] stack, int detail) {
        if (stack == null || stack.length == 0) {
            throw new IllegalArgumentException("empty stack");
        }
        this.stackFrames = stack;
        this.location = stack[0].getLocation();
        this.detail = detail;
    }

    public Long getBreakpointID() {
        return this.breakpointID;
    }

    public void setBreakpointID(Long breakpointID) {
        this.breakpointID = breakpointID;
    }

    public void setReason(String reason, String reasonDetail) {
        if (reason == null && reasonDetail != null) {
            throw new IllegalArgumentException();
        }
        this.reason = reason;
        this.reasonDetail = reasonDetail;
    }

    public String getReason() {
        return this.reason;
    }

    public String getReasonDetail() {
        return this.reasonDetail;
    }

    public void setReasonDetail(String reasonDetail) {
        this.reasonDetail = reasonDetail;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append(" detail:").append(this.detail);
        if (this.breakpointID != null) {
            buf.append(" breakpointID:").append(this.breakpointID);
        }
        if (this.reason != null) {
            buf.append(" reason:").append(this.reason.substring(0, Math.min(50, this.reason.length())));
        }
        return buf.toString();
    }
}

