/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.link;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jst.jsf.common.ui.internal.dialogs.CommonWizardDialog;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.actions.link.CreateLinkWizard;
import org.eclipse.jst.pagedesigner.actions.link.ExtensionReader;
import org.eclipse.jst.pagedesigner.actions.link.ILinkCreator;
import org.eclipse.jst.pagedesigner.actions.link.LinkRequest;
import org.eclipse.jst.pagedesigner.parts.TextEditPart;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MakeLinkAction
extends Action {
    private static final String MAKE_LINK = PDPlugin.getResourceString("ActionGroup.Submenu.Link");
    private static final String WIZARD_PAGE_TITLE = PDPlugin.getResourceString("MakeLinkAction.Wizard.PageTitle");
    private EditPart _editPart;
    private DesignRange _range;
    private String _linkType;

    public MakeLinkAction(DesignRange range) {
        super(MAKE_LINK);
        this._range = range;
        this._editPart = this.convertToEditPart(this._range);
    }

    public void run() {
        LinkRequest request;
        Command cmd;
        Map<String, ILinkCreator> map = this.calAvailableLinkCreator();
        if (map.size() > 1) {
            CreateLinkWizard wizard = new CreateLinkWizard(this._editPart, this._range, map);
            wizard.setPageTitle(WIZARD_PAGE_TITLE);
            CommonWizardDialog wizardDialog = new CommonWizardDialog(this.getShell(), (IWizard)wizard);
            wizardDialog.create();
            if (wizardDialog.open() == 0) {
                this._linkType = wizard.getChosenLinkType();
            }
        } else if (map.size() == 1) {
            Set<Map.Entry<String, ILinkCreator>> set = map.entrySet();
            Iterator<Map.Entry<String, ILinkCreator>> itr = set.iterator();
            while (itr.hasNext()) {
                ILinkCreator creator = itr.next().getValue();
                this._linkType = creator.getLinkIdentifier();
            }
        }
        if (this._linkType != null && (cmd = this._editPart.getCommand((Request)(request = new LinkRequest(this._linkType, this._range)))) != null && cmd.canExecute()) {
            cmd.execute();
        }
    }

    public boolean isEnabled() {
        if (this._editPart == null) {
            return false;
        }
        return super.isEnabled();
    }

    private EditPart convertToEditPart(DesignRange range) {
        DesignPosition startPosition = range.getStartPosition();
        EditPart startPart = startPosition.getContainerPart();
        DesignPosition endPosition = range.getEndPosition();
        EditPart endPart = endPosition.getContainerPart();
        if (startPosition == endPosition) {
            return null;
        }
        if (startPart instanceof TextEditPart && endPart instanceof TextEditPart) {
            if (startPart == endPart) {
                return startPart;
            }
        } else if (!(startPart instanceof TextEditPart) && !(endPart instanceof TextEditPart)) {
            Node[] startNodeOptions = null;
            startNodeOptions = this.getSideNodes(startPosition);
            Node[] endNodeOptions = null;
            endNodeOptions = this.getSideNodes(endPosition);
            Node selectedNode = null;
            int i = 0;
            while (i < 2) {
                int j = 0;
                while (j < 2) {
                    if (startNodeOptions[i] == endNodeOptions[j]) {
                        selectedNode = startNodeOptions[i];
                        break;
                    }
                    ++j;
                }
                if (selectedNode != null) break;
                ++i;
            }
            if (selectedNode != null) {
                EditPart part = (EditPart)((INodeNotifier)selectedNode).getAdapterFor(EditPart.class);
                return part;
            }
        } else {
            if (startPart instanceof TextEditPart) {
                Node[] endNodeOptions = null;
                endNodeOptions = this.getSideNodes(endPosition);
                if (startPart.getModel() == endNodeOptions[0] || startPart.getModel() == endNodeOptions[1]) {
                    return startPart;
                }
            }
            if (endPart instanceof TextEditPart) {
                Node[] startNodeOptions = null;
                startNodeOptions = this.getSideNodes(startPosition);
                if (endPart.getModel() == startNodeOptions[0] || endPart.getModel() == startNodeOptions[1]) {
                    return endPart;
                }
            }
        }
        return null;
    }

    private Node[] getSideNodes(DesignPosition pos) {
        Node[] nodes = new Node[2];
        EditPart part = pos.getContainerPart();
        Node node = (Node)part.getModel();
        NodeList list = node.getChildNodes();
        if (list.getLength() == pos.getOffset()) {
            nodes[0] = list.item(pos.getOffset() - 1);
            nodes[1] = list.item(pos.getOffset() - 1);
        } else if (pos.getOffset() == 0) {
            nodes[0] = list.item(0);
            nodes[1] = list.item(0);
        } else if (pos.getOffset() > 0 && pos.getOffset() < list.getLength()) {
            nodes[0] = list.item(pos.getOffset() - 1);
            nodes[1] = list.item(pos.getOffset());
        }
        return nodes;
    }

    private Shell getShell() {
        if (this._editPart != null) {
            IHTMLGraphicalViewer viewer = (IHTMLGraphicalViewer)this._editPart.getViewer();
            return viewer.getControl().getShell();
        }
        return null;
    }

    private Map<String, ILinkCreator> calAvailableLinkCreator() {
        HashMap<String, ILinkCreator> map = new HashMap<String, ILinkCreator>();
        List<ILinkCreator> linkCreators = ExtensionReader.getAllLinkHandlers();
        for (ILinkCreator linkCreator : linkCreators) {
            String identifier = linkCreator.getLinkIdentifier();
            boolean canExecute = linkCreator.canExecute(this._range);
            if (!canExecute) continue;
            map.put(identifier, linkCreator);
        }
        return map;
    }
}

