/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.behaviors;

import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.eclipse.gef.mvc.fx.behaviors.AbstractBehavior;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class RevealPrimarySelectionBehavior
extends AbstractBehavior {
    private SelectionModel selectionModel;
    private IContentPart<? extends Node> previousPrimarySelection = null;
    private ListChangeListener<IContentPart<? extends Node>> selectionObserver = new ListChangeListener<IContentPart<? extends Node>>(){

        public void onChanged(ListChangeListener.Change<? extends IContentPart<? extends Node>> c) {
            IContentPart currentPrimarySelection = null;
            if (c.getList().size() > 0) {
                currentPrimarySelection = (IContentPart)c.getList().get(0);
            }
            if (currentPrimarySelection != RevealPrimarySelectionBehavior.this.previousPrimarySelection) {
                RevealPrimarySelectionBehavior.this.onPrimarySelectionChanged(RevealPrimarySelectionBehavior.this.previousPrimarySelection, currentPrimarySelection);
                RevealPrimarySelectionBehavior.this.previousPrimarySelection = currentPrimarySelection;
            }
        }
    };

    @Override
    protected void doActivate() {
        super.doActivate();
        IViewer viewer = this.getHost().getRoot().getViewer();
        this.selectionModel = (SelectionModel)((Object)viewer.getAdapter(SelectionModel.class));
        this.selectionModel.selectionUnmodifiableProperty().addListener(this.selectionObserver);
        this.previousPrimarySelection = null;
        ObservableList<IContentPart<? extends Node>> selection = this.selectionModel.getSelectionUnmodifiable();
        if (selection.size() > 0) {
            this.previousPrimarySelection = (IContentPart)selection.get(0);
            this.onPrimarySelectionChanged(null, this.previousPrimarySelection);
        }
    }

    @Override
    protected void doDeactivate() {
        this.selectionModel.selectionUnmodifiableProperty().removeListener(this.selectionObserver);
        super.doDeactivate();
    }

    protected void onPrimarySelectionChanged(IContentPart<? extends Node> previousPrimarySelection, IContentPart<? extends Node> currentPrimarySelection) {
        if (currentPrimarySelection != null) {
            this.getHost().getRoot().getViewer().reveal(currentPrimarySelection);
        }
    }
}

