/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.object;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.eresource.impl.CDOResourceImpl;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.spi.cdo.FSMUtil;
import org.eclipse.emf.spi.cdo.InternalCDOView;

public abstract class CDOObjectWrapperBase
implements CDOObject,
InternalEObject {
    private static final Method E_SET_DIRECT_RESOURCE = CDOObjectWrapperBase.getMethod("eSetDirectResource", Resource.Internal.class);
    private static final Method E_BASIC_SET_CONTAINER = CDOObjectWrapperBase.getMethod("eBasicSetContainer", InternalEObject.class, Integer.TYPE);
    protected InternalEObject instance;

    @Override
    public CDOResourceImpl cdoResource() {
        Resource resource = this.eResource();
        if (resource instanceof CDOResourceImpl) {
            return (CDOResourceImpl)resource;
        }
        return null;
    }

    @Override
    public CDOResourceImpl cdoDirectResource() {
        Resource.Internal resource = this.eDirectResource();
        if (resource instanceof CDOResourceImpl) {
            return (CDOResourceImpl)resource;
        }
        return null;
    }

    public InternalEObject cdoInternalInstance() {
        return this.instance;
    }

    @Override
    public boolean cdoConflict() {
        return FSMUtil.isConflict(this);
    }

    @Override
    public boolean cdoInvalid() {
        return FSMUtil.isInvalid(this);
    }

    @Override
    public void cdoPrefetch(int depth) {
        InternalCDOView view = (InternalCDOView)this.cdoView();
        view.prefetchRevisions(this.cdoID(), depth);
    }

    public EStructuralFeature cdoInternalDynamicFeature(int dynamicFeatureID) {
        return this.eDynamicFeature(dynamicFeatureID);
    }

    protected EStructuralFeature eDynamicFeature(int dynamicFeatureID) {
        EClass eClass = this.eClass();
        return eClass.getEStructuralFeature(dynamicFeatureID + this.eStaticFeatureCount());
    }

    protected int eStaticFeatureCount() {
        return this.eStaticClass().getFeatureCount();
    }

    protected final EClass eStaticClass() {
        return EcorePackage.eINSTANCE.getEObject();
    }

    public Resource.Internal getInstanceResource(InternalEObject instance) {
        return instance.eDirectResource();
    }

    public InternalEObject getInstanceContainer(InternalEObject instance) {
        return instance.eInternalContainer();
    }

    public int getInstanceContainerFeatureID(InternalEObject instance) {
        return instance.eContainerFeatureID();
    }

    public Object getInstanceValue(InternalEObject instance, EStructuralFeature feature) {
        return instance.eGet(feature);
    }

    public boolean isSetInstanceValue(InternalEObject instance, EStructuralFeature feature) {
        if (feature == EMFUtil.ETYPED_ELEMENT_EGENERIC_TYPE || feature == EMFUtil.ECLASSIFIER_INSTANCE_TYPE_NAME) {
            return this.getInstanceValue(instance, feature) != null;
        }
        if (feature == EMFUtil.ECLASS_EGENERIC_SUPER_TYPES || feature == EMFUtil.EOPERATION_EGENERIC_EXCEPTIONS) {
            return !((List)this.getInstanceValue(instance, feature)).isEmpty();
        }
        return instance.eIsSet(feature);
    }

    public void setInstanceResource(Resource.Internal resource) {
        try {
            E_SET_DIRECT_RESOURCE.invoke((Object)this.instance, resource);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public void setInstanceContainer(InternalEObject container, int containerFeatureID) {
        try {
            E_BASIC_SET_CONTAINER.invoke((Object)this.instance, container, containerFeatureID);
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
    }

    public void setInstanceValue(InternalEObject instance, EStructuralFeature feature, Object value) {
        instance.eSet(feature, value);
    }

    public EList<Adapter> eAdapters() {
        return this.instance.eAdapters();
    }

    public TreeIterator<EObject> eAllContents() {
        return this.instance.eAllContents();
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        return this.instance.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain notifications) {
        return this.instance.eBasicRemoveFromContainer(notifications);
    }

    public NotificationChain eBasicSetContainer(InternalEObject newContainer, int newContainerFeatureID, NotificationChain notifications) {
        return this.instance.eBasicSetContainer(newContainer, newContainerFeatureID, notifications);
    }

    public EClass eClass() {
        return this.instance.eClass();
    }

    public EObject eContainer() {
        return this.instance.eContainer();
    }

    public int eContainerFeatureID() {
        return this.instance.eContainerFeatureID();
    }

    public EStructuralFeature eContainingFeature() {
        return this.instance.eContainingFeature();
    }

    public EReference eContainmentFeature() {
        return this.instance.eContainmentFeature();
    }

    public EList<EObject> eContents() {
        return this.instance.eContents();
    }

    public EList<EObject> eCrossReferences() {
        return this.instance.eCrossReferences();
    }

    public boolean eDeliver() {
        return this.instance.eDeliver();
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        return this.instance.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public Resource.Internal eDirectResource() {
        return this.instance.eDirectResource();
    }

    public Object eGet(EStructuralFeature feature, boolean resolve, boolean coreType) {
        return this.instance.eGet(feature, resolve, coreType);
    }

    public Object eGet(EStructuralFeature feature, boolean resolve) {
        return this.instance.eGet(feature, resolve);
    }

    public Object eGet(EStructuralFeature feature) {
        return this.instance.eGet(feature);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        return this.instance.eGet(featureID, resolve, coreType);
    }

    public int eDerivedOperationID(int baseOperationID, Class<?> baseClass) {
        return this.instance.eDerivedOperationID(baseOperationID, baseClass);
    }

    public Object eInvoke(EOperation operation, EList<?> arguments) throws InvocationTargetException {
        return this.instance.eInvoke(operation, arguments);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        return this.instance.eInvoke(operationID, arguments);
    }

    public InternalEObject eInternalContainer() {
        return this.instance.eInternalContainer();
    }

    public Resource.Internal eInternalResource() {
        CDOView view = this.cdoView();
        if (view != null && view.isClosed()) {
            return null;
        }
        return this.instance.eInternalResource();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain notifications) {
        return this.instance.eInverseAdd(otherEnd, featureID, baseClass, notifications);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class<?> baseClass, NotificationChain notifications) {
        return this.instance.eInverseRemove(otherEnd, featureID, baseClass, notifications);
    }

    public boolean eIsProxy() {
        return this.instance.eIsProxy();
    }

    public boolean eIsSet(EStructuralFeature feature) {
        return this.isSetInstanceValue(this.instance, feature);
    }

    public boolean eIsSet(int featureID) {
        if (featureID == 9 || featureID == 5 || featureID == 22 || featureID == 14) {
            return this.isSetInstanceValue(this.instance, this.instance.eClass().getEStructuralFeature(featureID));
        }
        return this.instance.eIsSet(featureID);
    }

    public boolean eNotificationRequired() {
        return this.instance.eNotificationRequired();
    }

    public void eNotify(Notification notification) {
        this.instance.eNotify(notification);
    }

    public EObject eObjectForURIFragmentSegment(String uriFragmentSegment) {
        return this.instance.eObjectForURIFragmentSegment(uriFragmentSegment);
    }

    public URI eProxyURI() {
        return this.instance.eProxyURI();
    }

    public EObject eResolveProxy(InternalEObject proxy) {
        return this.instance.eResolveProxy(proxy);
    }

    public Resource eResource() {
        return this.instance.eResource();
    }

    public void eSet(EStructuralFeature feature, Object newValue) {
        this.instance.eSet(feature, newValue);
    }

    public void eSet(int featureID, Object newValue) {
        this.instance.eSet(featureID, newValue);
    }

    public void eSetClass(EClass class1) {
        this.instance.eSetClass(class1);
    }

    public void eSetDeliver(boolean deliver) {
        this.instance.eSetDeliver(deliver);
    }

    public void eSetProxyURI(URI uri) {
        this.instance.eSetProxyURI(uri);
    }

    public NotificationChain eSetResource(Resource.Internal resource, NotificationChain notifications) {
        return this.instance.eSetResource(resource, notifications);
    }

    public void eSetStore(InternalEObject.EStore store) {
        this.instance.eSetStore(store);
    }

    public EStructuralFeature.Setting eSetting(EStructuralFeature feature) {
        return this.instance.eSetting(feature);
    }

    public InternalEObject.EStore eStore() {
        return this.instance.eStore();
    }

    public void eUnset(EStructuralFeature feature) {
        this.instance.eUnset(feature);
    }

    public void eUnset(int featureID) {
        this.instance.eUnset(featureID);
    }

    public String eURIFragmentSegment(EStructuralFeature feature, EObject object) {
        return this.instance.eURIFragmentSegment(feature, object);
    }

    public boolean equals(Object obj) {
        return obj == this || obj == this.instance || obj instanceof CDOObjectWrapperBase && ((CDOObjectWrapperBase)obj).instance == this.instance;
    }

    public int hashCode() {
        if (this.instance != null) {
            return this.instance.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.instance.getClass().getSimpleName() + "@" + this.cdoID() + "]";
    }

    private static Method getMethod(String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        try {
            method = BasicEObjectImpl.class.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
        }
        catch (Throwable ex) {
            method = null;
        }
        return method;
    }
}

