/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.objectdata;

import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.AccessLevel;
import org.eclipse.e4.tools.emf.ui.internal.common.objectdata.JavaObject;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.osgi.framework.FrameworkUtil;

public class JavaAttribute {
    private final JavaObject object;
    private final Field field;

    public JavaAttribute(JavaObject object, Field field) {
        this.object = object;
        this.field = field;
        this.field.setAccessible(true);
    }

    public boolean isInjected() {
        return this.field.getAnnotation(Inject.class) != null;
    }

    public boolean isStatic() {
        return (this.field.getModifiers() & 8) == 8;
    }

    public String getValue() {
        Object value = this.getFieldValue();
        if (this.field.getType().isPrimitive()) {
            return "" + value;
        }
        if (value == null) {
            return "<null>";
        }
        if (value instanceof String) {
            return value.toString();
        }
        String name = value.getClass().isAnonymousClass() ? value.getClass().getName().substring(value.getClass().getPackage().getName().length() + 1) : value.getClass().getSimpleName();
        return String.valueOf(name) + " (id = " + Integer.toHexString(System.identityHashCode(value)) + ")";
    }

    public List<JavaAttribute> getAttributes() {
        try {
            if (this.field.getType().isPrimitive()) {
                return Collections.emptyList();
            }
            return new JavaObject(this.field.get(this.object.getInstance())).getAttributes();
        }
        catch (IllegalAccessException | IllegalArgumentException | InaccessibleObjectException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public String getName() {
        return this.field.getName();
    }

    public String getType() {
        return this.field.getType().getSimpleName();
    }

    public AccessLevel getAccessLevel() {
        int m = this.field.getModifiers();
        if ((m & 1) == 1) {
            return AccessLevel.PUBLIC;
        }
        if ((m & 2) == 2) {
            return AccessLevel.PRIVATE;
        }
        if ((m & 4) == 4) {
            return AccessLevel.PROTECTED;
        }
        return AccessLevel.DEFAULT;
    }

    public String getContextKey() {
        if (this.isInjected()) {
            Named named = this.field.getAnnotation(Named.class);
            if (named != null) {
                return "@Named(" + named.value() + ")";
            }
            Preference preference = this.field.getAnnotation(Preference.class);
            if (preference != null) {
                String path = preference.nodePath();
                if (path == null || path.trim().length() == 0) {
                    path = FrameworkUtil.getBundle(this.getFieldValue().getClass()).getSymbolicName();
                }
                return "@Preference(" + preference.nodePath() + "/" + preference.value() + ")";
            }
            EventTopic topic = this.field.getAnnotation(EventTopic.class);
            if (topic != null) {
                return "@Topic(" + topic.value() + ")";
            }
            UIEventTopic uiTopic = this.field.getAnnotation(UIEventTopic.class);
            if (uiTopic != null) {
                return "@UITopic(" + uiTopic.value() + ")";
            }
            Translation translation = this.field.getAnnotation(Translation.class);
            if (translation != null) {
                return "@Translation(" + this.field.getType().getName() + ")";
            }
            return this.field.getType().getName();
        }
        return "";
    }

    public Object getFieldValue() {
        try {
            return this.field.get(this.object.getInstance());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}

