/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.dialogs.StatusInfo;
import org.eclipse.dltk.ui.formatter.FormatterMessages;
import org.eclipse.dltk.ui.formatter.IFormatterModifiyTabPage;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialogOwner;
import org.eclipse.dltk.ui.formatter.IProfile;
import org.eclipse.dltk.ui.formatter.IProfileManager;
import org.eclipse.dltk.ui.formatter.IProfileStore;
import org.eclipse.dltk.ui.formatter.IScriptFormatterFactory;
import org.eclipse.dltk.ui.formatter.ProfileKind;
import org.eclipse.dltk.ui.formatter.internal.FormatterControlManager;
import org.eclipse.dltk.ui.formatter.internal.FormatterDialogPreferences;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class FormatterModifyDialog
extends StatusDialog
implements IFormatterModifyDialog,
IStatusChangeListener {
    private final FormatterDialogPreferences preferences = new FormatterDialogPreferences();
    private final FormatterControlManager controlManager = new FormatterControlManager(this.preferences, this);
    private static final int SAVE_BUTTON_ID = 1025;
    private final IFormatterModifyDialogOwner dialogOwner;
    private final IScriptFormatterFactory formatterFactory;
    final IDialogSettings fDialogSettings;
    private Button fSaveButton;
    private StringDialogField fProfileNameField;
    private IProfileManager manager;
    protected IProfile profile;
    private IStatus tabStatus = Status.OK_STATUS;
    private static final String KEY_X = "x";
    private static final String KEY_Y = "y";
    private static final String KEY_WIDTH = "width";
    private static final String KEY_HEIGHT = "height";
    private TabFolder fTabFolder;
    private final List<IFormatterModifiyTabPage> fTabPages = new ArrayList<IFormatterModifiyTabPage>();

    public FormatterModifyDialog(IFormatterModifyDialogOwner dialogOwner, IScriptFormatterFactory formatterFactory) {
        super(dialogOwner.getShell());
        this.dialogOwner = dialogOwner;
        this.formatterFactory = formatterFactory;
        this.fDialogSettings = FormatterModifyDialog.getDialogSettingsSection(dialogOwner.getDialogSettings(), formatterFactory.getId());
        this.setStatusLineAboveButtons(false);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    @Override
    public void setProfileManager(IProfileManager manager) {
        this.manager = manager;
        this.profile = manager.getSelected();
        this.setTitle(NLS.bind((String)FormatterMessages.FormatterModifyDialog_dialogTitle, (Object)this.profile.getName()));
    }

    private static IDialogSettings getDialogSettingsSection(IDialogSettings settings, String sectionId) {
        IDialogSettings section = settings.getSection(sectionId);
        if (section == null) {
            section = settings.addNewSection(sectionId);
        }
        return section;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        try {
            int lastWidth = this.fDialogSettings.getInt(KEY_WIDTH);
            int lastHeight = this.fDialogSettings.getInt(KEY_HEIGHT);
            return new Point(lastWidth, lastHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            return new Point(this.fDialogSettings.getInt(KEY_X), this.fDialogSettings.getInt(KEY_Y));
        }
        catch (NumberFormatException ex) {
            return super.getInitialLocation(initialSize);
        }
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(KEY_WIDTH, shell.width);
        this.fDialogSettings.put(KEY_HEIGHT, shell.height);
        this.fDialogSettings.put(KEY_X, shell.x);
        this.fDialogSettings.put(KEY_Y, shell.y);
        return super.close();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite nameComposite = new Composite(composite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComposite.setLayout((Layout)new GridLayout(3, false));
        this.fProfileNameField = new StringDialogField();
        this.fProfileNameField.setLabelText(FormatterMessages.FormatterModifyDialog_profileName);
        if (this.profile != null) {
            this.fProfileNameField.setText(this.profile.getName());
        }
        this.fProfileNameField.getLabelControl(nameComposite).setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fProfileNameField.getTextControl(nameComposite).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fProfileNameField.setDialogFieldListener(field -> this.validate());
        this.fSaveButton = this.createButton(nameComposite, 1025, FormatterMessages.FormatterModifyDialog_export, false);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPages();
        this.controlManager.initialize();
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.saveButtonPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected abstract void addPages();

    protected void addTabPage(String title, IFormatterModifiyTabPage tabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        FormatterModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents(this.controlManager, (Composite)this.fTabFolder));
        this.fTabPages.add(tabPage);
    }

    @Override
    public final void statusChanged(IStatus status) {
        this.tabStatus = status;
        this.validate();
        for (IFormatterModifiyTabPage tabPage : this.fTabPages) {
            tabPage.updatePreview();
        }
    }

    @Override
    public IFormatterModifyDialogOwner getOwner() {
        return this.dialogOwner;
    }

    @Override
    public IScriptFormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (this.fSaveButton != null && !this.fSaveButton.isDisposed()) {
            this.fSaveButton.setEnabled(!this.validateProfileName().matches(4));
        }
    }

    protected void validate() {
        this.updateStatus(this.getValidationStatus());
    }

    protected IStatus getValidationStatus() {
        IStatus status = this.doValidate();
        if (this.tabStatus.getSeverity() < status.getSeverity()) {
            return status;
        }
        return this.tabStatus;
    }

    protected IStatus doValidate() {
        if (this.profile == null || this.manager == null) {
            return Status.OK_STATUS;
        }
        Map<String, String> values = this.getPreferences();
        String name = this.getProfileName();
        if (name.equals(this.profile.getName()) && this.profile.equalsTo(values)) {
            return StatusInfo.OK_STATUS;
        }
        IStatus status = this.validateProfileName();
        if (status.matches(4)) {
            return status;
        }
        if (!name.equals(this.profile.getName()) && this.manager.containsName(name)) {
            return new Status(4, "org.eclipse.dltk.ui", FormatterMessages.FormatterModifyDialog_nameExists);
        }
        if (this.profile.isBuiltInProfile()) {
            return new Status(1, "org.eclipse.dltk.ui", FormatterMessages.FormatterModifyDialog_createNewProfile);
        }
        return StatusInfo.OK_STATUS;
    }

    @Override
    public String getProfileName() {
        return this.fProfileNameField.getText().trim();
    }

    private IStatus validateProfileName() {
        String name = this.getProfileName();
        if (this.profile.isBuiltInProfile() && this.profile.getName().equals(name)) {
            return new Status(4, "org.eclipse.dltk.ui", FormatterMessages.FormatterModifyDialog_changeBuiltInProfileName);
        }
        if (name.length() == 0) {
            return new Status(4, "org.eclipse.dltk.ui", FormatterMessages.FormatterModifyDialog_nameEmpty);
        }
        return StatusInfo.OK_STATUS;
    }

    protected void okPressed() {
        super.okPressed();
        if (!this.profile.getName().equals(this.fProfileNameField.getText())) {
            this.profile = this.manager.rename(this.profile, this.fProfileNameField.getText());
            this.manager.setSelected(this.profile);
        }
    }

    private void saveButtonPressed() {
        IProfileStore store = this.formatterFactory.getProfileStore();
        IProfile selected = this.manager.create(ProfileKind.TEMPORARY, this.fProfileNameField.getText(), this.getPreferences(), this.profile.getFormatterId(), this.profile.getVersion());
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(FormatterMessages.FormatterModifyDialog_exportProfile);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        String message = NLS.bind((String)FormatterMessages.FormatterModifyDialog_replaceFileQuestion, (Object)file.getAbsolutePath());
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)FormatterMessages.FormatterModifyDialog_exportProfile, (String)message)) {
            return;
        }
        ArrayList<IProfile> profiles = new ArrayList<IProfile>();
        profiles.add(selected);
        try {
            store.writeProfilesToFile(profiles, file);
        }
        catch (CoreException e) {
            String title = FormatterMessages.FormatterModifyDialog_exportProfile;
            message = FormatterMessages.FormatterModifyDialog_exportProblem;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
    }

    @Override
    public void setPreferences(Map<String, String> prefs) {
        this.preferences.set(prefs);
        Shell shell = this.getShell();
        if (shell != null && !shell.isDisposed()) {
            this.controlManager.initialize();
        }
    }

    @Override
    public Map<String, String> getPreferences() {
        return this.preferences.get();
    }
}

