/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.activestatedebugger.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.ContainerType;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.PreferenceMessages;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SelectionDialogInput;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.SourceElement;
import org.eclipse.dltk.tcl.activestatedebugger.preferences.WorkbenchAdaptable;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesElement;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesFragment;
import org.eclipse.dltk.tcl.internal.core.sources.TclSourcesSourceModule;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.resource.ImageDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceContainerElement
extends WorkbenchAdaptable {
    public SourceContainerElement(SelectionDialogInput input) {
        super(input);
    }

    @Override
    public ContainerType getContainerType() {
        return ContainerType.SOURCES;
    }

    @Override
    public Object[] getChildren() {
        Set<IScriptProject> projects = this.input.collectProjects();
        HashSet<SourceElement> sources = new HashSet<SourceElement>();
        for (TclSourcesSourceModule module : SourceContainerElement.collectSources(projects)) {
            sources.add(new SourceElement(module.getFullPath()));
        }
        return sources.toArray();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return DLTKPluginImages.DESC_OBJS_LIBRARY;
    }

    public String getLabel(Object o) {
        return PreferenceMessages.InstrumentationLabelProvider_Sources;
    }

    private static Set<TclSourcesSourceModule> collectSources(Set<IScriptProject> projects) {
        HashSet<TclSourcesSourceModule> sources = new HashSet<TclSourcesSourceModule>();
        for (IScriptProject project : projects) {
            try {
                IProjectFragment[] iProjectFragmentArray = project.getProjectFragments();
                int n = iProjectFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectFragment fragment = iProjectFragmentArray[n2];
                    if (fragment instanceof TclSourcesFragment) {
                        IModelElement[] iModelElementArray = fragment.getChildren();
                        int n3 = iModelElementArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IModelElement element = iModelElementArray[n4];
                            if (element instanceof TclSourcesElement) {
                                IModelElement[] iModelElementArray2 = ((IParent)element).getChildren();
                                int n5 = iModelElementArray2.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    IModelElement ee = iModelElementArray2[n6];
                                    if (ee instanceof TclSourcesSourceModule) {
                                        sources.add((TclSourcesSourceModule)ee);
                                    }
                                    ++n6;
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return sources;
    }
}

