/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

import com.google.inject.Singleton;
import java.util.Arrays;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.util.Strings;

@Singleton
public class UriExtensions {
    public URI toUri(String stringUri) {
        URI result = URI.createURI((String)stringUri);
        if (this.shouldValidateEncodingSequences(result, stringUri)) {
            return this.cleanupEncodedCharacters(result);
        }
        return this.withEmptyAuthority(result);
    }

    protected boolean shouldValidateEncodingSequences(URI rawUri, String uriAsString) {
        return uriAsString.contains("%");
    }

    protected URI cleanupEncodedCharacters(URI encoded) {
        String authority = encoded.authority();
        Object segments = encoded.segments();
        String device = encoded.device();
        String opaque = encoded.opaquePart();
        String query = encoded.query();
        String fragment = encoded.fragment();
        if (authority == null && encoded.isFile()) {
            authority = "";
        } else if (authority != null && !authority.isEmpty()) {
            authority = URI.encodeAuthority((String)URI.decode((String)authority), (boolean)false);
        }
        int segmentIdx = 0;
        if (device == null && ((String[])segments).length > 0) {
            String maybeDevice = URI.encodeSegment((String)URI.decode((String)segments[0]), (boolean)false);
            if (URI.validDevice((String)maybeDevice)) {
                device = maybeDevice;
                segments = ((String[])segments).length == 2 && segments[1].isEmpty() ? Strings.EMPTY_ARRAY : (((String[])segments).length > 1 ? Arrays.copyOfRange(segments, 1, ((String[])segments).length) : null);
            } else {
                segments[0] = maybeDevice;
                ++segmentIdx;
            }
        }
        if (segments != null) {
            for (int i = segmentIdx; i < ((String[])segments).length; ++i) {
                segments[i] = URI.encodeSegment((String)URI.decode((String)segments[i]), (boolean)false);
            }
        }
        if (opaque != null) {
            opaque = URI.encodeOpaquePart((String)URI.decode((String)opaque), (boolean)false);
        }
        if (query != null) {
            query = URI.encodeQuery((String)URI.decode((String)query), (boolean)false);
        }
        if (fragment != null) {
            query = URI.encodeFragment((String)URI.decode((String)fragment), (boolean)false);
        }
        URI result = opaque != null ? this.withEmptyAuthority(URI.createGenericURI((String)encoded.scheme(), (String)opaque, (String)fragment)) : (segments != null ? URI.createHierarchicalURI((String)encoded.scheme(), (String)authority, (String)device, (String[])segments, (String)query, (String)fragment) : URI.createHierarchicalURI((String)encoded.scheme(), (String)authority, (String)device, (String)query, (String)fragment));
        return result;
    }

    public URI toEmfUri(java.net.URI netUri) {
        return this.toUri(netUri.toString());
    }

    public String toDecodedString(java.net.URI uri) {
        String scheme = uri.getScheme();
        String part = uri.getSchemeSpecificPart();
        if (scheme == null) {
            return part;
        }
        return scheme + ":" + part;
    }

    public URI withEmptyAuthority(URI uri) {
        if (uri.isFile() && uri.authority() == null) {
            String[] segments = uri.segments();
            String device = uri.device();
            String scheme = uri.scheme();
            String emptyAuthority = "";
            String query = uri.query();
            String fragment = uri.fragment();
            if (!uri.hasAbsolutePath()) {
                return URI.createHierarchicalURI((String)scheme, (String)emptyAuthority, (String)device, (String)query, (String)fragment);
            }
            return URI.createHierarchicalURI((String)scheme, (String)emptyAuthority, (String)device, (String[])segments, (String)query, (String)fragment);
        }
        return uri;
    }
}

