/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor.sections;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.peers.Peer;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.ui.controls.CustomTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.PipeTransportPanel;
import org.eclipse.tcf.te.tcf.ui.controls.TcpTransportPanel;
import org.eclipse.tcf.te.tcf.ui.editor.controls.TransportSectionTypeControl;
import org.eclipse.tcf.te.tcf.ui.editor.controls.TransportSectionTypePanelControl;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.controls.BaseDialogPageControl;
import org.eclipse.tcf.te.ui.controls.interfaces.IWizardConfigurationPanel;
import org.eclipse.tcf.te.ui.forms.parts.AbstractSection;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode;
import org.eclipse.tcf.te.ui.interfaces.data.IDataExchangeNode3;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.views.editor.pages.AbstractEditorPage;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TransportSection
extends AbstractSection
implements IDataExchangeNode {
    private TransportSectionTypeControl transportTypeControl = null;
    TransportSectionTypePanelControl transportTypePanelControl = null;
    protected IPeerNode od;
    final IPropertiesContainer odc = new PropertiesContainer();
    final IPropertiesContainer wc = new PropertiesContainer();

    public TransportSection(IManagedForm form, Composite parent) {
        super(form, parent, 128);
        this.createClient(this.getSection(), form.getToolkit());
    }

    public void dispose() {
        super.dispose();
        if (this.transportTypeControl != null) {
            this.transportTypeControl.dispose();
            this.transportTypeControl = null;
        }
        if (this.transportTypePanelControl != null) {
            this.transportTypePanelControl.dispose();
            this.transportTypePanelControl = null;
        }
    }

    public Object getAdapter(Class adapter) {
        if (TransportSectionTypeControl.class.equals((Object)adapter)) {
            return this.transportTypeControl;
        }
        if (TransportSectionTypePanelControl.class.equals((Object)adapter)) {
            return this.transportTypePanelControl;
        }
        return super.getAdapter(adapter);
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        Assert.isNotNull((Object)section);
        Assert.isNotNull((Object)toolkit);
        section.setText(Messages.TransportSection_title);
        section.setDescription(Messages.TransportSection_description);
        if (section.getParent().getLayout() instanceof GridLayout) {
            section.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite client = this.createClientContainer((Composite)section, 2, toolkit);
        Assert.isNotNull((Object)client);
        section.setClient((Control)client);
        this.transportTypeControl = new TransportSectionTypeControl(this){

            @Override
            public String[] getTransportTypes() {
                ArrayList<String> types = new ArrayList<String>();
                String[] stringArray = super.getTransportTypes();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String type = stringArray[n2];
                    if (TransportSection.this.isTransportTypeSupported(type)) {
                        types.add(type);
                    }
                    ++n2;
                }
                return types.toArray(new String[types.size()]);
            }
        };
        this.transportTypeControl.setFormToolkit(toolkit);
        this.transportTypeControl.setAdjustBackgroundColor(true);
        this.transportTypeControl.setupPanel(client);
        this.createEmptySpace(client, 2, toolkit);
        this.transportTypePanelControl = new TransportSectionTypePanelControl(this);
        if (this.isTransportTypeSupported("TCP")) {
            TcpTransportPanel tcpTransportPanel = new TcpTransportPanel((BaseDialogPageControl)this.transportTypePanelControl){

                protected boolean isAdjustBackgroundColor() {
                    return true;
                }

                protected boolean hasHistory() {
                    return true;
                }
            };
            this.transportTypePanelControl.addConfigurationPanel("TCP", (IWizardConfigurationPanel)tcpTransportPanel);
        }
        if (this.isTransportTypeSupported("SSL")) {
            TcpTransportPanel sslTransportPanel = new TcpTransportPanel((BaseDialogPageControl)this.transportTypePanelControl){

                protected boolean isAdjustBackgroundColor() {
                    return true;
                }
            };
            this.transportTypePanelControl.addConfigurationPanel("SSL", (IWizardConfigurationPanel)sslTransportPanel);
        }
        if (this.isTransportTypeSupported("PIPE")) {
            PipeTransportPanel pipeTransportPanle = new PipeTransportPanel((BaseDialogPageControl)this.transportTypePanelControl){

                @Override
                protected boolean isAdjustBackgroundColor() {
                    return true;
                }
            };
            this.transportTypePanelControl.addConfigurationPanel("PIPE", (IWizardConfigurationPanel)pipeTransportPanle);
        }
        if (this.isTransportTypeSupported("Custom")) {
            CustomTransportPanel customTransportPanel = new CustomTransportPanel((BaseDialogPageControl)this.transportTypePanelControl){

                @Override
                protected boolean isAdjustBackgroundColor() {
                    return true;
                }
            };
            this.transportTypePanelControl.addConfigurationPanel("Custom", (IWizardConfigurationPanel)customTransportPanel);
        }
        this.transportTypePanelControl.setupPanel(client, this.transportTypePanelControl.getConfigurationPanelIds(), toolkit);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        this.transportTypePanelControl.getPanel().setLayoutData((Object)layoutData);
        toolkit.adapt(this.transportTypePanelControl.getPanel());
        this.transportTypePanelControl.showConfigurationPanel(this.transportTypeControl.getSelectedTransportType());
        this.updateEnablement();
        this.setIsUpdating(false);
    }

    public boolean isTransportTypeSupported(String transportType) {
        return true;
    }

    public void setActive(boolean active) {
        if (active) {
            Object node;
            if (this.getManagedForm().getContainer() instanceof AbstractEditorPage && !((AbstractEditorPage)this.getManagedForm().getContainer()).isDirty() && (node = ((AbstractEditorPage)this.getManagedForm().getContainer()).getEditorInputNode()) instanceof IPeerNode) {
                this.setupData((IPeerNode)node);
            }
        } else {
            this.dataChanged(null);
        }
    }

    public void setupData(IPropertiesContainer data) {
        String transportType;
        Assert.isNotNull((Object)data);
        this.setIsUpdating(true);
        if (this.transportTypeControl != null && (transportType = data.getStringProperty("TransportName")) != null && !"".equals(transportType)) {
            this.transportTypeControl.setSelectedTransportType(transportType);
            if (!this.transportTypeControl.getSelectedTransportType().equals(transportType)) {
                transportType = "Custom";
                this.transportTypeControl.setSelectedTransportType(transportType);
            }
            if (this.transportTypePanelControl != null) {
                this.transportTypePanelControl.showConfigurationPanel(transportType);
                IWizardConfigurationPanel panel = this.transportTypePanelControl.getConfigurationPanel(transportType);
                if (panel instanceof IDataExchangeNode) {
                    ((IDataExchangeNode)panel).setupData(data);
                }
            }
        }
        this.setIsUpdating(false);
        this.dataChanged(null);
        this.updateEnablement();
    }

    public void setupData(final IPeerNode node) {
        if (this.isDirty()) {
            return;
        }
        boolean updateWidgets = true;
        if (node == null && this.od == null || node != null && node.equals(this.od)) {
            updateWidgets = false;
        }
        PropertiesContainer previousOdc = new PropertiesContainer();
        previousOdc.setProperties(this.odc.getProperties());
        this.od = node;
        this.odc.clearProperties();
        this.wc.clearProperties();
        if (node == null) {
            return;
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                TransportSection.this.odc.setProperty("TransportName", (Object)node.getPeer().getTransportName());
                if (TransportSection.this.transportTypePanelControl != null) {
                    PropertiesContainer src = new PropertiesContainer();
                    Map properties = node.getPeer().getAttributes();
                    for (Map.Entry entry : properties.entrySet()) {
                        src.setProperty((String)entry.getKey(), entry.getValue());
                    }
                    String[] stringArray = TransportSection.this.transportTypePanelControl.getConfigurationPanelIds();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        IWizardConfigurationPanel panel = TransportSection.this.transportTypePanelControl.getConfigurationPanel(id);
                        if (panel instanceof IDataExchangeNode3) {
                            ((IDataExchangeNode3)panel).copyData((IPropertiesContainer)src, TransportSection.this.odc);
                        }
                        ++n2;
                    }
                }
                TransportSection.this.wc.setProperties(TransportSection.this.odc.getProperties());
            }
        });
        if (!previousOdc.getProperties().equals(this.odc.getProperties())) {
            updateWidgets = true;
        }
        if (updateWidgets) {
            this.setupData(this.wc);
        } else {
            this.dataChanged(null);
            this.updateEnablement();
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        if (this.transportTypePanelControl != null) {
            String[] ids;
            String[] stringArray = ids = this.transportTypePanelControl.getConfigurationPanelIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IWizardConfigurationPanel panel = this.transportTypePanelControl.getConfigurationPanel(id);
                if (panel instanceof IDataExchangeNode && panel instanceof IDataExchangeNode3) {
                    ((IDataExchangeNode3)panel).removeData(data);
                }
                ++n2;
            }
            IWizardConfigurationPanel panel = this.transportTypePanelControl.getActiveConfigurationPanel();
            if (panel instanceof IDataExchangeNode) {
                ((IDataExchangeNode)panel).extractData(data);
            }
        }
        if (this.transportTypeControl != null) {
            data.setProperty("TransportName", (Object)this.transportTypeControl.getSelectedTransportType());
        }
    }

    public void extractData(final IPeerNode node) {
        if (node == null) {
            return;
        }
        final ArrayList<String> removed = new ArrayList<String>();
        Set currentKeySet = this.wc.getProperties().keySet();
        this.extractData(this.wc);
        if (this.odc.equals(this.wc)) {
            return;
        }
        Set newKeySet = this.wc.getProperties().keySet();
        for (String key : currentKeySet) {
            if (newKeySet.contains(key)) continue;
            removed.add(key);
        }
        Protocol.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                IPeer oldPeer = node.getPeer();
                HashMap<String, String> attributes = new HashMap<String, String>(oldPeer.getAttributes());
                for (String key : removed) {
                    attributes.remove(key);
                }
                for (String key : TransportSection.this.wc.getProperties().keySet()) {
                    String value = TransportSection.this.wc.getStringProperty(key);
                    if (value != null) {
                        attributes.put(key, value);
                        continue;
                    }
                    attributes.remove(key);
                }
                IChannel channel = Tcf.getChannelManager().getChannel(oldPeer);
                if (channel != null) {
                    channel.close();
                }
                Peer newPeer = new Peer(attributes);
                boolean changed = node.setChangeEventsEnabled(false);
                node.setProperty("PeerInstance", (Object)newPeer);
                node.setProperty("dns.name.transient", null);
                node.setProperty("dns.lastIP.transient", null);
                node.setProperty("dns.skip.transient", null);
                if (changed) {
                    node.setChangeEventsEnabled(true);
                }
            }
        });
    }

    public boolean isValid() {
        if (this.isUpdating()) {
            return true;
        }
        boolean valid = super.isValid();
        if (this.transportTypeControl != null) {
            valid &= this.transportTypeControl.isValid();
            if (this.transportTypeControl.getMessageType() > this.getMessageType()) {
                this.setMessage(this.transportTypeControl.getMessage(), this.transportTypeControl.getMessageType());
            }
        }
        if (this.transportTypePanelControl != null) {
            valid &= this.transportTypePanelControl.isValid();
            if (this.transportTypePanelControl.getMessageType() > this.getMessageType()) {
                this.setMessage(this.transportTypePanelControl.getMessage(), this.transportTypePanelControl.getMessageType());
            }
        }
        return valid;
    }

    public void commit(boolean onSave) {
        boolean needsSaving = this.isDirty();
        super.commit(onSave);
        if (!onSave || !needsSaving) {
            return;
        }
        this.extractData(this.od);
    }

    public void dataChanged(TypedEvent e) {
        if (this.isUpdating()) {
            return;
        }
        boolean isDirty = false;
        if (this.transportTypeControl != null) {
            String transportType = this.transportTypeControl.getSelectedTransportType();
            if (!"Custom".equals(transportType)) {
                String value;
                isDirty = "".equals(transportType) ? (isDirty |= (value = this.odc.getStringProperty("TransportName")) != null && !"".equals(value.trim())) : (isDirty |= !this.odc.isProperty("TransportName", (Object)transportType));
            }
            if (this.transportTypePanelControl != null) {
                isDirty |= this.transportTypePanelControl.getConfigurationPanel(transportType).dataChanged(this.odc, e);
            }
        }
        this.markDirty(isDirty);
        this.updateEnablement();
    }

    public void updateAttributes(IPropertiesContainer attributes) {
        Assert.isNotNull((Object)attributes);
        if (this.transportTypePanelControl != null) {
            String[] ids;
            String[] stringArray = ids = this.transportTypePanelControl.getConfigurationPanelIds();
            int n = ids.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                IWizardConfigurationPanel panel = this.transportTypePanelControl.getConfigurationPanel(id);
                if (panel instanceof IDataExchangeNode && panel instanceof IDataExchangeNode3) {
                    ((IDataExchangeNode3)panel).removeData(attributes);
                }
                ++n2;
            }
            IWizardConfigurationPanel panel = this.transportTypePanelControl.getActiveConfigurationPanel();
            if (panel instanceof IDataExchangeNode) {
                ((IDataExchangeNode)panel).extractData(attributes);
            }
        }
        if (this.transportTypeControl != null) {
            attributes.setProperty("TransportName", (Object)this.transportTypeControl.getSelectedTransportType());
        }
    }

    protected void updateEnablement() {
        IPeerNode input = this.od;
        if (this.transportTypeControl != null) {
            boolean enabled = !this.isReadOnly() && (!(input instanceof IPeerNode) || input.getConnectState() == 1);
            SWTControlUtil.setEnabled((Control)this.transportTypeControl.getEditFieldControl(), (enabled && SWTControlUtil.getItemCount((Control)this.transportTypeControl.getEditFieldControl()) > 1 ? 1 : 0) != 0);
            if (this.transportTypePanelControl != null) {
                this.transportTypePanelControl.getConfigurationPanel(this.transportTypeControl.getSelectedTransportType()).setEnabled(enabled);
            }
        }
    }

    public void saveWidgetValues(IDialogSettings settings) {
        super.saveWidgetValues(settings);
        if (settings != null && this.transportTypePanelControl != null) {
            this.transportTypePanelControl.saveWidgetValues(settings, TransportSection.class.getSimpleName());
        }
    }

    public void restoreWidgetValues(IDialogSettings settings) {
        super.restoreWidgetValues(settings);
        if (settings != null && this.transportTypePanelControl != null) {
            this.transportTypePanelControl.restoreWidgetValues(settings, TransportSection.class.getSimpleName());
        }
    }
}

