/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.util;

import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.ResultRunnable;

public class Display {
    private static final Logger log = Logger.getLogger(Display.class);
    private static org.eclipse.swt.widgets.Display display;

    private Display() {
    }

    public static org.eclipse.swt.widgets.Display getDisplay() {
        if (display == null || display.isDisposed()) {
            Thread[] allThreads;
            display = null;
            Thread[] threadArray = allThreads = Display.allThreads();
            int n = allThreads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread thread = threadArray[n2];
                org.eclipse.swt.widgets.Display d = org.eclipse.swt.widgets.Display.findDisplay((Thread)thread);
                if (d != null && !d.isDisposed()) {
                    display = d;
                }
                ++n2;
            }
            if (display == null) {
                throw new RedDeerException("Could not find a display");
            }
        }
        return display;
    }

    public static void syncExec(Runnable runnable) {
        Display.syncExec(new VoidResultRunnable(runnable));
    }

    public static <T> T syncExec(ResultRunnable<T> runnable) {
        ErrorHandlingRunnable errorHandlingRunnable = new ErrorHandlingRunnable(runnable);
        if (!Display.isUIThread()) {
            Display.getDisplay().syncExec(errorHandlingRunnable);
        } else {
            if (runnable instanceof ErrorHandlingRunnable) {
                errorHandlingRunnable = (ErrorHandlingRunnable)((Object)runnable);
            }
            errorHandlingRunnable.run();
        }
        if (errorHandlingRunnable.exceptionOccurred()) {
            Display.handleErrorOccured(errorHandlingRunnable, true);
        }
        return errorHandlingRunnable.getResult();
    }

    public static void asyncExec(Runnable runnable) {
        ErrorHandlingRunnable<Void> errorHandlingRunnable = new ErrorHandlingRunnable<Void>(new VoidResultRunnable(runnable));
        Display.getDisplay().asyncExec(errorHandlingRunnable);
        if (errorHandlingRunnable.exceptionOccurred()) {
            Display.handleErrorOccured(errorHandlingRunnable, false);
        }
    }

    private static <T> void handleErrorOccured(ErrorHandlingRunnable<T> errorHandlingRunnable, boolean sync) {
        Exception e = errorHandlingRunnable.getException();
        String syncType = "sync";
        if (!sync) {
            syncType = "async";
        }
        throw new RedDeerException("Exception during " + syncType + " execution in UI thread", e);
    }

    private static boolean isUIThread() {
        return Display.getDisplay().getThread() == Thread.currentThread();
    }

    private static Thread[] allThreads() {
        ThreadGroup threadGroup = Display.primaryThreadGroup();
        Thread[] threads = new Thread[64];
        int enumerate = threadGroup.enumerate(threads, true);
        Thread[] result = new Thread[enumerate];
        System.arraycopy(threads, 0, result, 0, enumerate);
        return result;
    }

    private static ThreadGroup primaryThreadGroup() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return threadGroup;
    }

    private static class ErrorHandlingRunnable<T>
    implements Runnable {
        private ResultRunnable<T> runnable;
        private T result;
        private Exception exception;

        private ErrorHandlingRunnable(ResultRunnable<T> runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            try {
                this.result = this.runnable.run();
            }
            catch (Exception e) {
                this.exception = e;
            }
        }

        public boolean exceptionOccurred() {
            return this.getException() != null;
        }

        public Exception getException() {
            return this.exception;
        }

        public T getResult() {
            return this.result;
        }
    }

    private static class VoidResultRunnable
    implements ResultRunnable<Void> {
        private Runnable runnable;

        public VoidResultRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public Void run() {
            this.runnable.run();
            return null;
        }
    }
}

