/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.location;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import org.eclipse.osgi.internal.location.Locker;
import org.eclipse.osgi.internal.location.Locker_JavaIo;
import org.eclipse.osgi.internal.location.Locker_JavaNio;

public class LocationHelper {
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    public static final String LOCKING_NONE = "none";
    public static final String LOCKING_IO = "java.io";
    public static final String LOCKING_NIO = "java.nio";

    public static URL buildURL(String spec, boolean trailingSlash) {
        if (spec == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            spec = spec.trim();
        }
        boolean isFile = spec.startsWith("file:");
        try {
            if (isFile) {
                return LocationHelper.adjustTrailingSlash(new File(spec.substring(5)).toURL(), trailingSlash);
            }
            return new URL(spec);
        }
        catch (MalformedURLException malformedURLException) {
            if (isFile) {
                return null;
            }
            try {
                return LocationHelper.adjustTrailingSlash(new File(spec).toURL(), trailingSlash);
            }
            catch (MalformedURLException malformedURLException2) {
                return null;
            }
        }
    }

    private static URL adjustTrailingSlash(URL url, boolean trailingSlash) throws MalformedURLException {
        String file = url.getPath();
        if (trailingSlash == file.endsWith("/")) {
            return url;
        }
        file = trailingSlash ? String.valueOf(file) + "/" : file.substring(0, file.length() - 1);
        return new URL(url.getProtocol(), url.getHost(), file);
    }

    public static Locker createLocker(File lock, String lockMode, boolean debug) {
        if (lockMode == null) {
            lockMode = System.getProperty(PROP_OSGI_LOCKING);
        }
        if (LOCKING_NONE.equals(lockMode)) {
            return new Locker.MockLocker();
        }
        if (LOCKING_IO.equals(lockMode)) {
            return new Locker_JavaIo(lock);
        }
        if (LOCKING_NIO.equals(lockMode)) {
            return new Locker_JavaNio(lock, debug);
        }
        return new Locker_JavaNio(lock, debug);
    }

    public static InputStream getStream(URL location) throws IOException {
        File f;
        if ("file".equalsIgnoreCase(location.getProtocol()) && (f = new File(location.getPath())).exists()) {
            return new FileInputStream(f);
        }
        return location.openStream();
    }

    public static URLConnection getConnection(URL url) throws IOException {
        block3: {
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                try {
                    return url.openConnection();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    File f = new File(url.getPath());
                    if (!f.exists()) break block3;
                    return f.toURI().toURL().openConnection();
                }
            }
        }
        return url.openConnection();
    }

    public static File decodePath(File file) {
        if (!(file.exists() || file.getPath().indexOf(37) < 0 && file.getPath().indexOf(43) < 0)) {
            String absolute = file.getAbsolutePath();
            String decodePath = LocationHelper.decode(absolute, true);
            File f = new File(decodePath);
            if (f.exists()) {
                return f;
            }
            decodePath = LocationHelper.decode(absolute, false);
            f = new File(decodePath);
            if (f.exists()) {
                return f;
            }
        }
        return file;
    }

    public static String decode(String urlString, boolean plusEncoded) {
        if (plusEncoded && urlString.indexOf(43) >= 0) {
            int len = urlString.length();
            StringBuilder buf = new StringBuilder(len);
            int i = 0;
            while (i < len) {
                char c = urlString.charAt(i);
                if (c == '+') {
                    buf.append("%2B");
                } else {
                    buf.append(c);
                }
                ++i;
            }
            urlString = buf.toString();
        }
        try {
            return URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException | RuntimeException exception) {
            return urlString;
        }
    }
}

