/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.variables;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.model.elements.VariableLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.ScriptDebugModelPresentation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class ScriptVariableLabelProvider
extends VariableLabelProvider
implements IPropertyChangeListener {
    private IPreferenceStore store;

    public ScriptVariableLabelProvider(IPreferenceStore store) {
        this.store = store;
        this.store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.store.removePropertyChangeListener((IPropertyChangeListener)this);
        this.store = null;
    }

    protected IDebugModelPresentation getModelPresentation(IPresentationContext context, String modelId) {
        return DLTKDebugUIPlugin.getDefault().getModelPresentation(modelId);
    }

    protected String getVariableName(IVariable variable, IPresentationContext context) throws CoreException {
        IDebugModelPresentation presentation = this.getModelPresentation(context, variable.getModelIdentifier());
        if (presentation != null) {
            return ((ScriptDebugModelPresentation)presentation).getVariableName(variable);
        }
        return super.getVariableName(variable, context);
    }

    protected String getValueText(IVariable variable, IValue value, IPresentationContext context) throws CoreException {
        IDebugModelPresentation presentation = this.getModelPresentation(context, value.getModelIdentifier());
        if (presentation != null) {
            return presentation.getText((Object)value);
        }
        return super.getValueText(variable, value, context);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }
}

