/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.graphiti.impl.graphitieditpart;

import java.util.Arrays;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.gef.impl.editpart.AbstractEditPart;
import org.eclipse.reddeer.graphiti.GraphitiLayerException;
import org.eclipse.reddeer.graphiti.api.ContextButton;
import org.eclipse.reddeer.graphiti.api.GraphitiEditPart;
import org.eclipse.reddeer.graphiti.handler.GraphitiEditPartHandler;
import org.hamcrest.Matcher;

public class AbstractGraphitiEditPart
extends AbstractEditPart
implements GraphitiEditPart {
    private static final Logger LOG = Logger.getLogger(AbstractGraphitiEditPart.class);

    public AbstractGraphitiEditPart(EditPart editPart) {
        super(editPart);
    }

    public AbstractGraphitiEditPart(Matcher<EditPart> matcher, int index) {
        super(matcher, index);
    }

    public AbstractGraphitiEditPart(Matcher<EditPart> matcher) {
        super(matcher);
    }

    @Override
    public List<ContextButton> getContextButtons() {
        return GraphitiEditPartHandler.getInstance().getContextButtons(this.editPart);
    }

    @Override
    public ContextButton getContextButton(String ... label) {
        LOG.info("Looking for context button " + Arrays.toString(label));
        List<ContextButton> contextButtons = this.getContextButtons();
        ContextButton contextButton = this.find(label[0], contextButtons);
        int i = 1;
        while (i < label.length) {
            contextButton = this.find(label[i], contextButton.getContextButtons());
            ++i;
        }
        return contextButton;
    }

    private ContextButton find(String label, List<ContextButton> entries) {
        for (ContextButton entry : entries) {
            if (!entry.getText().equals(label)) continue;
            return entry;
        }
        LOG.debug("Cannot find context button with label '" + label + "'");
        LOG.debug("Available context buttons:");
        for (ContextButton entry : entries) {
            LOG.debug("\t'" + entry.getText() + "'");
        }
        throw new GraphitiLayerException("Cannot find context button '" + label + "'");
    }

    @Override
    public void doubleClick() {
        GraphitiEditPartHandler.getInstance().doubleClick(this.editPart);
    }
}

