/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.util.stream.Stream;
import org.eclipse.jdt.core.compiler.CharOperation;

public final class QualifierQuery {
    public static final char[] NO_CHARS = new char[0];
    private QueryCategory[] categories;
    private char[] simpleKey;
    private char[] qualifiedKey;

    private QualifierQuery(QueryCategory[] categories, char[] simpleKey, char[] qualifiedKey) {
        this.categories = categories;
        this.simpleKey = simpleKey;
        this.qualifiedKey = qualifiedKey;
    }

    public static QualifierQuery fromEncodedQuery(char[] query) {
        char[][] components = CharOperation.splitOn(':', query);
        return new QualifierQuery(QueryCategory.fromEncoded(CharOperation.splitOn(',', components[0])), components[1], components.length == 3 ? components[2] : NO_CHARS);
    }

    public static char[] encodeQuery(QueryCategory[] categories, char[] simpleKey, char[] qualifierKey) {
        char[] category = CharOperation.concatWith((char[][])Stream.of(categories).map(c -> c.name().toCharArray()).toArray(n -> new char[n][]), ',');
        return CharOperation.concatWith(new char[][]{category, simpleKey, qualifierKey}, ':');
    }

    public QueryCategory[] getCategories() {
        return this.categories;
    }

    public char[] getQualifiedKey() {
        return this.qualifiedKey;
    }

    public char[] getSimpleKey() {
        return this.simpleKey;
    }

    public static enum QueryCategory {
        SUPER,
        REF;


        public static QueryCategory[] fromEncoded(char[][] encoded) {
            return (QueryCategory[])Stream.of(encoded).map(c -> QueryCategory.valueOf(String.valueOf(c))).toArray(QueryCategory[]::new);
        }
    }
}

