/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.wsdl.util.xml.DOM2Writer;
import com.ibm.wsdl.util.xml.DOMUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.mime.MIMEMultipartRelated;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.apache.xerces.util.URI;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSTypeDefinition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.analyzer.AnalyzerContext;
import org.eclipse.wst.wsi.internal.core.analyzer.CandidateInfo;
import org.eclipse.wst.wsi.internal.core.analyzer.ServiceReference;
import org.eclipse.wst.wsi.internal.core.analyzer.config.AnalyzerConfig;
import org.eclipse.wst.wsi.internal.core.document.DocumentFactory;
import org.eclipse.wst.wsi.internal.core.log.Log;
import org.eclipse.wst.wsi.internal.core.log.LogReader;
import org.eclipse.wst.wsi.internal.core.log.MessageEntry;
import org.eclipse.wst.wsi.internal.core.log.MessageEntryHandler;
import org.eclipse.wst.wsi.internal.core.profile.ProfileArtifact;
import org.eclipse.wst.wsi.internal.core.profile.ProfileAssertions;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.LogValidator;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.BaseValidatorImpl;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.ArtifactReference;
import org.eclipse.wst.wsi.internal.core.report.FailureDetail;
import org.eclipse.wst.wsi.internal.core.report.ReportArtifact;
import org.eclipse.wst.wsi.internal.core.report.Reporter;
import org.eclipse.wst.wsi.internal.core.util.EntryType;
import org.eclipse.wst.wsi.internal.core.util.HTTPUtils;
import org.eclipse.wst.wsi.internal.core.util.Utils;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLUtils;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class BaseMessageValidator
extends BaseValidatorImpl
implements LogValidator {
    private WSDLDocument wsdlDocument;
    protected MessageEntry logEntry;
    protected Log log;
    private boolean testable;
    private AnalyzerConfig analyzerConfig;

    @Override
    public void init(AnalyzerContext analyzerContext, ProfileAssertions assertions, ReportArtifact reportArtifact, AnalyzerConfig analyzerConfig, Reporter reporter) throws WSIException {
        super.init(analyzerContext, assertions.getArtifact(this.getArtifactType()), reportArtifact, reporter);
        this.testable = analyzerConfig.getLogLocation() != null;
        this.analyzerConfig = analyzerConfig;
        this.wsdlDocument = analyzerContext.getWsdlDocument();
    }

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, WSDLDocument wsdlDocument, Reporter reporter) throws WSIException {
        super.init(analyzerContext, profileArtifact, reportArtifact, reporter);
        this.analyzerConfig = Utils.getAnalyzerConfig(reporter);
        this.testable = this.analyzerConfig != null && this.analyzerConfig.getLogLocation() != null;
        this.wsdlDocument = wsdlDocument;
    }

    public WSDLDocument getWSDLDocument() {
        return this.wsdlDocument;
    }

    @Override
    public void validate(EntryContext entryContext) throws WSIException {
        this.logEntry = entryContext.getMessageEntry();
        AnalyzerConfig analyzerConfig = this.reporter.getReport().getReportContext().getAnalyzer().getAnalyzerConfig();
        if (!analyzerConfig.isWSDLReferenceSet() || this.messageCorrelatesToService(entryContext, analyzerConfig.getCorrelationType())) {
            String classPrefix = String.valueOf(this.getClass().getPackage().getName()) + ".";
            this.processAssertions(classPrefix, entryContext);
        }
    }

    private boolean messageCorrelatesToService(EntryContext entryContext, String correlationType) throws WSIException {
        URI[] endpoints = null;
        boolean correlation = false;
        CandidateInfo candidate = this.analyzerContext.getCandidateInfo();
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        Definition definition = candidate.getWsdlDocument().getDefinitions();
        Binding binding = null;
        if (serviceReference.getWSDLElement().isPort()) {
            Service service = definition.getService(serviceReference.getWSDLElement().getParentElementQName());
            Port port = service.getPort(serviceReference.getWSDLElement().getName());
            binding = port.getBinding();
        } else if (serviceReference.getWSDLElement().isBinding()) {
            binding = definition.getBinding(serviceReference.getWSDLElement().getQName());
        }
        if (binding == null) {
            return false;
        }
        endpoints = this.hostAndPortCorrelation(entryContext);
        if (endpoints != null && this.urlPathCorrelation(entryContext, endpoints)) {
            if (correlationType.equals("endpoint")) {
                correlation = true;
            } else {
                String requestType = this.getHttpRequestType(entryContext);
                if (requestType != null && requestType.equalsIgnoreCase("GET")) {
                    correlation = true;
                } else {
                    Document requestMessage = entryContext.getRequestDocument();
                    if (this.namespaceCorrelation(binding, requestMessage)) {
                        if (correlationType.equals("namespace")) {
                            correlation = true;
                        } else if (this.operationCorrelation(binding, requestMessage) && correlationType.equals("operation")) {
                            correlation = true;
                        } else {
                            throw new WSIException("Bad correlation type found in config: " + correlationType);
                        }
                    }
                }
            }
        }
        return correlation;
    }

    private URI[] hostAndPortCorrelation(EntryContext entryContext) throws WSIException {
        String httpHostAndPort = entryContext.getRequest().getReceiverHostAndPort();
        return this.analyzerContext.getCandidateInfo().getEndPoints(httpHostAndPort);
    }

    private boolean urlPathCorrelation(EntryContext entryContext, URI[] endpoints) throws WSIException {
        Vector requestLine = this.getHttpRequest(entryContext.getRequest().getHTTPHeaders());
        if (requestLine == null) {
            return false;
        }
        String requestPath = (String)requestLine.get(1);
        Vector<URI> filteredEndpoints = new Vector<URI>();
        int i = 0;
        while (i < endpoints.length) {
            if (endpoints[i].toString().endsWith(requestPath)) {
                filteredEndpoints.add(endpoints[i]);
            }
            ++i;
        }
        return filteredEndpoints.size() != 0;
    }

    private boolean namespaceCorrelation(Binding binding, Document request) throws WSIException {
        boolean namespaceFound = false;
        String bindingStyle = "document";
        String soapOpNS = this.getSoapBodyChild(request).getNamespaceURI();
        SOAPBinding soapBinding = null;
        soapBinding = WSDLUtils.getSoapBinding(binding);
        if (soapBinding != null) {
            bindingStyle = soapBinding.getStyle();
        }
        Iterator operations = binding.getBindingOperations().iterator();
        while (operations.hasNext() && !namespaceFound) {
            BindingOperation bindingOperation = (BindingOperation)operations.next();
            if (WSDLUtils.isRpcLiteral(bindingStyle, bindingOperation)) {
                SOAPBody soapBody = WSDLUtils.getInputSoapBody(bindingOperation);
                if (soapBody.getNamespaceURI() == null || !soapBody.getNamespaceURI().equals(soapOpNS)) continue;
                namespaceFound = true;
                continue;
            }
            if (!WSDLUtils.isDocLiteral(bindingStyle, bindingOperation)) continue;
            Iterator partsIterator = null;
            String partName = this.getFirstPartName(bindingOperation);
            Map partsMap = null;
            partsMap = bindingOperation.getOperation().getInput().getMessage().getParts();
            if (partsMap == null) continue;
            partsIterator = partsMap.values().iterator();
            int partCount = partName == null ? 1 : partsMap.size();
            int i = 0;
            while (i < partCount && !namespaceFound) {
                Part part = (Part)partsIterator.next();
                if ((partName == null || partName != null && part.getName().equals(partName)) && part.getElementName().getNamespaceURI() != null && part.getElementName().getNamespaceURI().equals(soapOpNS)) {
                    namespaceFound = true;
                }
                ++i;
            }
        }
        return namespaceFound;
    }

    private boolean operationCorrelation(Binding binding, Document requestMessage) throws WSIException {
        Element soapBodyChild;
        boolean operationFound = false;
        String bindingStyle = "document";
        SOAPBinding soapBinding = null;
        soapBinding = WSDLUtils.getSoapBinding(binding);
        if (soapBinding != null) {
            bindingStyle = soapBinding.getStyle();
        }
        if ((soapBodyChild = this.getSoapBodyChild(requestMessage)) != null) {
            String operationName = soapBodyChild.getLocalName();
            QName operationQName = new QName(soapBodyChild.getNamespaceURI(), operationName);
            Iterator operations = binding.getBindingOperations().iterator();
            while (operations.hasNext() && !operationFound) {
                BindingOperation bindingOperation = (BindingOperation)operations.next();
                if (WSDLUtils.isRpcLiteral(bindingStyle, bindingOperation)) {
                    if (!bindingOperation.getName().equals(operationName)) continue;
                    operationFound = true;
                    continue;
                }
                if (!WSDLUtils.isDocLiteral(bindingStyle, bindingOperation)) continue;
                Iterator partsIterator = null;
                String partName = this.getFirstPartName(bindingOperation);
                Map partsMap = null;
                partsMap = bindingOperation.getOperation().getInput().getMessage().getParts();
                if (partsMap == null) continue;
                partsIterator = partsMap.values().iterator();
                int partCount = partName == null ? 1 : partsMap.size();
                int i = 0;
                while (i < partCount && !operationFound) {
                    Part part = (Part)partsIterator.next();
                    if ((partName == null || partName != null && part.getName().equals(partName)) && part.getElementName() != null && part.getElementName().equals(operationQName)) {
                        operationFound = true;
                    }
                    ++i;
                }
            }
        }
        return operationFound;
    }

    public FailureDetail createFailureDetail(String message, EntryContext entryContext) {
        FailureDetail failureDetail = this.reporter.createFailureDetail();
        failureDetail.setFailureMessage(message);
        failureDetail.setElementLocation(entryContext.getMessageEntry().getElementLocation());
        return failureDetail;
    }

    @Override
    protected boolean isNotApplicable(TestAssertion testAssertion) {
        boolean notApplicable = false;
        if (testAssertion.getAdditionalEntryTypeList().getWSDLInput() != null && !testAssertion.getAdditionalEntryTypeList().getWSDLInput().equals("none") && this.analyzerContext.getServiceReference().getWSDLLocation() == null) {
            notApplicable = true;
        }
        return notApplicable;
    }

    public Vector getPostRequest(String httpHeader) {
        Vector<String> requestLine = new Vector<String>();
        String startLine = null;
        StringTokenizer httpMessageTokenizer = new StringTokenizer(httpHeader, "\n\r\f");
        if (httpMessageTokenizer.hasMoreTokens()) {
            startLine = httpMessageTokenizer.nextToken();
        }
        if (startLine.startsWith("POST")) {
            StringTokenizer startLineTokenizer = new StringTokenizer(startLine, " ");
            while (startLineTokenizer.hasMoreTokens()) {
                requestLine.add(startLineTokenizer.nextToken());
            }
        }
        return requestLine;
    }

    private Vector getHttpRequest(String httpHeader) {
        Vector<String> requestLine = new Vector<String>();
        String startLine = null;
        StringTokenizer httpMessageTokenizer = new StringTokenizer(httpHeader, "\n\r\f");
        if (httpMessageTokenizer.hasMoreTokens()) {
            startLine = httpMessageTokenizer.nextToken();
        }
        if (startLine.startsWith("POST") || startLine.startsWith("GET")) {
            StringTokenizer startLineTokenizer = new StringTokenizer(startLine, " ");
            while (startLineTokenizer.hasMoreTokens()) {
                requestLine.add(startLineTokenizer.nextToken());
            }
        } else {
            requestLine = null;
        }
        return requestLine;
    }

    private String getHttpRequestType(EntryContext entryContext) {
        StringTokenizer startLineTokenizer;
        String httpHeader = entryContext.getRequest().getHTTPHeaders();
        String httpRequestType = null;
        String startLine = null;
        StringTokenizer httpMessageTokenizer = new StringTokenizer(httpHeader, "\n\r\f");
        if (httpMessageTokenizer.hasMoreTokens() && (startLineTokenizer = new StringTokenizer(startLine = httpMessageTokenizer.nextToken(), " ")).hasMoreTokens()) {
            httpRequestType = startLineTokenizer.nextToken();
        }
        return httpRequestType;
    }

    public boolean isOneWayResponse(EntryContext entryContext) {
        boolean oneway = false;
        if (entryContext.getMessageEntry().getType().equalsIgnoreCase("response") && entryContext.getMessageEntry().getMessage().length() == 0) {
            oneway = true;
        }
        return oneway;
    }

    public boolean messageIsDocLitSchemaValid(EntryContext entryContext) throws WSIException {
        ArrayList<String> schemaWSDLs = new ArrayList<String>();
        ArrayList<Element> inlineSchemas = new ArrayList<Element>();
        ArrayList<String> schemaStrings = new ArrayList<String>();
        Definition[] allDefs = this.analyzerContext.getCandidateInfo().getDefinitions();
        int thisDef = 0;
        while (thisDef < allDefs.length) {
            schemaWSDLs.add(allDefs[thisDef].getDocumentBaseURI());
            ++thisDef;
        }
        Iterator fileIterator = schemaWSDLs.iterator();
        while (fileIterator.hasNext()) {
            Document wsdlDoc = null;
            String wsdlURI = (String)fileIterator.next();
            try {
                wsdlDoc = XMLUtils.parseXMLDocumentURL(wsdlURI, null);
            }
            catch (Exception exception) {
                continue;
            }
            Element root = wsdlDoc.getDocumentElement();
            NodeList schemaElements = root.getElementsByTagNameNS(WSITag.ELEM_XSD_SCHEMA.getNamespaceURI(), WSITag.ELEM_XSD_SCHEMA.getLocalPart());
            int elem = 0;
            while (elem < schemaElements.getLength()) {
                Element schema = (Element)schemaElements.item(elem);
                this.copyNSDeclarations(root, schema);
                this.copyNSDeclarations((Element)schema.getParentNode(), schema);
                this.replaceRelativeURIs(schema, wsdlURI);
                inlineSchemas.add(schema);
                ++elem;
            }
        }
        if (!this.duplicateNamespacesDetected(inlineSchemas)) {
            for (Element schema : inlineSchemas) {
                String schemaString = DOM2Writer.nodeToString((Node)schema);
                schemaStrings.add(schemaString);
            }
            NodeList elementList = entryContext.getMessageEntryDocument().getElementsByTagNameNS(WSITag.ELEM_SOAP_BODY.getNamespaceURI(), WSITag.ELEM_SOAP_BODY.getLocalPart());
            if (elementList == null || elementList.getLength() != 1) {
                return false;
            }
            NodeList soapBodyChildList = ((Element)elementList.item(0)).getChildNodes();
            int child = 0;
            while (child < soapBodyChildList.getLength()) {
                Node soapBodyChild = soapBodyChildList.item(child);
                if (soapBodyChild.getNodeType() == 1) {
                    try {
                        String messageContent = DOM2Writer.nodeToString((Node)soapBodyChild);
                        XMLUtils.parseXML(messageContent, schemaStrings);
                    }
                    catch (WSIException e) {
                        if (e.getTargetException() instanceof SAXException) {
                            throw new WSIException(e.getTargetException().getMessage());
                        }
                        throw e;
                    }
                    catch (Exception e) {
                        throw new WSIException("Validating Parsing problem", e);
                    }
                }
                ++child;
            }
        }
        return true;
    }

    private void copyNSDeclarations(Element parent, Element child) {
        NamedNodeMap nodeMap = parent.getAttributes();
        int nodeId = 0;
        while (nodeId < nodeMap.getLength()) {
            Node node = nodeMap.item(nodeId);
            if (node.getNodeType() == 2 && node.getNodeName().startsWith("xmlns:")) {
                String nodeName = node.getNodeName();
                if (!child.getNodeName().startsWith(String.valueOf(nodeName.substring(nodeName.indexOf(":") + 1)) + ":")) {
                    child.setAttribute(nodeName, node.getNodeValue());
                }
            }
            ++nodeId;
        }
    }

    private void replaceRelativeURIs(Element schema, String wsdlURI) {
        NodeList imports = schema.getElementsByTagNameNS(WSITag.ELEM_XSD_IMPORT.getNamespaceURI(), WSITag.ELEM_XSD_IMPORT.getLocalPart());
        int i = 0;
        while (i < imports.getLength()) {
            Element imp = (Element)imports.item(i);
            Attr schemaLocation = XMLUtils.getAttribute(imp, WSITag.ATTR_XSD_SCHEMALOCATION);
            if (schemaLocation != null) {
                URI uri = null;
                try {
                    uri = new URI(schemaLocation.getValue());
                }
                catch (Exception exception) {}
                if (uri == null) {
                    String newURI = String.valueOf(wsdlURI.substring(0, wsdlURI.lastIndexOf("/") + 1)) + schemaLocation.getValue();
                    try {
                        uri = new URI(newURI);
                        schemaLocation.setValue(uri.toString());
                    }
                    catch (Exception exception) {}
                }
            }
            ++i;
        }
    }

    public BindingOperation getOperationMatch(EntryType entryType, Document doc) {
        BindingOperation bindingOperation = null;
        try {
            BindingOperation[] docBindingOperations;
            BindingOperation[] potentialDocLitOps;
            BindingOperation[] rpcBindingOps;
            QName operation = this.getOperationFromMessage(doc);
            if (operation != null && (bindingOperation = this.getOperationMatch(entryType, operation, rpcBindingOps = this.getMatchingBindingOps("rpc", this.analyzerContext.getCandidateInfo().getBindings()))) == null && (potentialDocLitOps = this.getDocLitOperations(entryType, operation, docBindingOperations = this.getMatchingBindingOps("document", this.analyzerContext.getCandidateInfo().getBindings()))).length == 1) {
                bindingOperation = potentialDocLitOps[0];
            }
        }
        catch (Exception exception) {}
        return bindingOperation;
    }

    public BindingOperation getOperationMatch(EntryType messageEntryType, Document soapMessage, BindingOperation[] op) {
        QName operation = this.getOperationFromMessage(soapMessage);
        return this.getOperationMatch(messageEntryType, operation, op);
    }

    public BindingOperation getOperationMatch(EntryType messageEntryType, QName operation, BindingOperation[] op) {
        int k = 0;
        while (k < op.length) {
            String name = null;
            List extensibles = null;
            BindingOperation bindingOp = op[k];
            if (messageEntryType.isType("requestMessage") && bindingOp.getOperation().getInput() != null) {
                name = bindingOp.getOperation().getName();
                extensibles = bindingOp.getBindingInput().getExtensibilityElements();
            } else if (messageEntryType.isType("responseMessage") && bindingOp.getOperation().getOutput() != null) {
                name = String.valueOf(bindingOp.getOperation().getName()) + "Response";
                extensibles = bindingOp.getBindingOutput().getExtensibilityElements();
            }
            SOAPBody soapBody = this.getSoapBody(extensibles);
            QName checkOperation = soapBody == null ? new QName(name) : new QName(soapBody.getNamespaceURI(), name);
            if (operation != null && operation.equals(checkOperation)) {
                return bindingOp;
            }
            ++k;
        }
        return null;
    }

    public BindingOperation getOperationPartsMatch(EntryType messageEntryType, Document soapMessage, BindingOperation[] op) {
        Map parts = this.getPartListFromMessage(soapMessage);
        int k = 0;
        while (k < op.length) {
            Message wsdlMessage = null;
            List extensibles = null;
            BindingOperation bindingOp = op[k];
            if (messageEntryType.isType("requestMessage") && bindingOp.getOperation().getInput() != null) {
                wsdlMessage = bindingOp.getOperation().getInput().getMessage();
                extensibles = bindingOp.getBindingInput().getExtensibilityElements();
            } else if (messageEntryType.isType("responseMessage") && bindingOp.getOperation().getOutput() != null) {
                wsdlMessage = bindingOp.getOperation().getOutput().getMessage();
                extensibles = bindingOp.getBindingOutput().getExtensibilityElements();
            }
            if (this.sameParts(parts, wsdlMessage, this.getSoapHeader(extensibles))) {
                return bindingOp;
            }
            ++k;
        }
        return null;
    }

    private SOAPBody getSoapBody(List extElems) {
        if (extElems != null) {
            int i = 0;
            while (i < extElems.size()) {
                ExtensibilityElement extElem = (ExtensibilityElement)extElems.get(i);
                if (extElem.getElementType().equals(WSITag.WSDL_SOAP_BODY)) {
                    return (SOAPBody)extElem;
                }
                if (extElem.getElementType().equals(WSITag.WSDL_MIME_MULTIPART)) {
                    List mimeParts = ((MIMEMultipartRelated)extElem).getMIMEParts();
                    int j = 0;
                    while (j < mimeParts.size()) {
                        SOAPBody soapBody = this.getSoapBody(((MIMEPart)mimeParts.get(j)).getExtensibilityElements());
                        if (soapBody != null) {
                            return soapBody;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private SOAPHeader getSoapHeader(List extensibles) {
        SOAPHeader soapHeader = null;
        if (extensibles != null) {
            Iterator i = extensibles.iterator();
            while (i.hasNext() && soapHeader == null) {
                try {
                    soapHeader = (SOAPHeader)i.next();
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return soapHeader;
    }

    private String getFirstPartName(BindingOperation bindingOperation) {
        String partName = null;
        List extList = null;
        Iterator partsIterator = null;
        extList = bindingOperation.getBindingInput().getExtensibilityElements();
        if (extList != null) {
            List partsList = null;
            Iterator extIterator = extList.iterator();
            while (extIterator.hasNext() && partName == null) {
                Object extElement = extIterator.next();
                if (!(extElement instanceof SOAPBody) || (partsList = ((SOAPBody)extElement).getParts()) == null || !(partsIterator = partsList.iterator()).hasNext()) continue;
                partName = (String)partsIterator.next();
            }
        }
        return partName;
    }

    public BindingOperation[] getDocLitOperations(EntryType messageType, QName partElementQName, BindingOperation[] wsdlOperations) {
        if (messageType.isType(EntryType.getEntryType("requestMessage"))) {
            return this.getInputDocLitOperations(partElementQName, wsdlOperations);
        }
        if (messageType.isType(EntryType.getEntryType("responseMessage"))) {
            return this.getOutputDocLitOperations(partElementQName, wsdlOperations);
        }
        return null;
    }

    private BindingOperation[] getInputDocLitOperations(QName partElementQName, BindingOperation[] wsdlOperations) {
        Vector<BindingOperation> potentialOps = new Vector<BindingOperation>();
        int i = 0;
        while (i < wsdlOperations.length) {
            block2: {
                Message message;
                block3: {
                    if (wsdlOperations[i].getOperation().getInput() == null) break block2;
                    message = wsdlOperations[i].getOperation().getInput().getMessage();
                    if (partElementQName != null) break block3;
                    if (!message.getParts().isEmpty()) break block2;
                    potentialOps.add(wsdlOperations[i]);
                    break block2;
                }
                for (Part nextPart : message.getParts().values()) {
                    if (!partElementQName.equals(nextPart.getElementName())) continue;
                    potentialOps.add(wsdlOperations[i]);
                    break;
                }
            }
            ++i;
        }
        return potentialOps.toArray(new BindingOperation[0]);
    }

    private BindingOperation[] getOutputDocLitOperations(QName partElementQName, BindingOperation[] wsdlOperations) {
        Vector<BindingOperation> potentialOps = new Vector<BindingOperation>();
        int i = 0;
        while (i < wsdlOperations.length) {
            block2: {
                Message message;
                block3: {
                    if (wsdlOperations[i].getOperation().getOutput() == null) break block2;
                    message = wsdlOperations[i].getOperation().getOutput().getMessage();
                    if (partElementQName != null) break block3;
                    if (!message.getParts().isEmpty()) break block2;
                    potentialOps.add(wsdlOperations[i]);
                    break block2;
                }
                for (Part nextPart : message.getParts().values()) {
                    if (!partElementQName.equals(nextPart.getElementName())) continue;
                    potentialOps.add(wsdlOperations[i]);
                    break;
                }
            }
            ++i;
        }
        return potentialOps.toArray(new BindingOperation[0]);
    }

    private boolean sameParts(Map messageParts, Message wsdlMessage, SOAPHeader soapHeader) {
        String soapHeaderPart = null;
        if (soapHeader != null) {
            soapHeaderPart = soapHeader.getPart();
        }
        if (messageParts == null && wsdlMessage == null) {
            return true;
        }
        if (messageParts == null || wsdlMessage == null) {
            return false;
        }
        Vector<QName> v = new Vector<QName>();
        Map wsdlParts = null;
        if (wsdlMessage.getParts() != null) {
            wsdlParts = wsdlMessage.getParts();
            for (Part p : wsdlParts.values()) {
                if (p.getName().equals(soapHeaderPart)) continue;
                v.add(new QName(p.getName()));
            }
        }
        if (v.isEmpty() && messageParts.isEmpty()) {
            return true;
        }
        if (v.containsAll(messageParts.keySet()) && v.size() == messageParts.size()) {
            for (QName partName : messageParts.keySet()) {
                Part part;
                QName xsiType = (QName)messageParts.get(partName);
                if (xsiType == null || wsdlParts == null || this.isDerivedType(xsiType, (part = (Part)wsdlParts.get(partName.getLocalPart())).getTypeName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isDerivedType(QName extType, QName type) {
        if (extType == null || type == null) {
            return false;
        }
        if (extType.equals(type)) {
            return true;
        }
        for (XSModel xsModel : this.wsdlDocument.getSchemas().values()) {
            XSTypeDefinition xsType = xsModel.getTypeDefinition(extType.getLocalPart(), extType.getNamespaceURI());
            if (xsType == null || !xsType.derivedFrom(type.getNamespaceURI(), type.getLocalPart(), (short)0)) continue;
            return true;
        }
        return false;
    }

    public Element getSoapBodyChild(Document doc) {
        Element root;
        NodeList bodies;
        Element opElem = null;
        if (doc != null && (bodies = (root = doc.getDocumentElement()).getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && bodies.getLength() > 0) {
            Element body = (Element)bodies.item(0);
            NodeList children = body.getChildNodes();
            int i = 0;
            while (i < children.getLength() && opElem == null) {
                Node n = children.item(i);
                if (n instanceof Element) {
                    opElem = (Element)n;
                }
                ++i;
            }
        }
        return opElem;
    }

    public boolean isFault(Document doc) {
        boolean isFault = false;
        if (doc != null) {
            Element root = doc.getDocumentElement();
            isFault = root.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault").getLength() > 0;
        }
        return isFault;
    }

    public boolean containsSoapBodyWithChild(Document doc) {
        boolean contains = false;
        if (doc != null) {
            contains = this.getSoapBodyChild(doc) != null;
        }
        return contains;
    }

    public String getSoapAction(String headers) throws WSIException {
        String action = null;
        if (headers != null) {
            action = (String)HTTPUtils.getHttpHeaderTokens(headers, ":").get("SOAPAction".toUpperCase());
        }
        return action;
    }

    private QName getOperationFromMessage(Document doc) {
        Element root;
        NodeList bodies;
        QName operation = null;
        if (doc != null && (bodies = (root = doc.getDocumentElement()).getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && bodies.getLength() > 0) {
            Element body = (Element)bodies.item(0);
            NodeList children = body.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                if (n instanceof Element) {
                    operation = new QName(n.getNamespaceURI(), n.getLocalName());
                }
                ++i;
            }
        }
        return operation;
    }

    private Map getPartListFromMessage(Document doc) {
        Element root;
        NodeList bodies;
        HashMap<QName, QName> parts = new HashMap<QName, QName>();
        if (doc != null && (bodies = (root = doc.getDocumentElement()).getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body")) != null && bodies.getLength() > 0) {
            Element body = (Element)bodies.item(0);
            NodeList children = body.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node n = children.item(i);
                if (n instanceof Element) {
                    NodeList grandChildren = n.getChildNodes();
                    int j = 0;
                    while (j < grandChildren.getLength()) {
                        Node m = grandChildren.item(j);
                        if (m instanceof Element) {
                            Attr attr = XMLUtils.getAttribute((Element)m, new QName("http://www.w3.org/2001/XMLSchema-instance", "type"));
                            QName xsiType = null;
                            try {
                                if (attr != null) {
                                    xsiType = DOMUtils.getQName((String)attr.getNodeValue(), (Element)((Element)m), (Definition)this.wsdlDocument.getDefinitions());
                                }
                            }
                            catch (WSDLException wSDLException) {}
                            parts.put(new QName(m.getNamespaceURI(), m.getLocalName()), xsiType);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return parts;
    }

    public BindingOperation[] getMatchingBindingOps(String bindingStyle, Binding[] bindings) throws WSIException {
        HashSet<BindingOperation> bindingOperationsSet = new HashSet<BindingOperation>();
        int i = 0;
        while (i < bindings.length) {
            Binding tryBinding = bindings[i];
            List bindingOps = tryBinding.getBindingOperations();
            if (bindingOps != null) {
                for (BindingOperation bindingOp : tryBinding.getBindingOperations()) {
                    SOAPBinding soapBind;
                    String style;
                    SOAPOperation soapOp = WSDLValidatorImpl.getSoapOperation(bindingOp);
                    if ((soapOp == null || (style = soapOp.getStyle()) == null) && (style = (soapBind = WSDLValidatorImpl.getSoapBinding(tryBinding)).getStyle()) == null) {
                        style = "document";
                    }
                    if (!style.equals(bindingStyle)) continue;
                    bindingOperationsSet.add(bindingOp);
                }
            }
            ++i;
        }
        return bindingOperationsSet.toArray(new BindingOperation[0]);
    }

    public boolean isLiteral(List extElems) {
        SOAPBody soapBody = this.getSOAPBody(extElems);
        return soapBody != null && soapBody.getUse().equals("literal");
    }

    public List orderPartNames(List messageParts, List extElems) {
        ArrayList<String> orderedPartNames = new ArrayList<String>();
        List bodyParts = null;
        SOAPBody soapBody = this.getSOAPBody(extElems);
        if (soapBody != null) {
            bodyParts = soapBody.getParts();
        }
        Iterator i = messageParts.iterator();
        while (i.hasNext()) {
            String partName = ((Part)i.next()).getName();
            if (bodyParts != null && !bodyParts.contains(partName)) continue;
            orderedPartNames.add(partName);
        }
        return orderedPartNames;
    }

    public SOAPBody getSOAPBody(List extElems) {
        if (extElems == null) {
            return null;
        }
        for (Object obj : extElems) {
            if (!(obj instanceof SOAPBody)) continue;
            return (SOAPBody)obj;
        }
        return null;
    }

    public List resolveSameNamespaces(List schemaElements) {
        ArrayList<String> namespaces = new ArrayList<String>();
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element schema : schemaElements) {
            String targetNamespace = schema.getAttribute("targetNamespace");
            if (namespaces.contains(targetNamespace)) continue;
            namespaces.add(targetNamespace);
            List schemas = this.getSchemasWithSameNamespace(schemaElements, targetNamespace);
            if (schemas.size() == 1) {
                result.add(schema);
                continue;
            }
            this.copyNSDeclarations((Element)schema.getParentNode(), schema);
        }
        return null;
    }

    public List getSchemasWithSameNamespace(List schemaElements, String targetNamespace) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element schema : schemaElements) {
            String schemaTargetNamespace = schema.getAttribute("targetNamespace");
            if (schemaTargetNamespace == null) {
                schemaTargetNamespace = "";
            }
            if (!schemaTargetNamespace.equals(targetNamespace)) continue;
            result.add(schema);
        }
        return result;
    }

    public boolean duplicateNamespacesDetected(List schemaElements) {
        boolean result = false;
        ArrayList<String> namespaces = new ArrayList<String>();
        for (Element schema : schemaElements) {
            String targetNamespace = schema.getAttribute("targetNamespace");
            if (targetNamespace == null) {
                targetNamespace = "";
            }
            if (namespaces.contains(targetNamespace)) {
                result = true;
                break;
            }
            namespaces.add(targetNamespace);
        }
        return result;
    }

    @Override
    public boolean runTests() {
        return this.testable;
    }

    @Override
    public void validateArtifact() throws WSIException {
        LogReader logReader = DocumentFactory.newInstance().newLogReader();
        LogProcessor envelopeProcessor = new LogProcessor(this);
        logReader.readLog(this.analyzerConfig.getLogLocation(), (MessageEntryHandler)envelopeProcessor);
    }

    @Override
    public void cleanup() throws WSIException {
        super.cleanup();
        this.wsdlDocument = null;
    }

    protected class LogProcessor
    implements MessageEntryHandler {
        LogValidator validator = null;

        LogProcessor(LogValidator validator) {
            this.validator = validator;
        }

        @Override
        public void processArtifactReference(ArtifactReference artifactReference) throws WSIException {
            BaseMessageValidator.this.reporter.addArtifactReference(artifactReference);
        }

        @Override
        public void processLogEntry(EntryContext entryContext) throws WSIException {
            this.validator.validate(entryContext);
        }
    }
}

