/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.helper.decoration;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.internal.helper.decoration.DecorationHelperInternal;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.model.business.internal.helper.LayerModelHelper;
import org.eclipse.sirius.viewpoint.Decoration;

public class DecorationHelper {
    private DDiagram diagram;
    private DecorationHelperInternal decorationHelperInternal;

    public DecorationHelper(DDiagram diagram) {
        this.decorationHelperInternal = new DecorationHelperInternal(diagram);
        this.diagram = diagram;
    }

    public void updateDecorations(List<Layer> layers) {
        ArrayList dDiagramElements = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.diagram.eAllContents(), DDiagramElement.class));
        for (Layer layer : layers) {
            boolean transientLayer = LayerModelHelper.isTransientLayer((Layer)layer);
            EList activatedLayers = this.diagram.getActivatedLayers();
            EList activatedTransientLayers = this.diagram.getActivatedTransientLayers();
            for (DDiagramElement diagElement : dDiagramElements) {
                if (transientLayer) {
                    this.decorationHelperInternal.deleteOrResetDecoration(diagElement, (List<Decoration>)diagElement.getTransientDecorations(), (List<? extends Layer>)activatedTransientLayers);
                } else {
                    this.decorationHelperInternal.deleteOrResetDecoration(diagElement, (List<Decoration>)diagElement.getDecorations(), (List<? extends Layer>)activatedLayers);
                }
                if ((!transientLayer || !activatedTransientLayers.contains(layer)) && (transientLayer || !activatedLayers.contains(layer))) continue;
                this.decorationHelperInternal.updateDecorationToAdd(diagElement, layer);
            }
        }
    }

    public void updateAllDecorations() {
        ArrayList dDiagramElements = Lists.newArrayList((Iterator)Iterators.filter((Iterator)this.diagram.eAllContents(), DDiagramElement.class));
        EList activatedLayers = this.diagram.getActivatedLayers();
        EList activatedTransientLayers = this.diagram.getActivatedTransientLayers();
        ArrayList layers = Lists.newArrayList((Iterable)Iterables.concat((Iterable)this.diagram.getActivatedLayers(), (Iterable)this.diagram.getActivatedTransientLayers()));
        for (DDiagramElement diagElement : dDiagramElements) {
            this.decorationHelperInternal.deleteOrResetDecoration(diagElement, (List<Decoration>)diagElement.getTransientDecorations(), (List<? extends Layer>)activatedTransientLayers);
            this.decorationHelperInternal.deleteOrResetDecoration(diagElement, (List<Decoration>)diagElement.getDecorations(), (List<? extends Layer>)activatedLayers);
            for (Layer layer : layers) {
                this.decorationHelperInternal.updateDecorationToAdd(diagElement, layer);
            }
        }
    }
}

