/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.ctab;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.handler.CTabFolderHandler;
import org.eclipse.reddeer.core.handler.CTabItemHandler;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.api.CTabItem;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.exception.SWTLayerException;
import org.eclipse.reddeer.swt.impl.ctab.DefaultCTabFolder;
import org.eclipse.reddeer.swt.widgets.AbstractItem;
import org.eclipse.swt.custom.CTabFolder;
import org.hamcrest.Matcher;

public abstract class AbstractCTabItem
extends AbstractItem<org.eclipse.swt.custom.CTabItem>
implements CTabItem {
    private static final Logger logger = Logger.getLogger(AbstractCTabItem.class);
    protected CTabFolder swtParent;
    private CTabItemHandler cTabItemHandler = CTabItemHandler.getInstance();

    protected AbstractCTabItem(ReferencedComposite referencedComposite, int index, Matcher<?> ... matchers) {
        super(org.eclipse.swt.custom.CTabItem.class, referencedComposite, index, matchers);
        this.swtParent = this.cTabItemHandler.getCTabFolder((org.eclipse.swt.custom.CTabItem)this.swtWidget);
    }

    protected AbstractCTabItem(org.eclipse.swt.custom.CTabItem swtWidget) {
        super(swtWidget);
    }

    @Override
    public void activate() {
        logger.info("Activate " + this.getText());
        this.cTabItemHandler.activate((org.eclipse.swt.custom.CTabItem)this.swtWidget);
    }

    @Override
    public String getToolTipText() {
        return CTabItemHandler.getInstance().getToolTipText((org.eclipse.swt.custom.CTabItem)this.swtWidget);
    }

    @Override
    public void close() {
        logger.info("Close CTabItem " + this.getText());
        if (!this.isShowClose()) {
            throw new SWTLayerException("CTabItem with label " + this.getText() + " has no close button");
        }
        this.activate();
        this.cTabItemHandler.clickCloseButton((org.eclipse.swt.custom.CTabItem)this.swtWidget);
    }

    @Override
    public boolean isShowClose() {
        return this.cTabItemHandler.isShowClose((org.eclipse.swt.custom.CTabItem)this.swtWidget);
    }

    @Override
    public boolean isShowing() {
        return this.cTabItemHandler.isShowing((org.eclipse.swt.custom.CTabItem)this.swtWidget);
    }

    @Override
    public org.eclipse.reddeer.swt.api.CTabFolder getFolder() {
        return new DefaultCTabFolder(this.swtParent);
    }

    @Override
    public Control<?> getParentControl() {
        return this.getFolder();
    }

    public org.eclipse.swt.widgets.Control getControl() {
        return this.cTabItemHandler.getControl((org.eclipse.swt.custom.CTabItem)this.swtWidget);
    }

    @Override
    public boolean isActive() {
        org.eclipse.swt.custom.CTabItem selectedItem = CTabFolderHandler.getInstance().getSelection(this.swtParent);
        return ((org.eclipse.swt.custom.CTabItem)this.swtWidget).equals(selectedItem);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.swtWidget == null ? 0 : ((org.eclipse.swt.custom.CTabItem)this.swtWidget).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractCTabItem other = (AbstractCTabItem)obj;
        return !(this.swtWidget == null ? other.swtWidget != null : !((org.eclipse.swt.custom.CTabItem)this.swtWidget).equals(other.swtWidget));
    }
}

