/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.server.ui.cnf;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.logging.LoggingUtils;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.DefaultServer;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewServerWizard;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.api.TreeItem;
import org.eclipse.reddeer.swt.impl.menu.ContextMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;

public class ServersView2
extends WorkbenchView {
    public static final String TITLE = "Servers";
    private static final Logger log = Logger.getLogger(ServersView2.class);

    public ServersView2() {
        super(TITLE);
    }

    public NewServerWizard newServer() {
        this.activate();
        log.info("Create new server");
        new ContextMenuItem(new String[]{"New", "Server"}).select();
        new DefaultShell("New Server");
        return new NewServerWizard();
    }

    public List<Server> getServers() {
        Tree tree;
        ArrayList<Server> servers = new ArrayList<Server>();
        try {
            tree = this.getServersTree();
        }
        catch (CoreLayerException coreLayerException) {
            return new ArrayList<Server>();
        }
        for (TreeItem item : tree.getItems()) {
            if (item == null || item.isDisposed()) continue;
            servers.add(new DefaultServer(item));
        }
        return servers;
    }

    public Server getServer(String name) {
        return this.getServer(DefaultServer.class, name);
    }

    public <T extends Server> T getServer(Class<T> clazz, String name) {
        for (Server server : this.getServers()) {
            if (!server.isValid() || !server.getLabel().getName().equals(name)) continue;
            return (T)((Server)server.getAdapter(clazz));
        }
        log.info("Requested server '" + name + "' was not found on Servers view");
        log.info("Available servers are: " + LoggingUtils.format((Object[])this.getServersNames()));
        throw new EclipseLayerException("There is no server with name " + name);
    }

    protected Tree getServersTree() {
        this.activate();
        return new DefaultTree((ReferencedComposite)this);
    }

    private Object[] getServersNames() {
        List<Server> servers = this.getServers();
        Object[] names = new Object[servers.size()];
        int i = 0;
        while (i < servers.size()) {
            names[i] = servers.get(i).getLabel().getName();
            ++i;
        }
        return names;
    }
}

