/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.parameters.ui;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.ctx.parameters.ui.ParametersTransfer;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.parameters.Parameter;
import org.eclipse.rcptt.parameters.ParametersContext;
import org.eclipse.rcptt.parameters.ParametersFactory;
import org.eclipse.rcptt.ui.commons.ArrayTreeContentProvider;
import org.eclipse.rcptt.ui.context.BaseContextEditor;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.IQ7EditorActionsProvider;
import org.eclipse.rcptt.ui.editors.NamedElementEditorActions;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class ParametersContextEditor
extends BaseContextEditor
implements IQ7EditorActionsProvider {
    private static final String NAME_PROPERTY = "name";
    private static final String VALUE_PROPERTY = "value";
    private static final String[] NAME_PROPERTIES = new String[]{"name"};
    private static final String[] VALUE_PROPERTIES = new String[]{"value"};
    private static Parameter newParameterItem = ParametersFactory.eINSTANCE.createParameter();
    private Table table;
    private TableViewer viewer;
    private ToolTip tip;
    private String lastNewName = "";
    private TableColumn nameColumn;
    private TableColumn valueColumn;
    private HashMap<String, Integer> nameToIndex = new HashMap();
    private static final ISharedImages sharedImages;
    PasteAction pasteAction;
    CopyAction copyAction;
    private final NamedElementEditorActions.INamedElementActions actions = new NamedElementEditorActions.INamedElementActions(){

        public void undo() {
        }

        public void redo() {
        }

        public void paste() {
            ParametersContextEditor.this.pasteAction.run();
        }

        public void cut() {
        }

        public void copy() {
            ParametersContextEditor.this.copyAction.run();
        }

        public boolean canUndo() {
            return false;
        }

        public boolean canRedo() {
            return false;
        }

        public boolean canPaste() {
            ParametersContextEditor.this.pasteAction.update();
            return ParametersContextEditor.this.pasteAction.isEnabled();
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            ParametersContextEditor.this.pasteAction.update();
            return ParametersContextEditor.this.copyAction.isEnabled();
        }
    };

    static {
        newParameterItem.setName("Add new parameter");
        newParameterItem.setValue("");
        sharedImages = PlatformUI.getWorkbench().getSharedImages();
    }

    public void setSelectionAtLine(int line) {
        if (this.table != null && line < this.table.getItemCount()) {
            this.table.deselectAll();
            this.table.select(line);
            this.table.setFocus();
        }
    }

    public ParametersContext getContextElement() {
        try {
            return (ParametersContext)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public void dispose() {
        this.tip.setVisible(false);
        super.dispose();
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = toolkit.createSection(parent, 16706);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        section.setText("Parameters");
        Composite composite = toolkit.createComposite((Composite)section);
        section.setClient((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.viewer = this.createTable(composite, toolkit);
        this.createPanel(composite, toolkit);
        this.tip = new ToolTip(parent.getShell(), 4096);
        this.tip.setText("Error");
        Clipboard clipboard = new Clipboard(parent.getDisplay());
        this.pasteAction = new PasteAction(clipboard);
        this.copyAction = new CopyAction(clipboard);
        ToolBarManager toolBarManager = new ToolBarManager(256);
        toolBarManager.add((IAction)this.copyAction);
        toolBarManager.add((IAction)this.pasteAction);
        section.setTextClient((Control)toolBarManager.createControl((Composite)section));
        MenuManager menu = new MenuManager();
        menu.add((IAction)this.copyAction);
        menu.add((IAction)this.pasteAction);
        menu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ParametersContextEditor.this.copyAction.update();
                ParametersContextEditor.this.pasteAction.update();
            }
        });
        menu.update(true);
        this.viewer.getControl().setMenu(menu.createContextMenu(this.viewer.getControl()));
        return section;
    }

    private void sortBy(TableColumn column) {
        if (this.table.getSortColumn() != column) {
            this.table.setSortColumn(column);
            this.table.setSortDirection(128);
            this.viewer.setComparator((ViewerComparator)new Comparator(column, 128));
        } else if (this.table.getSortDirection() == 128) {
            this.table.setSortDirection(1024);
            this.viewer.setComparator((ViewerComparator)new Comparator(column, 1024));
        } else {
            this.table.setSortColumn(null);
            this.table.setSortDirection(0);
            this.viewer.setComparator((ViewerComparator)new Comparator());
        }
        this.viewer.refresh();
    }

    private static Map<String, String> toDictionary(Collection<Parameter> parameters) {
        HashMap<String, String> rv = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            rv.put(parameter.getName(), parameter.getValue());
        }
        return rv;
    }

    private static Collection<Conflict> findConflicts(Map<String, String> first, Map<String, String> second) {
        ArrayList<Conflict> rv = new ArrayList<Conflict>();
        for (Object key : Diffs.computeMapDiff(first, second).getChangedKeys()) {
            String name = (String)key;
            String value1 = first.get(key);
            String value2 = second.get(name);
            rv.add(new Conflict(name, value1, value2));
        }
        return rv;
    }

    private Collection<Conflict> resolveConflicts(Collection<Conflict> conflict) {
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(this.getForm().getForm().getShell(), (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new ArrayTreeContentProvider()){

            protected CheckboxTreeViewer createTreeViewer(Composite parent) {
                final CheckboxTreeViewer rv = super.createTreeViewer(parent);
                TreeViewerColumn column = new TreeViewerColumn((TreeViewer)rv, 0);
                column.getColumn().setText("Name");
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return ((Conflict)element).name;
                    }
                });
                column = new TreeViewerColumn((TreeViewer)rv, 0);
                column.getColumn().setText("Original value");
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return ((Conflict)element).value1;
                    }
                });
                column = new TreeViewerColumn((TreeViewer)rv, 0);
                column.getColumn().setText("New value");
                column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return ((Conflict)element).value2;
                    }
                });
                rv.getTree().setHeaderVisible(true);
                rv.refresh();
                TreeColumn[] treeColumnArray = rv.getTree().getColumns();
                int n = treeColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeColumn col = treeColumnArray[n2];
                    col.pack();
                    ++n2;
                }
                rv.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        if (!event.getSelection().isEmpty()) {
                            rv.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                    }
                });
                return rv;
            }
        };
        dialog.setTitle("Parameters name conflict");
        dialog.setMessage("Select parameters to overwrite with new values");
        dialog.setInput(conflict);
        if (dialog.open() != 0) {
            return null;
        }
        Object[] result = dialog.getResult();
        if (result == null) {
            return null;
        }
        ArrayList<Conflict> rv = new ArrayList<Conflict>();
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            rv.add((Conflict)object);
            ++n2;
        }
        return rv;
    }

    private TableViewer createTable(Composite parent, FormToolkit toolkit) {
        this.table = new Table(parent, 67586);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo((Control)this.table);
        this.table.setHeaderVisible(true);
        toolkit.adapt((Composite)this.table);
        this.table.setLinesVisible(true);
        this.nameColumn = new TableColumn(this.table, 16384);
        this.nameColumn.setText("Name");
        this.nameColumn.setWidth(200);
        this.nameColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersContextEditor.this.sortBy(ParametersContextEditor.this.nameColumn);
            }
        });
        this.valueColumn = new TableColumn(this.table, 16384);
        this.valueColumn.setText("Value");
        this.valueColumn.setWidth(350);
        this.valueColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersContextEditor.this.sortBy(ParametersContextEditor.this.valueColumn);
            }
        });
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 8: 
                    case 127: {
                        ParametersContextEditor.this.removeSelected();
                        break;
                    }
                    case 0x1000009: {
                        ParametersContextEditor.this.addNew();
                        break;
                    }
                    case 13: 
                    case 0x100000B: {
                        ParametersContextEditor.this.lastNewName = "";
                        Object el = ((StructuredSelection)ParametersContextEditor.this.viewer.getSelection()).getFirstElement();
                        if (el != null) {
                            ParametersContextEditor.this.viewer.editElement(el, 0);
                            break;
                        }
                        ParametersContextEditor.this.viewer.editElement((Object)newParameterItem, 0);
                    }
                }
            }
        });
        final TableViewer viewer = new TableViewer(this.table);
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                ParametersContext ctx = (ParametersContext)inputElement;
                ArrayList<Parameter> elements = new ArrayList<Parameter>();
                elements.addAll((Collection<Parameter>)ctx.getParameters());
                elements.add(newParameterItem);
                return elements.toArray();
            }
        });
        TableViewerColumn nameViewerColumn = new TableViewerColumn(viewer, this.nameColumn);
        nameViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Parameter p = (Parameter)element;
                return p.getName();
            }

            public Image getImage(Object element) {
                return element == newParameterItem ? Images.getImageDescriptor((String)"IMG_OBJ_ADD").createImage() : Images.getImage((String)"icons/parameter.gif");
            }

            public Font getFont(Object element) {
                if (element == newParameterItem) {
                    Font tableFont = ParametersContextEditor.this.table.getFont();
                    FontData fd = tableFont.getFontData()[0];
                    fd.setStyle(fd.getStyle() | 2);
                    return new Font(tableFont.getDevice(), fd);
                }
                return null;
            }
        });
        nameViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected CellEditor getCellEditor(final Object element) {
                final TextCellEditor editor = new TextCellEditor((Composite)ParametersContextEditor.this.table);
                editor.getControl().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        Text text = (Text)editor.getControl();
                        switch (e.detail) {
                            case 16: {
                                if (ParametersContextEditor.this.validateName(element, text.getText())) {
                                    viewer.editElement(element, 1);
                                }
                                e.detail = 0;
                                e.doit = false;
                                break;
                            }
                            case 64: {
                                if (e.keyCode != 0x1000002) break;
                                if (ParametersContextEditor.this.table.getItemCount() > ParametersContextEditor.this.table.getSelectionIndex() + 1 && (ParametersContextEditor.this.isNewAndBlank(element, text.getText()) || ParametersContextEditor.this.validateName(element, text.getText()))) {
                                    viewer.editElement(viewer.getElementAt(ParametersContextEditor.this.table.getSelectionIndex() + 1), 0);
                                }
                                e.detail = 0;
                                e.doit = false;
                                break;
                            }
                            case 32: {
                                if (e.keyCode != 0x1000001) break;
                                if (ParametersContextEditor.this.table.getSelectionIndex() > 0 && (ParametersContextEditor.this.isNewAndBlank(element, text.getText()) || ParametersContextEditor.this.validateName(element, text.getText()))) {
                                    viewer.editElement(viewer.getElementAt(ParametersContextEditor.this.table.getSelectionIndex() - 1), 0);
                                }
                                e.detail = 0;
                                e.doit = false;
                            }
                        }
                    }
                });
                return editor;
            }

            protected boolean canEdit(Object element) {
                return true;
            }

            protected Object getValue(Object element) {
                if (ParametersContextEditor.this.lastNewName.length() > 0) {
                    return ParametersContextEditor.this.lastNewName;
                }
                if (element == newParameterItem) {
                    return "";
                }
                Parameter p = (Parameter)element;
                return p.getName();
            }

            protected void setValue(final Object element, Object value) {
                String name = (String)value;
                Parameter param = (Parameter)element;
                ParametersContext ctx = ParametersContextEditor.this.getContextElement();
                if (ParametersContextEditor.this.isNewAndBlank(element, name)) {
                    ParametersContextEditor.this.lastNewName = "";
                    return;
                }
                if (!ParametersContextEditor.this.validateName(element, name)) {
                    ParametersContextEditor.this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!ParametersContextEditor.this.table.isDisposed()) {
                                viewer.editElement(element, 0);
                            }
                        }
                    });
                    return;
                }
                if (param != newParameterItem) {
                    if (!param.getName().equals(name)) {
                        Integer index = (Integer)ParametersContextEditor.this.nameToIndex.get(param.getName());
                        ParametersContextEditor.this.nameToIndex.remove(param.getName());
                        ParametersContextEditor.this.nameToIndex.put(name, index);
                        param.setName(name);
                        viewer.update(element, NAME_PROPERTIES);
                    }
                } else {
                    final Parameter newParam = ParametersFactory.eINSTANCE.createParameter();
                    newParam.setName(name);
                    newParam.setValue("");
                    ParametersContextEditor.this.nameToIndex.put(name, ParametersContextEditor.this.table.getItemCount() - 1);
                    ctx.getParameters().add((Object)newParam);
                    viewer.add((Object)newParam);
                    viewer.setSelection((ISelection)new StructuredSelection((Object)newParam), true);
                    ParametersContextEditor.this.table.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            viewer.editElement((Object)newParam, 1);
                        }
                    });
                }
            }
        });
        TableViewerColumn valueViewerColumn = new TableViewerColumn(viewer, this.valueColumn);
        valueViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Parameter p = (Parameter)element;
                return p.getValue();
            }
        });
        valueViewerColumn.setEditingSupport(new EditingSupport((ColumnViewer)viewer){

            protected CellEditor getCellEditor(final Object element) {
                final TextCellEditor editor = new TextCellEditor((Composite)ParametersContextEditor.this.table);
                editor.getControl().addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        Text text = (Text)editor.getControl();
                        switch (e.detail) {
                            case 8: {
                                if (ParametersContextEditor.this.validateName(element, text.getText())) {
                                    viewer.editElement(element, 0);
                                }
                                e.detail = 0;
                                e.doit = false;
                                break;
                            }
                            case 64: {
                                if (e.keyCode != 0x1000002) break;
                                if (ParametersContextEditor.this.table.getItemCount() > ParametersContextEditor.this.table.getSelectionIndex() + 1) {
                                    viewer.editElement(viewer.getElementAt(ParametersContextEditor.this.table.getSelectionIndex() + 1), 1);
                                }
                                e.detail = 0;
                                e.doit = false;
                                break;
                            }
                            case 32: {
                                if (e.keyCode != 0x1000001) break;
                                if (ParametersContextEditor.this.table.getSelectionIndex() > 0) {
                                    viewer.editElement(viewer.getElementAt(ParametersContextEditor.this.table.getSelectionIndex() - 1), 1);
                                }
                                e.detail = 0;
                                e.doit = false;
                            }
                        }
                    }
                });
                return editor;
            }

            protected boolean canEdit(Object element) {
                return element != newParameterItem;
            }

            protected Object getValue(Object element) {
                Parameter p = (Parameter)element;
                return p.getValue();
            }

            protected void setValue(Object element, Object value) {
                Parameter p = (Parameter)element;
                String v = (String)value;
                if (!p.getValue().equals(v)) {
                    p.setValue((String)value);
                    viewer.update(element, VALUE_PROPERTIES);
                }
            }
        });
        this.updateIndexes();
        viewer.setComparator((ViewerComparator)new Comparator());
        viewer.setInput((Object)this.getContextElement());
        return viewer;
    }

    private void updateIndexes() {
        this.nameToIndex.clear();
        EList params = this.getContextElement().getParameters();
        int i = 0;
        while (i < params.size()) {
            this.nameToIndex.put(((Parameter)params.get(i)).getName(), i);
            ++i;
        }
    }

    private void createPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(panel);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)panel);
        Button addButton = toolkit.createButton(panel, "Add", 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addButton);
        addButton.setImage(Images.getImageDescriptor((String)"IMG_OBJ_ADD").createImage());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersContextEditor.this.addNew();
            }
        });
        Button removeButton = toolkit.createButton(panel, "Remove", 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)removeButton);
        removeButton.setImage(Images.getImageDescriptor((String)"IMG_ETOOL_DELETE").createImage());
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)removeButton), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                IViewerObservableList selection = ViewersObservables.observeMultiSelection((Viewer)ParametersContextEditor.this.viewer);
                if (selection.size() == 1 && selection.get(0) == newParameterItem) {
                    return false;
                }
                return !selection.isEmpty();
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParametersContextEditor.this.removeSelected();
            }
        });
    }

    protected void addNew() {
        this.lastNewName = "";
        this.viewer.editElement((Object)newParameterItem, 0);
    }

    protected void removeSelected() {
        ParametersContext ctx = this.getContextElement();
        Object[] selection = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        ArrayList<Object> removed = new ArrayList<Object>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o != newParameterItem) {
                ctx.getParameters().remove(o);
                this.nameToIndex.remove(((Parameter)o).getName());
                removed.add(o);
            }
            ++n2;
        }
        this.viewer.remove(removed.toArray());
    }

    private boolean validateName(Object element, String name) {
        ParametersContext ctx = this.getContextElement();
        Parameter param = (Parameter)element;
        String error = null;
        if (StringUtils.isBlank((String)name)) {
            error = "Blank name";
        } else {
            for (Parameter p : ctx.getParameters()) {
                if (p == param || !p.getName().equals(name)) continue;
                error = "Duplicate parameter name";
                break;
            }
        }
        if (error != null) {
            this.lastNewName = name;
            Rectangle b = this.table.getSelection()[0].getBounds();
            Point p = this.table.toDisplay(b.x, b.y);
            this.tip.setLocation(p.x + 16, p.y + b.height);
            this.tip.setMessage(error);
            this.tip.setVisible(false);
            this.tip.setVisible(true);
            return false;
        }
        this.tip.setVisible(false);
        this.lastNewName = "";
        return true;
    }

    private boolean isNewAndBlank(Object element, String name) {
        return element == newParameterItem && StringUtils.isBlank((String)name);
    }

    public NamedElementEditorActions.INamedElementActions createActions() {
        return this.actions;
    }

    private class Comparator
    extends ViewerComparator {
        private final TableColumn column;
        private final int direction;

        public Comparator() {
            this(null, 0);
        }

        public Comparator(TableColumn column, int direction) {
            this.column = column;
            this.direction = direction;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Parameter a = (Parameter)e1;
            Parameter b = (Parameter)e2;
            if (a == newParameterItem) {
                return 1;
            }
            if (b == newParameterItem) {
                return -1;
            }
            if (this.column == null) {
                return (Integer)ParametersContextEditor.this.nameToIndex.get(a.getName()) - (Integer)ParametersContextEditor.this.nameToIndex.get(b.getName());
            }
            String strA = this.column == ParametersContextEditor.this.nameColumn ? a.getName() : a.getValue();
            String strB = this.column == ParametersContextEditor.this.nameColumn ? b.getName() : b.getValue();
            int r = strA.compareTo(strB);
            return this.direction == 128 ? r : -r;
        }

        public boolean isSorterProperty(Object element, String property) {
            if (this.column == ParametersContextEditor.this.nameColumn) {
                return ParametersContextEditor.NAME_PROPERTY.equals(property);
            }
            if (this.column == ParametersContextEditor.this.valueColumn) {
                return ParametersContextEditor.VALUE_PROPERTY.equals(property);
            }
            return false;
        }
    }

    static class Conflict {
        public final String name;
        public final String value1;
        public final String value2;

        public Conflict(String name, String value1, String value2) {
            this.name = name;
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    class CopyAction
    extends Action {
        private final Clipboard clipboard;

        public CopyAction(Clipboard clipboard) {
            super("Copy selected parameters", sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
            this.clipboard = clipboard;
            ParametersContextEditor.this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CopyAction.this.update();
                }
            });
            this.update();
        }

        public void run() {
            IStructuredSelection selection = (IStructuredSelection)ParametersContextEditor.this.viewer.getSelection();
            Parameter[] parameters = new Parameter[selection.size()];
            Object[] selected = selection.toArray();
            Properties properties = new Properties();
            int i = 0;
            while (i < selection.size()) {
                Parameter parameter;
                parameters[i] = parameter = (Parameter)selected[i];
                properties.put(parameter.getName(), parameter.getValue());
                ++i;
            }
            StringWriter writer = new StringWriter();
            try {
                properties.store(writer, "");
            }
            catch (IOException e) {
                RcpttPlugin.log((Throwable)e);
                writer = new StringWriter();
            }
            this.clipboard.setContents(new Object[]{parameters, writer.getBuffer().toString()}, new Transfer[]{ParametersTransfer.INSTANCE, TextTransfer.getInstance()});
        }

        Object[] getSelection() {
            IStructuredSelection selection = (IStructuredSelection)ParametersContextEditor.this.viewer.getSelection();
            return selection.toArray();
        }

        void update() {
            this.setEnabled(this.getSelection().length > 0);
        }
    }

    class PasteAction
    extends Action {
        private final Clipboard clipboard;

        public PasteAction(Clipboard clipboard) {
            super("Paste", PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_PASTE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
            this.clipboard = clipboard;
            ParametersContextEditor.this.viewer.getControl().addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    PasteAction.this.update();
                }

                public void focusGained(FocusEvent e) {
                    PasteAction.this.update();
                }
            });
            this.update();
        }

        protected void update() {
            this.setEnabled(this.getPasted().length > 0);
        }

        public void run() {
            Map newMap;
            ParametersContext element = ParametersContextEditor.this.getContextElement();
            List<Parameter> newParameters = Arrays.asList(this.getPasted());
            Map origMap = ParametersContextEditor.toDictionary((Collection)element.getParameters());
            Collection conflicts = ParametersContextEditor.findConflicts(origMap, newMap = ParametersContextEditor.toDictionary(newParameters));
            if (conflicts.size() > 0) {
                for (Conflict conflict : conflicts) {
                    newMap.remove(conflict.name);
                }
                if ((conflicts = ParametersContextEditor.this.resolveConflicts(conflicts)) == null) {
                    return;
                }
                for (Conflict conflict : conflicts) {
                    newMap.put(conflict.name, conflict.value2);
                }
            }
            HashMap<String, Parameter> paramMap = new HashMap<String, Parameter>();
            for (Parameter parameter : element.getParameters()) {
                paramMap.put(parameter.getName(), parameter);
            }
            for (Map.Entry entry : newMap.entrySet()) {
                Parameter parameter = (Parameter)paramMap.get(entry.getKey());
                if (parameter == null) {
                    parameter = ParametersFactory.eINSTANCE.createParameter();
                    parameter.setName((String)entry.getKey());
                    element.getParameters().add((Object)parameter);
                }
                parameter.setValue((String)entry.getValue());
            }
            ParametersContextEditor.this.updateIndexes();
            ParametersContextEditor.this.viewer.refresh();
        }

        private Parameter[] getPasted() {
            Parameter[] rv = (Parameter[])this.clipboard.getContents((Transfer)ParametersTransfer.INSTANCE);
            if (rv == null) {
                rv = new Parameter[]{};
            }
            return rv;
        }
    }
}

