/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.architecture.ArchitectureDescriptionUtils;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureContext;
import org.eclipse.papyrus.infra.core.architecture.merged.MergedArchitectureViewpoint;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.ui.architecture.commands.CloseEditorsForViewpointsCommand;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;

public class ChangeArchitectureViewpointsHandler
extends CompoundContributionItem {
    private ILabelProvider provider;

    public ChangeArchitectureViewpointsHandler() {
        ComposedAdapterFactory composedAdapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.provider = new AdapterFactoryLabelProvider((AdapterFactory)composedAdapterFactory);
    }

    public void dispose() {
        this.provider.dispose();
        super.dispose();
    }

    protected IContributionItem[] getContributionItems() {
        EObject selection = this.getSelection();
        if (selection == null) {
            return new IContributionItem[0];
        }
        ResourceSet resourceSet = selection.eResource().getResourceSet();
        if (!(resourceSet instanceof ModelSet)) {
            return new IContributionItem[0];
        }
        final ArchitectureDescriptionUtils helper = new ArchitectureDescriptionUtils((ModelSet)resourceSet);
        MergedArchitectureContext context = helper.getArchitectureContext();
        final HashSet viewpointIds = new HashSet(helper.getArchitectureViewpointIds());
        ArrayList<ActionContributionItem> items = new ArrayList<ActionContributionItem>();
        for (final MergedArchitectureViewpoint viewpoint : context.getViewpoints()) {
            ImageDescriptor desc = ExtendedImageRegistry.getInstance().getImageDescriptor((Object)this.provider.getImage((Object)viewpoint));
            items.add(new ActionContributionItem((IAction)new Action(this.provider.getText((Object)viewpoint), desc){
                {
                    super($anonymous0, $anonymous1);
                    this.setChecked(set.contains(mergedArchitectureViewpoint.getId()));
                }

                public void run() {
                    Collection viewpoints = helper.getArchitectureViewpoints();
                    CompoundCommand cc = new CompoundCommand();
                    if (!this.isChecked()) {
                        viewpointIds.remove(viewpoint.getId());
                        viewpoints.remove(viewpoint);
                    } else {
                        viewpointIds.add(viewpoint.getId());
                        viewpoints.add(viewpoint);
                    }
                    TransactionalEditingDomain ted = helper.getModelSet().getTransactionalEditingDomain();
                    cc.append((Command)new CloseEditorsForViewpointsCommand(viewpoints.stream().filter(viewpoint -> viewpointIds.contains(viewpoint.getId())).collect(Collectors.toList())));
                    cc.append(helper.switchArchitectureViewpointIds(viewpointIds.toArray(new String[0])));
                    ted.getCommandStack().execute((Command)cc);
                }
            }));
        }
        return items.toArray(new IContributionItem[0]);
    }

    protected EObject getSelection() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection struct = (IStructuredSelection)selection;
            Object obj = struct.getFirstElement();
            return EMFHelper.getEObject((Object)obj);
        }
        return null;
    }
}

