/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.internal.resource;

import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.internal.resource.AbstractCrossReferenceIndex;
import org.eclipse.papyrus.infra.emf.internal.resource.CrossReferenceIndexHandler;
import org.eclipse.papyrus.infra.emf.internal.resource.InternalIndexUtil;
import org.eclipse.papyrus.infra.emf.internal.resource.index.IndexManager;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexProvider;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndex;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndexAdapter;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndexEvent;
import org.xml.sax.helpers.DefaultHandler;

public class CrossReferenceIndex
extends AbstractCrossReferenceIndex {
    private static final CrossReferenceIndex INSTANCE = new CrossReferenceIndex();
    private final CopyOnWriteArrayList<Dispatcher> listeners = new CopyOnWriteArrayList();
    private final WorkspaceModelIndex<CrossReferencedFile> index = new WorkspaceModelIndex<CrossReferencedFile>("papyrusCrossRefs", "org.eclipse.emf.ecore.xmi", null, this.indexer(), 5);

    private CrossReferenceIndex() {
        this.index.addListener(new WorkspaceModelIndexAdapter(){

            @Override
            public void indexCalculated(WorkspaceModelIndexEvent event) {
                CrossReferenceIndex.this.indexChanged();
            }

            @Override
            public void indexRecalculated(WorkspaceModelIndexEvent event) {
                CrossReferenceIndex.this.indexChanged();
            }
        });
    }

    public void dispose() {
        this.listeners.clear();
        this.index.dispose();
    }

    public static CrossReferenceIndex getInstance() {
        if (!IndexManager.getInstance().isStarted()) {
            IndexManager.getInstance().startManager();
        }
        return INSTANCE;
    }

    public Runnable onIndexChanged(Consumer<? super CrossReferenceIndex> handler) {
        return this.onIndexChanged(handler, null);
    }

    public Runnable onIndexChanged(Consumer<? super CrossReferenceIndex> handler, Executor exec) {
        Dispatcher dispatcher;
        Runnable result = handler != null ? (this.listeners.add(dispatcher = new Dispatcher(this, handler, exec)) ? dispatcher::dispose : Dispatcher::pass) : Dispatcher::pass;
        return result;
    }

    private void indexChanged() {
        if (!this.listeners.isEmpty()) {
            this.listeners.forEach(Dispatcher::dispatch);
        }
    }

    @Override
    <V> ListenableFuture<V> afterIndex(Callable<V> callable) {
        return this.index.afterIndex(callable);
    }

    @Override
    <V> V ifAvailable(Callable<V> callable, Callable<? extends V> elseCallable) throws CoreException {
        V result = null;
        result = this.index.ifAvailable(this.sync(callable));
        if (result == null && elseCallable != null) {
            try {
                if (InternalIndexUtil.isTracing()) {
                    InternalIndexUtil.tracef("Index not ready. Falling back to %s.", elseCallable.getClass().getSimpleName());
                }
                result = elseCallable.call();
            }
            catch (CoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.infra.emf", e.getMessage(), (Throwable)e));
            }
        }
        return result;
    }

    private void runIndexHandler(IFile file, URI resourceURI, DefaultHandler handler) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream input = file.getContents();){
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                SAXParser parser = factory.newSAXParser();
                parser.parse(input, handler, resourceURI.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            Activator.log.error("Exception in indexing resource", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean indexResource(IFile file, CrossReferencedFile index) {
        boolean result = true;
        URI resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Object object = this.sync;
        synchronized (object) {
            this.unindexResource(file);
            this.resourceToSubunits.putAll((Object)resourceURI, index.getShards());
            this.outgoingReferences.putAll((Object)resourceURI, index.getCrossReferences());
            for (URI next : index.getShards()) {
                this.subunitToParents.put((Object)next, (Object)resourceURI);
            }
            for (URI next : index.getCrossReferences()) {
                this.incomingReferences.put((Object)next, (Object)resourceURI);
            }
            this.setShard(resourceURI, index.isShard());
        }
        return result;
    }

    private CrossReferencedFile indexResource(IFile file) {
        URI resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        CrossReferenceIndexHandler handler = new CrossReferenceIndexHandler(resourceURI);
        this.runIndexHandler(file, resourceURI, handler);
        CrossReferencedFile result = new CrossReferencedFile(handler);
        this.indexResource(file, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unindexResource(IFile file) {
        URI resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Object object = this.sync;
        synchronized (object) {
            this.aggregateResourceToSubunits = null;
            this.aggregateSubunitToParents = null;
            this.aggregateOutgoingReferences = null;
            this.aggregateIncomingReferences = null;
            this.setShard(resourceURI, false);
            this.resourceToSubunits.removeAll((Object)resourceURI);
            this.outgoingReferences.removeAll((Object)resourceURI);
            for (URI next : new ArrayList(this.subunitToParents.keySet())) {
                this.subunitToParents.remove((Object)next, (Object)resourceURI);
            }
            for (URI next : new ArrayList(this.incomingReferences.keySet())) {
                this.incomingReferences.remove((Object)next, (Object)resourceURI);
            }
        }
    }

    private WorkspaceModelIndex.PersistentIndexHandler<CrossReferencedFile> indexer() {
        return new WorkspaceModelIndex.PersistentIndexHandler<CrossReferencedFile>(){

            @Override
            public CrossReferencedFile index(IFile file) {
                return CrossReferenceIndex.this.indexResource(file);
            }

            @Override
            public void unindex(IFile file) {
                CrossReferenceIndex.this.unindexResource(file);
            }

            @Override
            public boolean load(IFile file, CrossReferencedFile index) {
                return CrossReferenceIndex.this.indexResource(file, index);
            }
        };
    }

    static final class CrossReferencedFile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean isShard;
        private Set<String> crossReferences;
        private Set<String> shards;
        private transient Set<URI> crossReferenceURIs;
        private transient Set<URI> shardURIs;

        CrossReferencedFile(CrossReferenceIndexHandler handler) {
            this.isShard = handler.isShard();
            this.crossReferences = handler.getCrossReferences();
            this.shards = handler.getSubunits();
        }

        boolean isShard() {
            return this.isShard;
        }

        Set<URI> getCrossReferences() {
            if (this.crossReferenceURIs == null) {
                this.crossReferenceURIs = this.crossReferences.stream().map(URI::createURI).collect(Collectors.toSet());
            }
            return this.crossReferenceURIs;
        }

        Set<URI> getShards() {
            if (this.shardURIs == null) {
                this.shardURIs = this.shards.stream().map(URI::createURI).collect(Collectors.toSet());
            }
            return this.shardURIs;
        }
    }

    private static final class Dispatcher {
        private final CrossReferenceIndex owner;
        private final Consumer<? super CrossReferenceIndex> handler;
        private final Executor exec;

        Dispatcher(CrossReferenceIndex owner, Consumer<? super CrossReferenceIndex> handler, Executor exec) {
            this.owner = owner;
            this.handler = handler;
            this.exec = exec;
        }

        static void pass() {
        }

        public void dispose() {
            this.owner.listeners.remove(this);
        }

        void dispatch() {
            if (this.exec == null) {
                this.handler.accept(this.owner);
            } else {
                this.exec.execute(() -> this.handler.accept(this.owner));
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exec == null ? 0 : this.exec.hashCode());
            result = 31 * result + (this.handler == null ? 0 : this.handler.hashCode());
            result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Dispatcher other = (Dispatcher)obj;
            if (this.exec == null ? other.exec != null : !this.exec.equals(other.exec)) {
                return false;
            }
            if (this.handler == null ? other.handler != null : !this.handler.equals(other.handler)) {
                return false;
            }
            return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
        }
    }

    public static final class IndexProvider
    implements IWorkspaceModelIndexProvider {
        @Override
        public WorkspaceModelIndex<?> get() {
            return CrossReferenceIndex.INSTANCE.index;
        }
    }
}

